/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.run;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.luminis.quic.Version;
import net.luminis.quic.log.BaseLogger;
import net.luminis.quic.log.FileLogger;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.SysOutLogger;
import net.luminis.quic.run.KwikVersion;
import net.luminis.quic.server.ApplicationProtocolConnectionFactory;
import net.luminis.quic.server.ServerConnector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SampleWebServer {
    private static void usageAndExit() {
        System.err.println("Usage: [--noRetry] cert file, cert key file, port number, www dir");
        System.exit(1);
    }

    public static void main(String[] rawArgs) throws Exception {
        File certificateKeyFile;
        File logDir;
        Options cmdLineOptions = new Options();
        cmdLineOptions.addOption(null, "noRetry", false, "disable always use retry");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(cmdLineOptions, rawArgs);
        }
        catch (ParseException argError) {
            System.out.println("Invalid argument: " + argError.getMessage());
            SampleWebServer.usageAndExit();
        }
        List args = cmd.getArgList();
        if (args.size() < 4) {
            SampleWebServer.usageAndExit();
        }
        BaseLogger log = (logDir = new File("/logs")).exists() && logDir.isDirectory() && logDir.canWrite() ? new FileLogger(new File(logDir, "kwikserver.log")) : new SysOutLogger();
        log.timeFormat(Logger.TimeFormat.Long);
        log.logWarning(true);
        log.logInfo(true);
        File certificateFile = new File((String)args.get(0));
        if (!certificateFile.exists()) {
            System.err.println("Cannot open certificate file " + (String)args.get(0));
            System.exit(1);
        }
        if (!(certificateKeyFile = new File((String)args.get(1))).exists()) {
            System.err.println("Cannot open certificate file " + (String)args.get(1));
            System.exit(1);
        }
        int port = Integer.parseInt((String)args.get(2));
        File wwwDir = new File((String)args.get(3));
        if (!(wwwDir.exists() && wwwDir.isDirectory() && wwwDir.canRead())) {
            System.err.println("Cannot read www dir '" + wwwDir + "'");
            System.exit(1);
        }
        ArrayList<Version> supportedVersions = new ArrayList<Version>();
        supportedVersions.add(Version.QUIC_version_1);
        supportedVersions.add(Version.QUIC_version_2);
        boolean requireRetry = !cmd.hasOption("noRetry");
        ServerConnector serverConnector = new ServerConnector(port, (InputStream)new FileInputStream(certificateFile), (InputStream)new FileInputStream(certificateKeyFile), supportedVersions, requireRetry, (Logger)log);
        SampleWebServer.registerHttp3(serverConnector, wwwDir, supportedVersions, log);
        serverConnector.start();
        log.info("Kwik server " + KwikVersion.getVersion() + " started; supported application protcols: " + serverConnector.getRegisteredApplicationProtocols());
    }

    private static void registerHttp3(ServerConnector serverConnector, File wwwDir, List<Version> supportedVersions, Logger log) {
        ApplicationProtocolConnectionFactory http3ApplicationProtocolConnectionFactory = null;
        try {
            Class<?> http3FactoryClass = SampleWebServer.class.getClassLoader().loadClass("net.luminis.http3.server.Http3ApplicationProtocolFactory");
            http3ApplicationProtocolConnectionFactory = (ApplicationProtocolConnectionFactory)http3FactoryClass.getDeclaredConstructor(File.class).newInstance(wwwDir);
            log.info("Loading Flupke H3 server plugin");
            serverConnector.registerApplicationProtocol("h3", http3ApplicationProtocolConnectionFactory);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("No H3 protocol: Flupke plugin not found.");
            System.exit(1);
        }
    }
}

