/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.sample.echo;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.luminis.quic.QuicClientConnection;
import net.luminis.quic.QuicStream;
import net.luminis.quic.log.SysOutLogger;

public class SimpleEchoClient {
    private int serverPort;
    private QuicClientConnection connection;

    public static void main(String[] args) throws IOException {
        SimpleEchoClient client = null;
        try {
            client = new SimpleEchoClient(Integer.parseInt(args[0]));
        }
        catch (Exception e) {
            System.err.println("Error: expected one argument: server-port-number");
            System.exit(1);
        }
        client.run();
    }

    public SimpleEchoClient(int serverPort) {
        this.serverPort = serverPort;
    }

    public void run() throws IOException {
        SysOutLogger log = new SysOutLogger();
        this.connection = QuicClientConnection.newBuilder().uri(URI.create("echo://localhost:" + this.serverPort)).logger(log).noServerCertificateCheck().build();
        this.connection.connect(5000, "echo");
        this.echo("hello mate!");
        this.echo("look, a second request on a separate stream!");
        this.connection.closeAndWait();
    }

    private void echo(String payload) throws IOException {
        QuicStream quicStream = this.connection.createStream(true);
        byte[] requestData = payload.getBytes(StandardCharsets.US_ASCII);
        quicStream.getOutputStream().write(requestData);
        quicStream.getOutputStream().close();
        System.out.print("Response from server: ");
        quicStream.getInputStream().transferTo(System.out);
        System.out.println();
    }
}

