/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.send;

import java.util.Optional;
import net.luminis.quic.AckGenerator;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.VersionHolder;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.send.PacketAssembler;
import net.luminis.quic.send.SendItem;
import net.luminis.quic.send.SendRequestQueue;

public class InitialPacketAssembler
extends PacketAssembler {
    protected byte[] initialToken;

    public InitialPacketAssembler(VersionHolder version, SendRequestQueue requestQueue, AckGenerator ackGenerator) {
        super(version, EncryptionLevel.Initial, requestQueue, ackGenerator);
    }

    @Override
    Optional<SendItem> assemble(int remainingCwndSize, int availablePacketSize, byte[] sourceConnectionId, byte[] destinationConnectionId) {
        if (availablePacketSize < 1200) {
            return Optional.empty();
        }
        return super.assemble(remainingCwndSize, availablePacketSize, sourceConnectionId, destinationConnectionId);
    }

    @Override
    protected QuicPacket createPacket(byte[] sourceConnectionId, byte[] destinationConnectionId) {
        InitialPacket packet = new InitialPacket(this.quicVersion.getVersion(), sourceConnectionId, destinationConnectionId, this.initialToken, (QuicFrame)null);
        packet.setPacketNumber(this.nextPacketNumber());
        return packet;
    }

    public void setInitialToken(byte[] initialToken) {
        this.initialToken = initialToken;
    }
}

