/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.send;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.luminis.quic.AckGenerator;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.VersionHolder;
import net.luminis.quic.frame.AckFrame;
import net.luminis.quic.frame.PingFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.packet.HandshakePacket;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.packet.ShortHeaderPacket;
import net.luminis.quic.packet.ZeroRttPacket;
import net.luminis.quic.send.PacketNumberGenerator;
import net.luminis.quic.send.SendItem;
import net.luminis.quic.send.SendRequest;
import net.luminis.quic.send.SendRequestQueue;

public class PacketAssembler {
    protected static final Consumer<QuicFrame> EMPTY_CALLBACK = f -> {};
    protected final VersionHolder quicVersion;
    protected final EncryptionLevel level;
    protected final SendRequestQueue requestQueue;
    protected final AckGenerator ackGenerator;
    private final PacketNumberGenerator packetNumberGenerator;
    protected long nextPacketNumber;
    private volatile boolean stopping;
    private Consumer<PacketAssembler> finalizerCallback;

    public PacketAssembler(VersionHolder version, EncryptionLevel level, SendRequestQueue requestQueue, AckGenerator ackGenerator) {
        this(version, level, requestQueue, ackGenerator, new PacketNumberGenerator());
    }

    public PacketAssembler(VersionHolder version, EncryptionLevel level, SendRequestQueue requestQueue, AckGenerator ackGenerator, PacketNumberGenerator pnGenerator) {
        this.quicVersion = version;
        this.level = level;
        this.requestQueue = requestQueue;
        this.ackGenerator = ackGenerator;
        this.packetNumberGenerator = pnGenerator;
    }

    Optional<SendItem> assemble(int remainingCwndSize, int availablePacketSize, byte[] sourceConnectionId, byte[] destinationConnectionId) {
        Optional<SendItem> assembledItem;
        int available = Integer.min(remainingCwndSize, availablePacketSize);
        QuicPacket packet = this.createPacket(sourceConnectionId, destinationConnectionId);
        ArrayList<Consumer<QuicFrame>> callbacks = new ArrayList<Consumer<QuicFrame>>();
        AckFrame ackFrame = null;
        if (this.requestQueue.mustAndWillSendAck() && this.ackGenerator.hasNewAckToSend()) {
            ackFrame = this.ackGenerator.generateAck().get();
            if (packet.estimateLength(ackFrame.getFrameLength()) <= availablePacketSize) {
                packet.addFrame(ackFrame);
                callbacks.add(EMPTY_CALLBACK);
                this.ackGenerator.registerAckSendWithPacket(ackFrame, packet.getPacketNumber());
            } else {
                this.requestQueue.addAckRequest();
                return Optional.empty();
            }
        }
        int optionalAckSize = 0;
        if (ackFrame == null && this.requestQueue.hasRequests() && this.ackGenerator.hasAckToSend() && (ackFrame = (AckFrame)this.ackGenerator.generateAck().orElse(null)) != null) {
            optionalAckSize = ackFrame.getFrameLength();
        }
        if (this.requestQueue.hasProbeWithData()) {
            List<QuicFrame> probeData = this.requestQueue.getProbe();
            int estimatedSize = packet.estimateLength(probeData.stream().mapToInt(f -> f.getFrameLength()).sum());
            if (estimatedSize > availablePacketSize) {
                PingFrame probeFrame = new PingFrame();
                if (packet.estimateLength(((QuicFrame)probeFrame).getFrameLength()) > availablePacketSize) {
                    return Optional.empty();
                }
                probeData = List.of(probeFrame);
            }
            packet.setIsProbe(true);
            packet.addFrames(probeData);
            return Optional.of(new SendItem(packet));
        }
        if (this.requestQueue.hasRequests()) {
            int estimatedSize = packet.estimateLength(1000) - 1000;
            while (estimatedSize < available) {
                int proposedSize = available - estimatedSize - optionalAckSize;
                Optional<SendRequest> next = this.requestQueue.next(proposedSize);
                if (next.isEmpty() && optionalAckSize > 0) {
                    proposedSize = available - estimatedSize;
                    next = this.requestQueue.next(proposedSize);
                }
                if (next.isEmpty()) break;
                QuicFrame nextFrame = next.get().getFrameSupplier().apply(proposedSize);
                if (nextFrame == null) continue;
                if (nextFrame.getFrameLength() > proposedSize) {
                    throw new RuntimeException("supplier does not produce frame of right (max) size: " + nextFrame.getFrameLength() + " > " + proposedSize + " frame: " + nextFrame);
                }
                packet.addFrame(nextFrame);
                callbacks.add(next.get().getLostCallback());
                if (optionalAckSize <= 0 || (estimatedSize += nextFrame.getFrameLength()) + optionalAckSize > available) continue;
                packet.addFrame(ackFrame);
                callbacks.add(EMPTY_CALLBACK);
                this.ackGenerator.registerAckSendWithPacket(ackFrame, packet.getPacketNumber());
                estimatedSize += ackFrame.getFrameLength();
                optionalAckSize = 0;
            }
        }
        if (this.requestQueue.hasProbe() && packet.getFrames().isEmpty()) {
            this.requestQueue.getProbe();
            packet.setIsProbe(true);
            packet.addFrame(new PingFrame());
            callbacks.add(EMPTY_CALLBACK);
        }
        if (packet.getFrames().isEmpty()) {
            this.restorePacketNumber();
            assembledItem = Optional.empty();
        } else {
            assembledItem = Optional.of(new SendItem(packet, this.createPacketLostCallback(packet, callbacks)));
        }
        if (this.stopping && this.requestQueue.isEmpty(false) && this.finalizerCallback != null) {
            this.finalizerCallback.accept(this);
        }
        return assembledItem;
    }

    protected long nextPacketNumber() {
        return this.packetNumberGenerator.nextPacketNumber();
    }

    protected void restorePacketNumber() {
        this.packetNumberGenerator.restorePacketNumber();
    }

    private Consumer<QuicPacket> createPacketLostCallback(QuicPacket packet, List<Consumer<QuicFrame>> callbacks) {
        if (packet.getFrames().size() != callbacks.size()) {
            throw new IllegalStateException();
        }
        return lostPacket -> {
            for (int i = 0; i < callbacks.size(); ++i) {
                if (callbacks.get(i) == EMPTY_CALLBACK) continue;
                QuicFrame lostFrame = lostPacket.getFrames().get(i);
                ((Consumer)callbacks.get(i)).accept(lostFrame);
            }
        };
    }

    protected QuicPacket createPacket(byte[] sourceConnectionId, byte[] destinationConnectionId) {
        QuicPacket packet;
        switch (this.level) {
            case Handshake: {
                packet = new HandshakePacket(this.quicVersion.getVersion(), sourceConnectionId, destinationConnectionId, null);
                break;
            }
            case App: {
                packet = new ShortHeaderPacket(this.quicVersion.getVersion(), destinationConnectionId, null);
                break;
            }
            case ZeroRTT: {
                packet = new ZeroRttPacket(this.quicVersion.getVersion(), sourceConnectionId, destinationConnectionId, (QuicFrame)null);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        packet.setPacketNumber(this.nextPacketNumber());
        return packet;
    }

    public void stop(Consumer<PacketAssembler> finalizer) {
        this.finalizerCallback = finalizer;
        this.requestQueue.clear(false);
        this.stopping = true;
    }

    public String toString() {
        return "PacketAssembler[" + this.level + "]";
    }
}

