/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.server;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.Role;
import net.luminis.quic.Version;
import net.luminis.quic.VersionHolder;
import net.luminis.quic.crypto.Aead;
import net.luminis.quic.crypto.ConnectionSecrets;
import net.luminis.quic.log.Logger;
import net.luminis.quic.log.NullLogger;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.server.Context;
import net.luminis.quic.server.ServerConnectionFactory;
import net.luminis.quic.server.ServerConnectionImpl;
import net.luminis.quic.server.ServerConnectionProxy;
import net.luminis.quic.server.ServerConnectionRegistry;
import net.luminis.tls.util.ByteUtils;

public class ServerConnectionCandidate
implements ServerConnectionProxy {
    private final Version quicVersion;
    private final InetSocketAddress clientAddress;
    private final byte[] dcid;
    private final ServerConnectionFactory serverConnectionFactory;
    private final ServerConnectionRegistry connectionRegistry;
    private final Logger log;
    private volatile ServerConnectionProxy registeredConnection;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;

    public ServerConnectionCandidate(Context context, Version version, InetSocketAddress clientAddress, byte[] scid, byte[] dcid, ServerConnectionFactory serverConnectionFactory, ServerConnectionRegistry connectionRegistry, Logger log) {
        this.executor = context.getSharedServerExecutor();
        this.scheduledExecutor = context.getSharedScheduledExecutor();
        this.quicVersion = version;
        this.clientAddress = clientAddress;
        this.dcid = dcid;
        this.serverConnectionFactory = serverConnectionFactory;
        this.connectionRegistry = connectionRegistry;
        this.log = log;
    }

    @Override
    public byte[] getOriginalDestinationConnectionId() {
        return this.dcid;
    }

    @Override
    public void parsePackets(int datagramNumber, Instant timeReceived, ByteBuffer data) {
        this.executor.submit(() -> {
            ServerConnectionCandidate serverConnectionCandidate = this;
            synchronized (serverConnectionCandidate) {
                if (this.registeredConnection != null) {
                    this.registeredConnection.parsePackets(datagramNumber, timeReceived, data);
                    return;
                }
                try {
                    InitialPacket initialPacket = this.parseInitialPacket(datagramNumber, timeReceived, data);
                    this.log.received(timeReceived, datagramNumber, initialPacket);
                    this.log.debug("Parsed packet with size " + data.position() + "; " + data.remaining() + " bytes left.");
                    if (this.registeredConnection == null) {
                        data.rewind();
                        this.createAndRegisterServerConnection(initialPacket, timeReceived, data);
                    }
                }
                catch (DecryptionException | InvalidPacketException cannotParsePacket) {
                    this.log.debug("Dropped invalid initial packet (no connection created)");
                    this.scheduledExecutor.schedule(() -> {
                        if (this.registeredConnection == null) {
                            this.connectionRegistry.deregisterConnection(this, this.dcid);
                        }
                    }, 30L, TimeUnit.SECONDS);
                }
                catch (Exception error) {
                    this.log.error("error while parsing or processing initial packet", error);
                }
            }
        });
    }

    private void createAndRegisterServerConnection(InitialPacket initialPacket, Instant timeReceived, ByteBuffer data) {
        Version quicVersion = initialPacket.getVersion();
        byte[] originalDcid = initialPacket.getDestinationConnectionId();
        ServerConnectionImpl connection = this.serverConnectionFactory.createNewConnection(quicVersion, this.clientAddress, initialPacket.getSourceConnectionId(), originalDcid);
        this.log.info("Creating new connection with version " + quicVersion + " for odcid " + ByteUtils.bytesToHex((byte[])originalDcid) + " with " + this.clientAddress.getAddress().getHostAddress() + ": " + ByteUtils.bytesToHex((byte[])connection.getInitialConnectionId()));
        this.registeredConnection = this.serverConnectionFactory.createServerConnectionProxy(connection, initialPacket, timeReceived, data);
        this.connectionRegistry.registerConnection(this.registeredConnection, connection.getInitialConnectionId());
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void terminate() {
    }

    InitialPacket parseInitialPacket(int datagramNumber, Instant timeReceived, ByteBuffer data) throws InvalidPacketException, DecryptionException {
        if (data.limit() < 1200) {
            throw new InvalidPacketException("Initial packets is carried in a datagram that is smaller than 1200 (" + data.limit() + ")");
        }
        byte flags = data.get();
        data.rewind();
        if ((flags & 0x40) != 64) {
            throw new InvalidPacketException();
        }
        if (InitialPacket.isInitial((flags & 0x30) >> 4, this.quicVersion)) {
            InitialPacket packet = new InitialPacket(this.quicVersion);
            ConnectionSecrets connectionSecrets = new ConnectionSecrets(new VersionHolder(this.quicVersion), Role.Server, null, new NullLogger());
            byte[] originalDcid = this.dcid;
            connectionSecrets.computeInitialKeys(originalDcid);
            Aead aead = connectionSecrets.getPeerAead(packet.getEncryptionLevel());
            packet.parse(data, aead, 0L, new NullLogger(), 0);
            return packet;
        }
        throw new InvalidPacketException();
    }

    public String toString() {
        return "ServerConnectionCandidate[" + ByteUtils.bytesToHex((byte[])this.dcid) + "]";
    }
}

