/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.server;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.luminis.quic.CryptoStream;
import net.luminis.quic.DecryptionException;
import net.luminis.quic.EncryptionLevel;
import net.luminis.quic.GlobalAckGenerator;
import net.luminis.quic.HandshakeState;
import net.luminis.quic.IdleTimer;
import net.luminis.quic.InvalidPacketException;
import net.luminis.quic.MissingKeysException;
import net.luminis.quic.PacketProcessor;
import net.luminis.quic.PnSpace;
import net.luminis.quic.QuicConnectionImpl;
import net.luminis.quic.QuicConstants;
import net.luminis.quic.QuicStream;
import net.luminis.quic.Role;
import net.luminis.quic.TransportError;
import net.luminis.quic.TransportParameters;
import net.luminis.quic.Version;
import net.luminis.quic.cid.ConnectionIdManager;
import net.luminis.quic.frame.HandshakeDoneFrame;
import net.luminis.quic.frame.NewConnectionIdFrame;
import net.luminis.quic.frame.NewTokenFrame;
import net.luminis.quic.frame.QuicFrame;
import net.luminis.quic.frame.RetireConnectionIdFrame;
import net.luminis.quic.log.LogProxy;
import net.luminis.quic.log.Logger;
import net.luminis.quic.packet.HandshakePacket;
import net.luminis.quic.packet.InitialPacket;
import net.luminis.quic.packet.LongHeaderPacket;
import net.luminis.quic.packet.QuicPacket;
import net.luminis.quic.packet.RetryPacket;
import net.luminis.quic.packet.ShortHeaderPacket;
import net.luminis.quic.packet.VersionNegotiationPacket;
import net.luminis.quic.packet.ZeroRttPacket;
import net.luminis.quic.send.SenderImpl;
import net.luminis.quic.server.ApplicationProtocolRegistry;
import net.luminis.quic.server.ServerConnection;
import net.luminis.quic.server.ServerConnectionRegistry;
import net.luminis.quic.stream.FlowControl;
import net.luminis.quic.stream.StreamManager;
import net.luminis.quic.tls.QuicTransportParametersExtension;
import net.luminis.tls.NewSessionTicket;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.TrafficSecrets;
import net.luminis.tls.alert.MissingExtensionAlert;
import net.luminis.tls.alert.NoApplicationProtocolAlert;
import net.luminis.tls.extension.ApplicationLayerProtocolNegotiationExtension;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.handshake.CertificateMessage;
import net.luminis.tls.handshake.CertificateVerifyMessage;
import net.luminis.tls.handshake.EncryptedExtensions;
import net.luminis.tls.handshake.FinishedMessage;
import net.luminis.tls.handshake.HandshakeMessage;
import net.luminis.tls.handshake.NewSessionTicketMessage;
import net.luminis.tls.handshake.ServerHello;
import net.luminis.tls.handshake.ServerMessageSender;
import net.luminis.tls.handshake.TlsEngine;
import net.luminis.tls.handshake.TlsServerEngine;
import net.luminis.tls.handshake.TlsServerEngineFactory;
import net.luminis.tls.handshake.TlsStatusEventHandler;
import net.luminis.tls.util.ByteUtils;

public class ServerConnectionImpl
extends QuicConnectionImpl
implements ServerConnection,
TlsStatusEventHandler {
    private static final int TOKEN_SIZE = 37;
    private final Random random;
    private final SenderImpl sender;
    private final Version originalVersion;
    private final InetSocketAddress initialClientAddress;
    private final boolean retryRequired;
    private final GlobalAckGenerator ackGenerator;
    private final TlsServerEngine tlsEngine;
    private final ApplicationProtocolRegistry applicationProtocolRegistry;
    private final Consumer<ServerConnectionImpl> closeCallback;
    private final StreamManager streamManager;
    private final int initialMaxStreamData;
    private final int maxOpenStreamsUni;
    private final int maxOpenStreamsBidi;
    private final byte[] token;
    private final ConnectionIdManager connectionIdManager;
    private volatile String negotiatedApplicationProtocol;
    private int maxIdleTimeoutInSeconds;
    private volatile long bytesReceived;
    private volatile boolean addressValidated;
    private boolean acceptEarlyData = true;
    private boolean acceptedEarlyData = false;
    private int allowedClientConnectionIds = 3;

    protected ServerConnectionImpl(Version originalVersion, DatagramSocket serverSocket, InetSocketAddress initialClientAddress, byte[] peerCid, byte[] originalDcid, int connectionIdLength, TlsServerEngineFactory tlsServerEngineFactory, boolean retryRequired, ApplicationProtocolRegistry applicationProtocolRegistry, Integer initialRtt, ServerConnectionRegistry connectionRegistry, Consumer<ServerConnectionImpl> closeCallback, Logger log) {
        super(originalVersion, Role.Server, null, new LogProxy(log, originalDcid));
        this.originalVersion = originalVersion;
        this.initialClientAddress = initialClientAddress;
        this.retryRequired = retryRequired;
        this.applicationProtocolRegistry = applicationProtocolRegistry;
        this.closeCallback = closeCallback;
        this.tlsEngine = tlsServerEngineFactory.createServerEngine((ServerMessageSender)new TlsMessageSender(), (TlsStatusEventHandler)this);
        this.tlsEngine.addSupportedCiphers(List.of(TlsConstants.CipherSuite.TLS_AES_128_GCM_SHA256, TlsConstants.CipherSuite.TLS_AES_256_GCM_SHA384, TlsConstants.CipherSuite.TLS_CHACHA20_POLY1305_SHA256));
        this.idleTimer = new IdleTimer(this, log);
        this.sender = new SenderImpl(this.quicVersion, ServerConnectionImpl.getMaxPacketSize(), serverSocket, initialClientAddress, this, initialRtt, this.log);
        if (!retryRequired) {
            this.sender.setAntiAmplificationLimit(0);
        }
        this.idleTimer.setPtoSupplier(this.sender::getPto);
        BiConsumer<Integer, String> closeWithErrorFunction = (error, reason) -> this.immediateCloseWithError(EncryptionLevel.App, error.intValue(), (String)reason);
        this.connectionIdManager = new ConnectionIdManager(peerCid, originalDcid, connectionIdLength, this.allowedClientConnectionIds, connectionRegistry, this.sender, closeWithErrorFunction, log);
        this.ackGenerator = this.sender.getGlobalAckGenerator();
        if (retryRequired) {
            this.random = new SecureRandom();
            this.token = new byte[37];
            this.random.nextBytes(this.token);
        } else {
            this.random = null;
            this.token = null;
        }
        this.connectionSecrets.computeInitialKeys(originalDcid);
        this.sender.start(this.connectionSecrets);
        this.maxIdleTimeoutInSeconds = 30;
        this.initialMaxStreamData = 1000000;
        this.maxOpenStreamsUni = 10;
        this.maxOpenStreamsBidi = 100;
        this.streamManager = new StreamManager(this, Role.Server, log, this.maxOpenStreamsUni, this.maxOpenStreamsBidi);
        this.log.getQLog().emitConnectionCreatedEvent(Instant.now());
    }

    @Override
    public void abortConnection(Throwable error) {
        this.log.error(this.toString() + " aborted due to internal error", error);
        this.closeCallback.accept(this);
    }

    @Override
    protected SenderImpl getSender() {
        return this.sender;
    }

    @Override
    protected TlsEngine getTlsEngine() {
        return this.tlsEngine;
    }

    @Override
    protected GlobalAckGenerator getAckGenerator() {
        return this.ackGenerator;
    }

    @Override
    protected StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Override
    public long getInitialMaxStreamData() {
        return this.initialMaxStreamData;
    }

    @Override
    public int getMaxShortHeaderPacketOverhead() {
        return 1 + this.connectionIdManager.getCurrentPeerConnectionId().length + 4 + 16;
    }

    @Override
    protected int getSourceConnectionIdLength() {
        return this.connectionIdManager.getInitialConnectionId().length;
    }

    @Override
    protected void cryptoProcessingErrorOcurred(TlsProtocolException exception) {
    }

    public byte[] getInitialConnectionId() {
        return this.connectionIdManager.getInitialConnectionId();
    }

    @Override
    public byte[] getSourceConnectionId() {
        return this.connectionIdManager.getInitialConnectionId();
    }

    @Override
    public byte[] getDestinationConnectionId() {
        return this.connectionIdManager.getCurrentPeerConnectionId();
    }

    public void earlySecretsKnown() {
        this.connectionSecrets.computeEarlySecrets((TrafficSecrets)this.tlsEngine, this.tlsEngine.getSelectedCipher(), this.originalVersion);
    }

    public void handshakeSecretsKnown() {
        this.connectionSecrets.computeHandshakeSecrets((TrafficSecrets)this.tlsEngine, this.tlsEngine.getSelectedCipher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeFinished() {
        this.connectionSecrets.computeApplicationSecrets((TrafficSecrets)this.tlsEngine);
        this.sender.enableAppLevel();
        this.getSender().discard(PnSpace.Handshake, "tls handshake confirmed");
        this.sendHandshakeDone(new HandshakeDoneFrame(this.quicVersion.getVersion()));
        this.connectionState = QuicConnectionImpl.Status.Connected;
        Object object = this.handshakeStateLock;
        synchronized (object) {
            if (this.handshakeState.transitionAllowed(HandshakeState.Confirmed)) {
                this.handshakeState = HandshakeState.Confirmed;
                this.handshakeStateListeners.forEach(l -> l.handshakeStateChangedEvent(this.handshakeState));
            } else {
                this.log.debug("Handshake state cannot be set to Confirmed");
            }
        }
        if (!this.acceptedEarlyData) {
            this.applicationProtocolRegistry.startApplicationProtocolConnection(this.negotiatedApplicationProtocol, this);
        }
        this.connectionIdManager.handshakeFinished();
    }

    private void sendHandshakeDone(QuicFrame frame) {
        this.send(frame, this::sendHandshakeDone);
    }

    public void newSessionTicketReceived(NewSessionTicket ticket) {
    }

    public void extensionsReceived(List<Extension> extensions) throws TlsProtocolException {
        Optional<Extension> alpnExtension = extensions.stream().filter(ext -> ext instanceof ApplicationLayerProtocolNegotiationExtension).findFirst();
        if (alpnExtension.isEmpty()) {
            throw new MissingExtensionAlert("missing application layer protocol negotiation extension");
        }
        List requestedProtocols = ((ApplicationLayerProtocolNegotiationExtension)alpnExtension.get()).getProtocols();
        Optional<String> applicationProtocol = this.applicationProtocolRegistry.selectSupportedApplicationProtocol(requestedProtocols);
        applicationProtocol.map(protocol -> {
            this.tlsEngine.addServerExtensions((Extension)new ApplicationLayerProtocolNegotiationExtension(protocol));
            return protocol;
        }).map(selectedProtocol -> {
            this.negotiatedApplicationProtocol = selectedProtocol;
            return this.negotiatedApplicationProtocol;
        }).orElseThrow(() -> new NoApplicationProtocolAlert(requestedProtocols));
        Optional<Extension> tpExtension = extensions.stream().filter(ext -> ext instanceof QuicTransportParametersExtension).findFirst();
        if (tpExtension.isEmpty()) {
            throw new MissingExtensionAlert("missing quic transport parameters extension");
        }
        try {
            this.validateAndProcess(((QuicTransportParametersExtension)tpExtension.get()).getTransportParameters());
        }
        catch (TransportError transportParameterError) {
            throw new TlsProtocolException("transport parameter error", (Throwable)transportParameterError);
        }
        TransportParameters serverTransportParams = new TransportParameters(this.maxIdleTimeoutInSeconds, this.initialMaxStreamData, this.maxOpenStreamsBidi, this.maxOpenStreamsUni);
        serverTransportParams.setVersionInformation(new TransportParameters.VersionInformation(this.quicVersion.getVersion(), List.of(Version.QUIC_version_1, Version.QUIC_version_2)));
        serverTransportParams.setActiveConnectionIdLimit(this.allowedClientConnectionIds);
        serverTransportParams.setDisableMigration(true);
        serverTransportParams.setInitialSourceConnectionId(this.connectionIdManager.getInitialConnectionId());
        serverTransportParams.setOriginalDestinationConnectionId(this.connectionIdManager.getOriginalDestinationConnectionId());
        if (this.retryRequired) {
            serverTransportParams.setRetrySourceConnectionId(this.connectionIdManager.getInitialConnectionId());
        }
        this.tlsEngine.setSelectedApplicationLayerProtocol(this.negotiatedApplicationProtocol);
        this.tlsEngine.addServerExtensions((Extension)new QuicTransportParametersExtension(this.quicVersion.getVersion(), serverTransportParams, Role.Server));
        this.tlsEngine.setSessionData(this.quicVersion.getVersion().getBytes());
        this.tlsEngine.setSessionDataVerificationCallback(this::acceptSessionResumption);
    }

    boolean acceptSessionResumption(ByteBuffer storedSessionData) {
        if (this.quicVersion.getVersion().equals(Version.parse(storedSessionData.getInt()))) {
            return true;
        }
        this.log.warn("Resumed session denied because quic versions don't match");
        return false;
    }

    public boolean isEarlyDataAccepted() {
        if (this.acceptEarlyData) {
            this.acceptedEarlyData = true;
            this.applicationProtocolRegistry.startApplicationProtocolConnection(this.negotiatedApplicationProtocol, this);
            this.log.info("Server accepted early data");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected QuicPacket parsePacket(ByteBuffer data) throws MissingKeysException, DecryptionException, InvalidPacketException {
        try {
            return super.parsePacket(data);
        }
        catch (DecryptionException decryptionException) {
            Version connectionVersion = this.quicVersion.getVersion();
            if (this.retryRequired && LongHeaderPacket.isLongHeaderPacket(data.get(0), connectionVersion) && InitialPacket.isInitial((data.get(0) & 0x30) >> 4, connectionVersion)) {
                try {
                    data.rewind();
                    this.connectionSecrets.computeInitialKeys(this.connectionIdManager.getOriginalDestinationConnectionId());
                    QuicPacket quicPacket = super.parsePacket(data);
                    return quicPacket;
                }
                finally {
                    this.connectionSecrets.computeInitialKeys(this.connectionIdManager.getInitialConnectionId());
                }
            }
            throw decryptionException;
        }
    }

    @Override
    public void parseAndProcessPackets(int datagram, Instant timeReceived, ByteBuffer data, QuicPacket parsedPacket) {
        if (InitialPacket.isInitial(data) && data.limit() < 1200) {
            return;
        }
        this.bytesReceived += (long)data.remaining();
        if (!this.addressValidated) {
            this.sender.setAntiAmplificationLimit(3 * (int)this.bytesReceived);
        }
        super.parseAndProcessPackets(datagram, timeReceived, data, parsedPacket);
    }

    @Override
    public PacketProcessor.ProcessResult process(InitialPacket packet, Instant time) {
        assert (Arrays.equals(packet.getDestinationConnectionId(), this.connectionIdManager.getInitialConnectionId()) || Arrays.equals(packet.getDestinationConnectionId(), this.connectionIdManager.getOriginalDestinationConnectionId()));
        if (this.retryRequired) {
            if (packet.getToken() == null) {
                this.sendRetry();
                this.connectionSecrets.computeInitialKeys(this.connectionIdManager.getInitialConnectionId());
                return PacketProcessor.ProcessResult.Abort;
            }
            if (!Arrays.equals(packet.getToken(), this.token)) {
                this.immediateCloseWithError(EncryptionLevel.Initial, QuicConstants.TransportErrorCode.INVALID_TOKEN.value, null);
                return PacketProcessor.ProcessResult.Abort;
            }
            this.addressValidated = true;
            this.sender.unsetAntiAmplificationLimit();
            this.processFrames(packet, time);
            return PacketProcessor.ProcessResult.Continue;
        }
        this.processFrames(packet, time);
        return PacketProcessor.ProcessResult.Continue;
    }

    private void sendRetry() {
        RetryPacket retry = new RetryPacket(this.quicVersion.getVersion(), this.connectionIdManager.getInitialConnectionId(), this.getDestinationConnectionId(), this.getOriginalDestinationConnectionId(), this.token);
        this.sender.send(retry);
    }

    @Override
    public PacketProcessor.ProcessResult process(ShortHeaderPacket packet, Instant time) {
        this.connectionIdManager.registerConnectionIdInUse(packet.getDestinationConnectionId());
        this.processFrames(packet, time);
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(VersionNegotiationPacket packet, Instant time) {
        return PacketProcessor.ProcessResult.Abort;
    }

    @Override
    public PacketProcessor.ProcessResult process(HandshakePacket packet, Instant time) {
        if (!this.addressValidated) {
            this.addressValidated = true;
            this.sender.unsetAntiAmplificationLimit();
        }
        this.sender.discard(PnSpace.Initial, "first handshake packet received");
        this.processFrames(packet, time);
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public PacketProcessor.ProcessResult process(RetryPacket packet, Instant time) {
        return PacketProcessor.ProcessResult.Abort;
    }

    @Override
    public PacketProcessor.ProcessResult process(ZeroRttPacket packet, Instant time) {
        if (this.acceptedEarlyData) {
            this.processFrames(packet, time);
        } else {
            this.log.warn("Ignoring 0-RTT packet because server connection does not accept early data.");
        }
        return PacketProcessor.ProcessResult.Continue;
    }

    @Override
    public void process(HandshakeDoneFrame handshakeDoneFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(NewConnectionIdFrame newConnectionIdFrame, QuicPacket packet, Instant timeReceived) {
        this.connectionIdManager.process(newConnectionIdFrame);
    }

    @Override
    public void process(NewTokenFrame newTokenFrame, QuicPacket packet, Instant timeReceived) {
    }

    @Override
    public void process(RetireConnectionIdFrame retireConnectionIdFrame, QuicPacket packet, Instant timeReceived) {
        this.connectionIdManager.process(retireConnectionIdFrame, packet.getDestinationConnectionId());
    }

    @Override
    protected void terminate() {
        super.terminate(() -> {
            String statsSummary = this.getStats().toString().replace("\n", "    ");
            this.log.info(String.format("Stats for connection %s: %s", ByteUtils.bytesToHex((byte[])this.connectionIdManager.getInitialConnectionId()), statsSummary));
        });
        this.log.getQLog().emitConnectionTerminatedEvent();
        this.closeCallback.accept(this);
    }

    private void validateAndProcess(TransportParameters transportParameters) throws TransportError {
        Optional<Version> clientPreferred;
        TransportParameters.VersionInformation versionInformation = transportParameters.getVersionInformation();
        if (versionInformation != null && !(clientPreferred = versionInformation.getOtherVersions().stream().filter(version -> version.isV1V2()).findFirst()).equals(Optional.of(this.quicVersion.getVersion()))) {
            this.log.info(String.format("Switching from initial version %s to client's preferred version %s.", this.quicVersion, clientPreferred));
            this.versionNegotiationStatus = QuicConnectionImpl.VersionNegotiationStatus.VersionChangeUnconfirmed;
            this.quicVersion.setVersion(clientPreferred.get());
            this.connectionSecrets.recomputeInitialKeys();
        }
        if (transportParameters.getInitialMaxStreamsBidi() > 0x1000000000000000L) {
            throw new TransportError(QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR);
        }
        if (transportParameters.getMaxUdpPayloadSize() < 1200) {
            throw new TransportError(QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR);
        }
        if (transportParameters.getAckDelayExponent() > 20) {
            throw new TransportError(QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR);
        }
        if (transportParameters.getMaxAckDelay() > 16384) {
            throw new TransportError(QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR);
        }
        if (transportParameters.getActiveConnectionIdLimit() < 2) {
            throw new TransportError(QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR);
        }
        if (!this.connectionIdManager.validateInitialPeerConnectionId(transportParameters.getInitialSourceConnectionId())) {
            throw new TransportError(QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR);
        }
        if (transportParameters.getOriginalDestinationConnectionId() != null || transportParameters.getPreferredAddress() != null || transportParameters.getRetrySourceConnectionId() != null || transportParameters.getStatelessResetToken() != null) {
            throw new TransportError(QuicConstants.TransportErrorCode.TRANSPORT_PARAMETER_ERROR);
        }
        this.determineIdleTimeout(this.maxIdleTimeoutInSeconds * 1000, transportParameters.getMaxIdleTimeout());
        this.connectionIdManager.registerPeerCidLimit(transportParameters.getActiveConnectionIdLimit());
        this.flowController = new FlowControl(Role.Server, transportParameters.getInitialMaxData(), transportParameters.getInitialMaxStreamDataBidiLocal(), transportParameters.getInitialMaxStreamDataBidiRemote(), transportParameters.getInitialMaxStreamDataUni(), this.log);
        this.streamManager.setFlowController(this.flowController);
        this.streamManager.setInitialMaxStreamsBidi(transportParameters.getInitialMaxStreamsBidi());
        this.streamManager.setInitialMaxStreamsUni(transportParameters.getInitialMaxStreamsUni());
        this.peerAckDelayExponent = transportParameters.getAckDelayExponent();
        this.sender.setReceiverMaxAckDelay(transportParameters.getMaxAckDelay());
        this.sender.registerMaxUdpPayloadSize(transportParameters.getMaxUdpPayloadSize());
    }

    @Override
    public InetAddress getInitialClientAddress() {
        return this.initialClientAddress.getAddress();
    }

    public boolean isClosed() {
        return this.connectionState == QuicConnectionImpl.Status.Closed;
    }

    public byte[] getOriginalDestinationConnectionId() {
        return this.connectionIdManager.getOriginalDestinationConnectionId();
    }

    public List<byte[]> getActiveConnectionIds() {
        return this.connectionIdManager.getActiveConnectionIds();
    }

    @Override
    public void setMaxAllowedBidirectionalStreams(int max) {
    }

    @Override
    public void setMaxAllowedUnidirectionalStreams(int max) {
    }

    @Override
    public void setDefaultStreamReceiveBufferSize(long size) {
    }

    @Override
    public void setPeerInitiatedStreamCallback(Consumer<QuicStream> streamConsumer) {
        this.streamManager.setPeerInitiatedStreamCallback(streamConsumer);
    }

    public String toString() {
        return "ServerConnection[" + ByteUtils.bytesToHex((byte[])this.connectionIdManager.getOriginalDestinationConnectionId()) + "]";
    }

    private class TlsMessageSender
    implements ServerMessageSender {
        private TlsMessageSender() {
        }

        public void send(ServerHello sh) {
            CryptoStream cryptoStream = ServerConnectionImpl.this.getCryptoStream(EncryptionLevel.Initial);
            cryptoStream.write((HandshakeMessage)sh, false);
            ServerConnectionImpl.this.log.sentPacketInfo(cryptoStream.toStringSent());
        }

        public void send(EncryptedExtensions ee) {
            ServerConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake).write((HandshakeMessage)ee, false);
        }

        public void send(CertificateMessage cm) throws IOException {
            ServerConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake).write((HandshakeMessage)cm, false);
        }

        public void send(CertificateVerifyMessage cv) throws IOException {
            ServerConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake).write((HandshakeMessage)cv, false);
        }

        public void send(FinishedMessage finished) throws IOException {
            CryptoStream cryptoStream = ServerConnectionImpl.this.getCryptoStream(EncryptionLevel.Handshake);
            cryptoStream.write((HandshakeMessage)finished, false);
            ServerConnectionImpl.this.log.sentPacketInfo(cryptoStream.toStringSent());
        }

        public void send(NewSessionTicketMessage newSessionTicket) throws IOException {
            CryptoStream cryptoStream = ServerConnectionImpl.this.getCryptoStream(EncryptionLevel.App);
            cryptoStream.write((HandshakeMessage)newSessionTicket, true);
        }
    }
}

