/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.quic.stream;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.luminis.quic.stream.StreamElement;

public class BaseStream {
    private SortedSet<StreamElement> frames = new TreeSet<StreamElement>();
    private long processedToOffset = 0L;

    protected synchronized boolean add(StreamElement frame) {
        if (frame.getUpToOffset() > this.processedToOffset) {
            this.frames.add(frame);
            return true;
        }
        return false;
    }

    protected synchronized int bytesAvailable() {
        StreamElement nextFrame;
        if (this.isStreamEnd(this.processedToOffset)) {
            return -1;
        }
        if (this.frames.isEmpty()) {
            return 0;
        }
        int available = 0;
        long countedUpTo = this.processedToOffset;
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext() && (nextFrame = (StreamElement)iterator.next()).getOffset() <= countedUpTo) {
            if (nextFrame.getUpToOffset() <= countedUpTo) continue;
            available = (int)((long)available + (nextFrame.getUpToOffset() - countedUpTo));
            countedUpTo = nextFrame.getUpToOffset();
        }
        return available;
    }

    protected synchronized int read(ByteBuffer buffer) {
        StreamElement nextFrame;
        if (this.isStreamEnd(this.processedToOffset)) {
            return -1;
        }
        if (this.frames.isEmpty()) {
            return 0;
        }
        int read = 0;
        long readUpTo = this.processedToOffset;
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext() && buffer.remaining() > 0 && (nextFrame = (StreamElement)iterator.next()).getOffset() <= readUpTo) {
            if (nextFrame.getUpToOffset() <= readUpTo) continue;
            long available = nextFrame.getOffset() - readUpTo + (long)nextFrame.getLength();
            int bytesToRead = (int)Long.min(buffer.limit() - buffer.position(), available);
            buffer.put(nextFrame.getStreamData(), (int)(readUpTo - nextFrame.getOffset()), bytesToRead);
            readUpTo += (long)bytesToRead;
            read += bytesToRead;
        }
        this.processedToOffset += (long)read;
        this.removeParsedFrames();
        return read;
    }

    protected synchronized boolean allDataReceived() {
        StreamElement nextFrame;
        if (this.isStreamEnd(this.processedToOffset)) {
            return true;
        }
        long completeUpTo = this.processedToOffset;
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext() && (nextFrame = (StreamElement)iterator.next()).getOffset() <= completeUpTo) {
            if (nextFrame.getUpToOffset() <= completeUpTo) continue;
            completeUpTo = nextFrame.getUpToOffset();
        }
        return this.isStreamEnd(completeUpTo);
    }

    protected boolean isStreamEnd(long offset) {
        return false;
    }

    private void removeParsedFrames() {
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext() && ((StreamElement)iterator.next()).getUpToOffset() <= this.processedToOffset) {
            iterator.remove();
        }
    }

    protected synchronized long readOffset() {
        return this.processedToOffset;
    }
}

