/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver.bundled;

import androidx.annotation.RestrictTo;
import androidx.sqlite.SQLite;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import androidx.sqlite.driver.bundled.BundledSQLiteConnectionKt;
import androidx.sqlite.driver.bundled.BundledSQLiteStatement;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001f\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Landroidx/sqlite/driver/bundled/BundledSQLiteConnection;", "Landroidx/sqlite/SQLiteConnection;", "connectionPointer", "", "<init>", "(J)V", "isClosed", "", "isClosed$annotations", "()V", "inTransaction", "prepare", "Landroidx/sqlite/SQLiteStatement;", "sql", "", "loadExtension", "", "fileName", "entryPoint", "loadExtension$sqlite_bundled", "close", "sqlite-bundled"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BundledSQLiteConnection
implements SQLiteConnection {
    private final long connectionPointer;
    private volatile boolean isClosed;

    public BundledSQLiteConnection(long connectionPointer) {
        this.connectionPointer = connectionPointer;
    }

    private static /* synthetic */ void isClosed$annotations() {
    }

    public boolean inTransaction() {
        if (this.isClosed) {
            SQLite.throwSQLiteException((int)21, (String)"connection is closed");
            throw new KotlinNothingValueException();
        }
        return BundledSQLiteConnectionKt.access$nativeInTransaction(this.connectionPointer);
    }

    @NotNull
    public SQLiteStatement prepare(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (this.isClosed) {
            SQLite.throwSQLiteException((int)21, (String)"connection is closed");
            throw new KotlinNothingValueException();
        }
        long statementPointer = BundledSQLiteConnectionKt.access$nativePrepare(this.connectionPointer, sql);
        return new BundledSQLiteStatement(this.connectionPointer, statementPointer);
    }

    public final void loadExtension$sqlite_bundled(@NotNull String fileName, @Nullable String entryPoint) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (this.isClosed) {
            SQLite.throwSQLiteException((int)21, (String)"connection is closed");
            throw new KotlinNothingValueException();
        }
        BundledSQLiteConnectionKt.access$nativeLoadExtension(this.connectionPointer, fileName, entryPoint);
    }

    public void close() {
        if (!this.isClosed) {
            BundledSQLiteConnectionKt.access$nativeClose(this.connectionPointer);
        }
        this.isClosed = true;
    }
}

