/*
 * Decompiled with CFR 0.152.
 */
package com.eygraber.uri.uris;

import com.eygraber.uri.Uri;
import com.eygraber.uri.UriCodec;
import com.eygraber.uri.parts.Part;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0005H\u0002R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\t\u001a\u0004\b\u0010\u0010\u0007R\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0013\u0010\u0007R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\t\u001a\u0004\b\u0016\u0010\u0007R\u001b\u0010\u0018\u001a\u00020\u00198VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\t\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lcom/eygraber/uri/uris/AbstractHierarchicalUri;", "Lcom/eygraber/uri/Uri;", "<init>", "()V", "lastPathSegment", "", "getLastPathSegment", "()Ljava/lang/String;", "lastPathSegment$delegate", "Lkotlin/Lazy;", "_userInfo", "Lcom/eygraber/uri/parts/Part;", "get_userInfo", "()Lcom/eygraber/uri/parts/Part;", "_userInfo$delegate", "userInfo", "getUserInfo", "userInfo$delegate", "encodedUserInfo", "getEncodedUserInfo", "encodedUserInfo$delegate", "host", "getHost", "host$delegate", "port", "", "getPort", "()I", "port$delegate", "findPortSeparator", "authority", "uri"})
public abstract class AbstractHierarchicalUri
implements Uri {
    @NotNull
    private final Lazy lastPathSegment$delegate = LazyKt.lazy(() -> AbstractHierarchicalUri.lastPathSegment_delegate$lambda$0(this));
    @NotNull
    private final Lazy _userInfo$delegate = LazyKt.lazy(() -> AbstractHierarchicalUri._userInfo_delegate$lambda$1(this));
    @NotNull
    private final Lazy userInfo$delegate = LazyKt.lazy(() -> AbstractHierarchicalUri.userInfo_delegate$lambda$2(this));
    @NotNull
    private final Lazy encodedUserInfo$delegate = LazyKt.lazy(() -> AbstractHierarchicalUri.encodedUserInfo_delegate$lambda$3(this));
    @NotNull
    private final Lazy host$delegate = LazyKt.lazy(() -> AbstractHierarchicalUri.host_delegate$lambda$4(this));
    @NotNull
    private final Lazy port$delegate = LazyKt.lazy(() -> AbstractHierarchicalUri.port_delegate$lambda$5(this));

    @Override
    @Nullable
    public String getLastPathSegment() {
        Lazy lazy = this.lastPathSegment$delegate;
        return (String)lazy.getValue();
    }

    private final Part get_userInfo() {
        Lazy lazy = this._userInfo$delegate;
        return (Part)lazy.getValue();
    }

    @Override
    @Nullable
    public String getUserInfo() {
        Lazy lazy = this.userInfo$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getEncodedUserInfo() {
        Lazy lazy = this.encodedUserInfo$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public String getHost() {
        Lazy lazy = this.host$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public int getPort() {
        Lazy lazy = this.port$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int findPortSeparator(String authority) {
        for (int i2 = authority.length() - 1; -1 < i2; --i2) {
            char character = authority.charAt(i2);
            if (':' == character) {
                return i2;
            }
            if (character >= '0' && character <= '9') continue;
            return -1;
        }
        return -1;
    }

    @Override
    public boolean isOpaque() {
        return Uri.super.isOpaque();
    }

    @Override
    public boolean isAbsolute() {
        return Uri.super.isAbsolute();
    }

    @Override
    @NotNull
    public Set<String> getQueryParameterNames() {
        return Uri.super.getQueryParameterNames();
    }

    @Override
    @NotNull
    public List<String> getQueryParameters(@NotNull String key) {
        return Uri.super.getQueryParameters(key);
    }

    @Override
    @Nullable
    public String getQueryParameter(@NotNull String key) {
        return Uri.super.getQueryParameter(key);
    }

    @Override
    public boolean getBooleanQueryParameter(@NotNull String key, boolean defaultValue) {
        return Uri.super.getBooleanQueryParameter(key, defaultValue);
    }

    @Override
    @NotNull
    public Uri normalizeScheme() {
        return Uri.super.normalizeScheme();
    }

    @Override
    public int compareTo(@NotNull Uri other) {
        return Uri.super.compareTo(other);
    }

    private static final String lastPathSegment_delegate$lambda$0(AbstractHierarchicalUri this$0) {
        List<String> segments = this$0.getPathSegments();
        return segments.isEmpty() ? null : CollectionsKt.last(segments);
    }

    private static final Part _userInfo_delegate$lambda$1(AbstractHierarchicalUri this$0) {
        String string2;
        String string3 = this$0.getEncodedAuthority();
        if (string3 == null) {
            return Part.Companion.fromEncoded(null);
        }
        String authority = string3;
        int end = StringsKt.lastIndexOf$default((CharSequence)authority, '@', 0, false, 6, null);
        if (end == -1) {
            string2 = null;
        } else {
            String string4 = authority.substring(0, end);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        }
        return Part.Companion.fromEncoded(string2);
    }

    private static final String userInfo_delegate$lambda$2(AbstractHierarchicalUri this$0) {
        return this$0.get_userInfo().getDecoded();
    }

    private static final String encodedUserInfo_delegate$lambda$3(AbstractHierarchicalUri this$0) {
        return this$0.get_userInfo().getEncoded();
    }

    private static final String host_delegate$lambda$4(AbstractHierarchicalUri this$0) {
        String string2;
        String string3 = this$0.getEncodedAuthority();
        if (string3 == null) {
            return null;
        }
        String authority = string3;
        int userInfoSeparator = StringsKt.lastIndexOf$default((CharSequence)authority, '@', 0, false, 6, null);
        int portSeparator = this$0.findPortSeparator(authority);
        if (portSeparator == -1) {
            String string4 = authority.substring(userInfoSeparator + 1);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        } else {
            String string5 = authority.substring(userInfoSeparator + 1, portSeparator);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
        }
        String encodedHost = string2;
        return UriCodec.decode$default(UriCodec.INSTANCE, encodedHost, false, false, 6, null);
    }

    private static final int port_delegate$lambda$5(AbstractHierarchicalUri this$0) {
        int n;
        String string2 = this$0.getEncodedAuthority();
        if (string2 == null) {
            return -1;
        }
        String authority = string2;
        int portSeparator = this$0.findPortSeparator(authority);
        if (portSeparator == -1) {
            return -1;
        }
        String string3 = authority.substring(portSeparator + 1);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        String portString = UriCodec.decode$default(UriCodec.INSTANCE, string3, false, false, 6, null);
        try {
            n = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            n = -1;
        }
        return n;
    }
}

