/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigValue;
import io.ktor.server.config.ApplicationConfigurationException;
import io.ktor.server.config.HoconDecoder;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.util.reflect.TypeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u000fJ\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lio/ktor/server/config/HoconApplicationConfig;", "Lio/ktor/server/config/ApplicationConfig;", "Lcom/typesafe/config/Config;", "config", "<init>", "(Lcom/typesafe/config/Config;)V", "", "path", "Lio/ktor/server/config/ApplicationConfigValue;", "property", "(Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfigValue;", "propertyOrNull", "", "configList", "(Ljava/lang/String;)Ljava/util/List;", "(Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfig;", "", "keys", "()Ljava/util/Set;", "", "", "toMap", "()Ljava/util/Map;", "Lcom/typesafe/config/Config;", "HoconApplicationConfigValue", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nHoconApplicationConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoconApplicationConfig.kt\nio/ktor/server/config/HoconApplicationConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1563#2:131\n1634#2,3:132\n1563#2:135\n1634#2,3:136\n*S KotlinDebug\n*F\n+ 1 HoconApplicationConfig.kt\nio/ktor/server/config/HoconApplicationConfig\n*L\n69#1:131\n69#1:132,3\n76#1:135\n76#1:136,3\n*E\n"})
public class HoconApplicationConfig
implements ApplicationConfig {
    @NotNull
    private final Config config;

    public HoconApplicationConfig(@NotNull Config config2) {
        Intrinsics.checkNotNullParameter(config2, "config");
        this.config = config2;
    }

    @Override
    @NotNull
    public ApplicationConfigValue property(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (!this.config.hasPath(path)) {
            throw new ApplicationConfigurationException("Property " + path + " not found.");
        }
        return new HoconApplicationConfigValue(this.config, path);
    }

    @Override
    @Nullable
    public ApplicationConfigValue propertyOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (!this.config.hasPath(path)) {
            return null;
        }
        return new HoconApplicationConfigValue(this.config, path);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ApplicationConfig> configList(@NotNull String path) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(path, "path");
        List<? extends Config> list2 = this.config.getConfigList(path);
        Intrinsics.checkNotNullExpressionValue(list2, "getConfigList(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Config config2 = (Config)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            collection.add(new HoconApplicationConfig((Config)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ApplicationConfig config(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Config config2 = this.config.getConfig(path);
        Intrinsics.checkNotNullExpressionValue(config2, "getConfig(...)");
        return new HoconApplicationConfig(config2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> keys() {
        void $this$mapTo$iv$iv;
        Set<Map.Entry<String, ConfigValue>> set2 = this.config.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, "entrySet(...)");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Object object = this.config.root().unwrapped();
        Intrinsics.checkNotNullExpressionValue(object, "unwrapped(...)");
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u001a\u0010\u0012\u001a\u00020\u001a8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lio/ktor/server/config/HoconApplicationConfig$HoconApplicationConfigValue;", "Lio/ktor/server/config/ApplicationConfigValue;", "Lcom/typesafe/config/Config;", "config", "", "path", "<init>", "(Lcom/typesafe/config/Config;Ljava/lang/String;)V", "getString", "()Ljava/lang/String;", "", "getList", "()Ljava/util/List;", "", "", "getMap", "()Ljava/util/Map;", "Lio/ktor/util/reflect/TypeInfo;", "type", "getAs", "(Lio/ktor/util/reflect/TypeInfo;)Ljava/lang/Object;", "Lcom/typesafe/config/Config;", "getConfig", "()Lcom/typesafe/config/Config;", "Ljava/lang/String;", "getPath", "Lio/ktor/server/config/ApplicationConfigValue$Type;", "Lio/ktor/server/config/ApplicationConfigValue$Type;", "getType", "()Lio/ktor/server/config/ApplicationConfigValue$Type;", "ktor-server-core"})
    private static final class HoconApplicationConfigValue
    implements ApplicationConfigValue {
        @NotNull
        private final Config config;
        @NotNull
        private final String path;
        @NotNull
        private final ApplicationConfigValue.Type type;

        public HoconApplicationConfigValue(@NotNull Config config2, @NotNull String path) {
            ApplicationConfigValue.Type type2;
            Intrinsics.checkNotNullParameter(config2, "config");
            Intrinsics.checkNotNullParameter(path, "path");
            this.config = config2;
            this.path = path;
            ConfigValueType configValueType = this.config.getValue(this.path).valueType();
            switch (configValueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[configValueType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    type2 = ApplicationConfigValue.Type.SINGLE;
                    break;
                }
                case 4: {
                    type2 = ApplicationConfigValue.Type.NULL;
                    break;
                }
                case 5: {
                    type2 = ApplicationConfigValue.Type.LIST;
                    break;
                }
                case 6: {
                    type2 = ApplicationConfigValue.Type.OBJECT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.type = type2;
        }

        @NotNull
        public final Config getConfig() {
            return this.config;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public String getString() {
            String string2 = this.config.getString(this.path);
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            return string2;
        }

        @Override
        @NotNull
        public List<String> getList() {
            List<String> list2 = this.config.getStringList(this.path);
            Intrinsics.checkNotNullExpressionValue(list2, "getStringList(...)");
            return list2;
        }

        @Override
        @NotNull
        public ApplicationConfigValue.Type getType() {
            return this.type;
        }

        @Override
        @NotNull
        public Map<String, Object> getMap() {
            Object object = this.config.getObject(this.path).unwrapped();
            Intrinsics.checkNotNullExpressionValue(object, "unwrapped(...)");
            return object;
        }

        @Override
        @Nullable
        public Object getAs(@NotNull TypeInfo type2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            return TypeKt.serializer(type2).deserialize(new HoconDecoder(this.config, this.path, null, 4, null));
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConfigValueType.values().length];
                try {
                    nArray[ConfigValueType.STRING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConfigValueType.NUMBER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConfigValueType.BOOLEAN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConfigValueType.NULL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConfigValueType.LIST.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConfigValueType.OBJECT.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

