/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.options;

import androidx.compose.runtime.Immutable;
import io.github.alexzhirkevich.qrose.options.QrCodeMatrix;
import io.github.alexzhirkevich.qrose.options.QrCodeShape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lio/github/alexzhirkevich/qrose/options/Circle;", "Lio/github/alexzhirkevich/qrose/options/QrCodeShape;", "padding", "", "random", "Lkotlin/random/Random;", "precise", "", "(FLkotlin/random/Random;Z)V", "shapeSizeIncrease", "getShapeSizeIncrease", "()F", "isInCircle", "center", "i", "j", "radius", "transform", "Lio/github/alexzhirkevich/qrose/options/QrCodeMatrix;", "qrose"})
@Immutable
final class Circle
implements QrCodeShape {
    private final float padding;
    @NotNull
    private final Random random;
    private final boolean precise;
    private final float shapeSizeIncrease;

    public Circle(float padding, @NotNull Random random, boolean precise) {
        Intrinsics.checkNotNullParameter(random, "random");
        this.padding = padding;
        this.random = random;
        this.precise = precise;
        this.shapeSizeIncrease = 1.0f + (float)((double)this.padding * Math.sqrt(2.0) - 1.0);
    }

    @Override
    public float getShapeSizeIncrease() {
        return this.shapeSizeIncrease;
    }

    @Override
    @NotNull
    public QrCodeMatrix transform(@NotNull QrCodeMatrix $this$transform) {
        int i2;
        Intrinsics.checkNotNullParameter($this$transform, "<this>");
        float padding = RangesKt.coerceIn(this.padding, 1.0f, 2.0f);
        int added = MathKt.roundToInt(((double)((float)$this$transform.getSize() * padding) * Math.sqrt(2.0) - (double)$this$transform.getSize()) / (double)2);
        int newSize = $this$transform.getSize() + 2 * added;
        QrCodeMatrix newMatrix = new QrCodeMatrix(newSize, null, 2, null);
        float center = (float)newSize / 2.0f;
        for (i2 = 0; i2 < newSize; ++i2) {
            for (int j = 0; j < newSize; ++j) {
                boolean notInSquare = i2 <= added - 1 || j <= added - 1 || i2 >= added + $this$transform.getSize() || j >= added + $this$transform.getSize();
                boolean inLargeCircle = this.isInCircle(center, i2, j, center);
                if (!notInSquare || !inLargeCircle) continue;
                boolean inSmallCircle = !this.precise || this.isInCircle(center, i2, j, center - 1.0f);
                newMatrix.set(i2, j, !inSmallCircle || this.random.nextBoolean() ? QrCodeMatrix.PixelType.DarkPixel : QrCodeMatrix.PixelType.LightPixel);
            }
        }
        int n = $this$transform.getSize();
        for (i2 = 0; i2 < n; ++i2) {
            int n2 = $this$transform.getSize();
            for (int j = 0; j < n2; ++j) {
                newMatrix.set(added + i2, added + j, $this$transform.get(i2, j));
            }
        }
        return newMatrix;
    }

    public final boolean isInCircle(float center, float i2, float j, float radius) {
        return (float)Math.sqrt((center - i2) * (center - i2) + (center - j) * (center - j)) < radius;
    }
}

