/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFChunk;
import com.ning.compress.lzf.LZFEncoder;
import com.ning.compress.lzf.util.ChunkEncoderFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.PlatformDependent;

public class LzfEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MIN_BLOCK_TO_COMPRESS = 16;
    private static final boolean DEFAULT_SAFE = !PlatformDependent.hasUnsafe();
    private final int compressThreshold;
    private final ChunkEncoder encoder;
    private final BufferRecycler recycler;

    public LzfEncoder() {
        this(DEFAULT_SAFE);
    }

    @Deprecated
    public LzfEncoder(boolean safeInstance) {
        this(safeInstance, 65535);
    }

    @Deprecated
    public LzfEncoder(boolean safeInstance, int totalLength) {
        this(safeInstance, totalLength, 16);
    }

    public LzfEncoder(int totalLength) {
        this(DEFAULT_SAFE, totalLength);
    }

    public LzfEncoder(int totalLength, int compressThreshold) {
        this(DEFAULT_SAFE, totalLength, compressThreshold);
    }

    @Deprecated
    public LzfEncoder(boolean safeInstance, int totalLength, int compressThreshold) {
        super(ByteBuf.class, false);
        if (totalLength < 16 || totalLength > 65535) {
            throw new IllegalArgumentException("totalLength: " + totalLength + " (expected: " + 16 + '-' + 65535 + ')');
        }
        if (compressThreshold < 16) {
            throw new IllegalArgumentException("compressThreshold:" + compressThreshold + " expected >=" + 16);
        }
        this.compressThreshold = compressThreshold;
        this.encoder = safeInstance ? ChunkEncoderFactory.safeNonAllocatingInstance((int)totalLength) : ChunkEncoderFactory.optimalNonAllocatingInstance((int)totalLength);
        this.recycler = BufferRecycler.instance();
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        int outputPtr;
        byte[] output2;
        int inputPtr;
        byte[] input2;
        int length = in.readableBytes();
        int idx2 = in.readerIndex();
        if (in.hasArray()) {
            input2 = in.array();
            inputPtr = in.arrayOffset() + idx2;
        } else {
            input2 = this.recycler.allocInputBuffer(length);
            in.getBytes(idx2, input2, 0, length);
            inputPtr = 0;
        }
        int maxOutputLength = LZFEncoder.estimateMaxWorkspaceSize((int)length) + 1;
        out.ensureWritable(maxOutputLength);
        if (out.hasArray()) {
            output2 = out.array();
            outputPtr = out.arrayOffset() + out.writerIndex();
        } else {
            output2 = new byte[maxOutputLength];
            outputPtr = 0;
        }
        int outputLength = length >= this.compressThreshold ? this.encodeCompress(input2, inputPtr, length, output2, outputPtr) : LzfEncoder.encodeNonCompress(input2, inputPtr, length, output2, outputPtr);
        if (out.hasArray()) {
            out.writerIndex(out.writerIndex() + outputLength);
        } else {
            out.writeBytes(output2, 0, outputLength);
        }
        in.skipBytes(length);
        if (!in.hasArray()) {
            this.recycler.releaseInputBuffer(input2);
        }
    }

    private int encodeCompress(byte[] input2, int inputPtr, int length, byte[] output2, int outputPtr) {
        return LZFEncoder.appendEncoded((ChunkEncoder)this.encoder, (byte[])input2, (int)inputPtr, (int)length, (byte[])output2, (int)outputPtr) - outputPtr;
    }

    private static int lzfEncodeNonCompress(byte[] input2, int inputPtr, int length, byte[] output2, int outputPtr) {
        int left = length;
        int chunkLen = Math.min(65535, left);
        outputPtr = LZFChunk.appendNonCompressed((byte[])input2, (int)inputPtr, (int)chunkLen, (byte[])output2, (int)outputPtr);
        if ((left -= chunkLen) < 1) {
            return outputPtr;
        }
        inputPtr += chunkLen;
        do {
            chunkLen = Math.min(left, 65535);
            outputPtr = LZFChunk.appendNonCompressed((byte[])input2, (int)inputPtr, (int)chunkLen, (byte[])output2, (int)outputPtr);
            inputPtr += chunkLen;
        } while ((left -= chunkLen) > 0);
        return outputPtr;
    }

    private static int encodeNonCompress(byte[] input2, int inputPtr, int length, byte[] output2, int outputPtr) {
        return LzfEncoder.lzfEncodeNonCompress(input2, inputPtr, length, output2, outputPtr) - outputPtr;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.encoder.close();
        super.handlerRemoved(ctx);
    }
}

