package world.respect.datalayer.db.school.daos

import androidx.paging.PagingSource
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.RoomRawQuery
import androidx.room.coroutines.createFlow
import androidx.room.paging.LimitOffsetPagingSource
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import kotlinx.datetime.LocalDate
import kotlinx.serialization.json.JsonObject
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.EnrollmentEntity
import world.respect.datalayer.db.shared.SharedConverters
import world.respect.datalayer.school.model.EnrollmentRoleEnum
import world.respect.datalayer.school.model.StatusEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class EnrollmentEntityDao_Impl(
  __db: RoomDatabase,
) : EnrollmentEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfEnrollmentEntity: EntityInsertAdapter<EnrollmentEntity>

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfEnrollmentEntity = object : EntityInsertAdapter<EnrollmentEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `EnrollmentEntity` (`eUid`,`eUidNum`,`eStatus`,`eLastModified`,`eStored`,`eMetadata`,`eClassUid`,`eClassUidNum`,`ePersonUid`,`ePersonUidNum`,`eRole`,`eBeginDate`,`eEndDate`,`eRemovedAt`,`eInviteCode`,`eApprovedByPersonUidNum`,`eApprovedByPersonUid`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: EnrollmentEntity) {
        statement.bindText(1, entity.eUid)
        statement.bindLong(2, entity.eUidNum)
        val _tmp: Int = __schoolTypeConverters.fromStatusEnum(entity.eStatus)
        statement.bindLong(3, _tmp.toLong())
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.eLastModified)
        if (_tmp_1 == null) {
          statement.bindNull(4)
        } else {
          statement.bindLong(4, _tmp_1)
        }
        val _tmp_2: Long? = __sharedConverters.fromInstant(entity.eStored)
        if (_tmp_2 == null) {
          statement.bindNull(5)
        } else {
          statement.bindLong(5, _tmp_2)
        }
        val _tmpEMetadata: JsonObject? = entity.eMetadata
        val _tmp_3: String? = __schoolTypeConverters.fromJsonObject(_tmpEMetadata)
        if (_tmp_3 == null) {
          statement.bindNull(6)
        } else {
          statement.bindText(6, _tmp_3)
        }
        statement.bindText(7, entity.eClassUid)
        statement.bindLong(8, entity.eClassUidNum)
        statement.bindText(9, entity.ePersonUid)
        statement.bindLong(10, entity.ePersonUidNum)
        val _tmp_4: Int = __schoolTypeConverters.fromEnrollmentRoleEnum(entity.eRole)
        statement.bindLong(11, _tmp_4.toLong())
        val _tmpEBeginDate: LocalDate? = entity.eBeginDate
        val _tmp_5: Long? = __schoolTypeConverters.fromLocalDate(_tmpEBeginDate)
        if (_tmp_5 == null) {
          statement.bindNull(12)
        } else {
          statement.bindLong(12, _tmp_5)
        }
        val _tmpEEndDate: LocalDate? = entity.eEndDate
        val _tmp_6: Long? = __schoolTypeConverters.fromLocalDate(_tmpEEndDate)
        if (_tmp_6 == null) {
          statement.bindNull(13)
        } else {
          statement.bindLong(13, _tmp_6)
        }
        val _tmpERemovedAt: Instant? = entity.eRemovedAt
        val _tmp_7: Long? = __sharedConverters.fromInstant(_tmpERemovedAt)
        if (_tmp_7 == null) {
          statement.bindNull(14)
        } else {
          statement.bindLong(14, _tmp_7)
        }
        val _tmpEInviteCode: String? = entity.eInviteCode
        if (_tmpEInviteCode == null) {
          statement.bindNull(15)
        } else {
          statement.bindText(15, _tmpEInviteCode)
        }
        statement.bindLong(16, entity.eApprovedByPersonUidNum)
        val _tmpEApprovedByPersonUid: String? = entity.eApprovedByPersonUid
        if (_tmpEApprovedByPersonUid == null) {
          statement.bindNull(17)
        } else {
          statement.bindText(17, _tmpEApprovedByPersonUid)
        }
      }
    }
  }

  public override suspend fun upsert(enrolments: List<EnrollmentEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfEnrollmentEntity.insert(_connection, enrolments)
  }

  public override suspend fun findByGuid(uidNum: Long): EnrollmentEntity? {
    val _sql: String = """
        |
        |        SELECT EnrollmentEntity.*
        |          FROM EnrollmentEntity
        |         WHERE EnrollmentEntity.eUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfEUid: Int = getColumnIndexOrThrow(_stmt, "eUid")
        val _columnIndexOfEUidNum: Int = getColumnIndexOrThrow(_stmt, "eUidNum")
        val _columnIndexOfEStatus: Int = getColumnIndexOrThrow(_stmt, "eStatus")
        val _columnIndexOfELastModified: Int = getColumnIndexOrThrow(_stmt, "eLastModified")
        val _columnIndexOfEStored: Int = getColumnIndexOrThrow(_stmt, "eStored")
        val _columnIndexOfEMetadata: Int = getColumnIndexOrThrow(_stmt, "eMetadata")
        val _columnIndexOfEClassUid: Int = getColumnIndexOrThrow(_stmt, "eClassUid")
        val _columnIndexOfEClassUidNum: Int = getColumnIndexOrThrow(_stmt, "eClassUidNum")
        val _columnIndexOfEPersonUid: Int = getColumnIndexOrThrow(_stmt, "ePersonUid")
        val _columnIndexOfEPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ePersonUidNum")
        val _columnIndexOfERole: Int = getColumnIndexOrThrow(_stmt, "eRole")
        val _columnIndexOfEBeginDate: Int = getColumnIndexOrThrow(_stmt, "eBeginDate")
        val _columnIndexOfEEndDate: Int = getColumnIndexOrThrow(_stmt, "eEndDate")
        val _columnIndexOfERemovedAt: Int = getColumnIndexOrThrow(_stmt, "eRemovedAt")
        val _columnIndexOfEInviteCode: Int = getColumnIndexOrThrow(_stmt, "eInviteCode")
        val _columnIndexOfEApprovedByPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUidNum")
        val _columnIndexOfEApprovedByPersonUid: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUid")
        val _result: EnrollmentEntity?
        if (_stmt.step()) {
          val _tmpEUid: String
          _tmpEUid = _stmt.getText(_columnIndexOfEUid)
          val _tmpEUidNum: Long
          _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum)
          val _tmpEStatus: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfEStatus).toInt()
          _tmpEStatus = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpELastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfELastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfELastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpELastModified = _tmp_2
          }
          val _tmpEStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfEStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfEStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpEStored = _tmp_4
          }
          val _tmpEMetadata: JsonObject?
          val _tmp_5: String?
          if (_stmt.isNull(_columnIndexOfEMetadata)) {
            _tmp_5 = null
          } else {
            _tmp_5 = _stmt.getText(_columnIndexOfEMetadata)
          }
          _tmpEMetadata = __schoolTypeConverters.toJsonObject(_tmp_5)
          val _tmpEClassUid: String
          _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid)
          val _tmpEClassUidNum: Long
          _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum)
          val _tmpEPersonUid: String
          _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid)
          val _tmpEPersonUidNum: Long
          _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum)
          val _tmpERole: EnrollmentRoleEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfERole).toInt()
          _tmpERole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_6)
          val _tmpEBeginDate: LocalDate?
          val _tmp_7: Long?
          if (_stmt.isNull(_columnIndexOfEBeginDate)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfEBeginDate)
          }
          _tmpEBeginDate = __schoolTypeConverters.toLocalDate(_tmp_7)
          val _tmpEEndDate: LocalDate?
          val _tmp_8: Long?
          if (_stmt.isNull(_columnIndexOfEEndDate)) {
            _tmp_8 = null
          } else {
            _tmp_8 = _stmt.getLong(_columnIndexOfEEndDate)
          }
          _tmpEEndDate = __schoolTypeConverters.toLocalDate(_tmp_8)
          val _tmpERemovedAt: Instant?
          val _tmp_9: Long?
          if (_stmt.isNull(_columnIndexOfERemovedAt)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfERemovedAt)
          }
          _tmpERemovedAt = __sharedConverters.toInstant(_tmp_9)
          val _tmpEInviteCode: String?
          if (_stmt.isNull(_columnIndexOfEInviteCode)) {
            _tmpEInviteCode = null
          } else {
            _tmpEInviteCode = _stmt.getText(_columnIndexOfEInviteCode)
          }
          val _tmpEApprovedByPersonUidNum: Long
          _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum)
          val _tmpEApprovedByPersonUid: String?
          if (_stmt.isNull(_columnIndexOfEApprovedByPersonUid)) {
            _tmpEApprovedByPersonUid = null
          } else {
            _tmpEApprovedByPersonUid = _stmt.getText(_columnIndexOfEApprovedByPersonUid)
          }
          _result = EnrollmentEntity(_tmpEUid,_tmpEUidNum,_tmpEStatus,_tmpELastModified,_tmpEStored,_tmpEMetadata,_tmpEClassUid,_tmpEClassUidNum,_tmpEPersonUid,_tmpEPersonUidNum,_tmpERole,_tmpEBeginDate,_tmpEEndDate,_tmpERemovedAt,_tmpEInviteCode,_tmpEApprovedByPersonUidNum,_tmpEApprovedByPersonUid)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByGuidAsFlow(uidNum: Long): Flow<EnrollmentEntity?> {
    val _sql: String = """
        |
        |        SELECT EnrollmentEntity.*
        |          FROM EnrollmentEntity
        |         WHERE EnrollmentEntity.eUidNum = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("EnrollmentEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfEUid: Int = getColumnIndexOrThrow(_stmt, "eUid")
        val _columnIndexOfEUidNum: Int = getColumnIndexOrThrow(_stmt, "eUidNum")
        val _columnIndexOfEStatus: Int = getColumnIndexOrThrow(_stmt, "eStatus")
        val _columnIndexOfELastModified: Int = getColumnIndexOrThrow(_stmt, "eLastModified")
        val _columnIndexOfEStored: Int = getColumnIndexOrThrow(_stmt, "eStored")
        val _columnIndexOfEMetadata: Int = getColumnIndexOrThrow(_stmt, "eMetadata")
        val _columnIndexOfEClassUid: Int = getColumnIndexOrThrow(_stmt, "eClassUid")
        val _columnIndexOfEClassUidNum: Int = getColumnIndexOrThrow(_stmt, "eClassUidNum")
        val _columnIndexOfEPersonUid: Int = getColumnIndexOrThrow(_stmt, "ePersonUid")
        val _columnIndexOfEPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ePersonUidNum")
        val _columnIndexOfERole: Int = getColumnIndexOrThrow(_stmt, "eRole")
        val _columnIndexOfEBeginDate: Int = getColumnIndexOrThrow(_stmt, "eBeginDate")
        val _columnIndexOfEEndDate: Int = getColumnIndexOrThrow(_stmt, "eEndDate")
        val _columnIndexOfERemovedAt: Int = getColumnIndexOrThrow(_stmt, "eRemovedAt")
        val _columnIndexOfEInviteCode: Int = getColumnIndexOrThrow(_stmt, "eInviteCode")
        val _columnIndexOfEApprovedByPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUidNum")
        val _columnIndexOfEApprovedByPersonUid: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUid")
        val _result: EnrollmentEntity?
        if (_stmt.step()) {
          val _tmpEUid: String
          _tmpEUid = _stmt.getText(_columnIndexOfEUid)
          val _tmpEUidNum: Long
          _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum)
          val _tmpEStatus: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfEStatus).toInt()
          _tmpEStatus = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpELastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfELastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfELastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpELastModified = _tmp_2
          }
          val _tmpEStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfEStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfEStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpEStored = _tmp_4
          }
          val _tmpEMetadata: JsonObject?
          val _tmp_5: String?
          if (_stmt.isNull(_columnIndexOfEMetadata)) {
            _tmp_5 = null
          } else {
            _tmp_5 = _stmt.getText(_columnIndexOfEMetadata)
          }
          _tmpEMetadata = __schoolTypeConverters.toJsonObject(_tmp_5)
          val _tmpEClassUid: String
          _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid)
          val _tmpEClassUidNum: Long
          _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum)
          val _tmpEPersonUid: String
          _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid)
          val _tmpEPersonUidNum: Long
          _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum)
          val _tmpERole: EnrollmentRoleEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfERole).toInt()
          _tmpERole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_6)
          val _tmpEBeginDate: LocalDate?
          val _tmp_7: Long?
          if (_stmt.isNull(_columnIndexOfEBeginDate)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfEBeginDate)
          }
          _tmpEBeginDate = __schoolTypeConverters.toLocalDate(_tmp_7)
          val _tmpEEndDate: LocalDate?
          val _tmp_8: Long?
          if (_stmt.isNull(_columnIndexOfEEndDate)) {
            _tmp_8 = null
          } else {
            _tmp_8 = _stmt.getLong(_columnIndexOfEEndDate)
          }
          _tmpEEndDate = __schoolTypeConverters.toLocalDate(_tmp_8)
          val _tmpERemovedAt: Instant?
          val _tmp_9: Long?
          if (_stmt.isNull(_columnIndexOfERemovedAt)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfERemovedAt)
          }
          _tmpERemovedAt = __sharedConverters.toInstant(_tmp_9)
          val _tmpEInviteCode: String?
          if (_stmt.isNull(_columnIndexOfEInviteCode)) {
            _tmpEInviteCode = null
          } else {
            _tmpEInviteCode = _stmt.getText(_columnIndexOfEInviteCode)
          }
          val _tmpEApprovedByPersonUidNum: Long
          _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum)
          val _tmpEApprovedByPersonUid: String?
          if (_stmt.isNull(_columnIndexOfEApprovedByPersonUid)) {
            _tmpEApprovedByPersonUid = null
          } else {
            _tmpEApprovedByPersonUid = _stmt.getText(_columnIndexOfEApprovedByPersonUid)
          }
          _result = EnrollmentEntity(_tmpEUid,_tmpEUidNum,_tmpEStatus,_tmpELastModified,_tmpEStored,_tmpEMetadata,_tmpEClassUid,_tmpEClassUidNum,_tmpEPersonUid,_tmpEPersonUidNum,_tmpERole,_tmpEBeginDate,_tmpEEndDate,_tmpERemovedAt,_tmpEInviteCode,_tmpEApprovedByPersonUidNum,_tmpEApprovedByPersonUid)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun listAsPagingSource(
    authenticatedPersonUidNum: Long,
    since: Long,
    uidNum: Long,
    classUidNum: Long,
    classUidRoleFlag: Int,
    personUidNum: Long,
    activeOnDayInUtcMs: Long,
    notRemovedBefore: Long,
    includeDeleted: Boolean,
    sortByFlag: Int,
  ): PagingSource<Int, EnrollmentEntity> {
    val _sql: String = """
        |
        |          WITH 
        |            AuthenticatedPermissionPersonUids(uidNum) AS (
        |                SELECT ? AS uidNum
        |                UNION
        |                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum
        |                  FROM PersonRelatedPersonEntity
        |                 WHERE 5 IN 
        |                       (SELECT PersonRoleEntity.prRoleEnum
        |                          FROM PersonRoleEntity
        |                         WHERE PersonRoleEntity.prPersonGuidHash = ?)
        |                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     
        |        ,  
        |               
        |            AuthenticatedPersonClassPermissions AS (
        |                SELECT ClassPermissionEntity.*
        |                  FROM ClassPermissionEntity
        |                 WHERE (ClassPermissionEntity.cpeToEnrollmentRole, ClassPermissionEntity.cpeClassUidNum) IN 
        |                       (SELECT EnrollmentEntity.eRole, EnrollmentEntity.eClassUidNum
        |                          FROM EnrollmentEntity
        |                         WHERE EnrollmentEntity.ePersonUidNum IN 
        |                               (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        )
        |                           AND EnrollmentEntity.eStatus = 1)
        |            )
        |        
        |            
        |        SELECT EnrollmentEntity.*
        |          FROM EnrollmentEntity
        |         WHERE (? <= 0 OR EnrollmentEntity.eStored > ?)
        |           AND (? = 0 OR EnrollmentEntity.eUidNum = ?)
        |           AND (? = 0 OR EnrollmentEntity.eClassUidNum = ?)
        |           AND (? = 0 OR EnrollmentEntity.eRole = ?)
        |           AND (? = 0 OR EnrollmentEntity.ePersonUidNum = ?)
        |           AND (? OR EnrollmentEntity.eStatus = 1)
        |           AND (? = 0 
        |                OR (     (? >= COALESCE(EnrollmentEntity.eBeginDate, 0))
        |                    AND ((? - 86399999) < COALESCE(EnrollmentEntity.eEndDate, 9223372036854775807))))
        |           AND (? = 0 OR EnrollmentEntity.eRemovedAt > ?)
        |           AND (   EnrollmentEntity.ePersonUidNum IN 
        |                   (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        ) 
        |                OR EXISTS(
        |                     SELECT 1
        |                       FROM SchoolPermissionGrantEntity
        |                      WHERE SchoolPermissionGrantEntity.spgToRole IN 
        |                            (SELECT PersonRoleEntity.prRoleEnum
        |                               FROM PersonRoleEntity
        |                              WHERE PersonRoleEntity.prPersonGuidHash IN 
        |                                    (SELECT AuthenticatedPermissionPersonUids.uidNum
        |                                       FROM AuthenticatedPermissionPersonUids)
        |                                AND (SchoolPermissionGrantEntity.spgPermissions & (
        |            CASE(EnrollmentEntity.eRole)
        |            WHEN 2 THEN 4
        |            WHEN 4 THEN 4
        |            WHEN 1 THEN 64
        |            WHEN 3 THEN 64
        |            ELSE 9223372036854775807
        |            END
        |        )) > 0))  
        |                OR EXISTS(
        |                     SELECT 1
        |                       FROM AuthenticatedPersonClassPermissions
        |                      WHERE AuthenticatedPersonClassPermissions.cpeClassUidNum = EnrollmentEntity.eClassUidNum
        |                        AND (AuthenticatedPersonClassPermissions.cpePermissions & (
        |            CASE(EnrollmentEntity.eRole)
        |            WHEN 2 THEN 4
        |            WHEN 4 THEN 4
        |            WHEN 1 THEN 64
        |            WHEN 3 THEN 64
        |            ELSE 9223372036854775807
        |            END
        |        )) > 0)
        |               )
        |      ORDER BY CASE(?)
        |                    WHEN 20 THEN EnrollmentEntity.eStored
        |                    ELSE EnrollmentEntity.eUidNum
        |               END
        |        
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql) { _stmt ->
      var _argIndex: Int = 1
      _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
      _argIndex = 2
      _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
      _argIndex = 3
      _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
      _argIndex = 4
      _stmt.bindLong(_argIndex, since)
      _argIndex = 5
      _stmt.bindLong(_argIndex, since)
      _argIndex = 6
      _stmt.bindLong(_argIndex, uidNum)
      _argIndex = 7
      _stmt.bindLong(_argIndex, uidNum)
      _argIndex = 8
      _stmt.bindLong(_argIndex, classUidNum)
      _argIndex = 9
      _stmt.bindLong(_argIndex, classUidNum)
      _argIndex = 10
      _stmt.bindLong(_argIndex, classUidRoleFlag.toLong())
      _argIndex = 11
      _stmt.bindLong(_argIndex, classUidRoleFlag.toLong())
      _argIndex = 12
      _stmt.bindLong(_argIndex, personUidNum)
      _argIndex = 13
      _stmt.bindLong(_argIndex, personUidNum)
      _argIndex = 14
      val _tmp: Int = if (includeDeleted) 1 else 0
      _stmt.bindLong(_argIndex, _tmp.toLong())
      _argIndex = 15
      _stmt.bindLong(_argIndex, activeOnDayInUtcMs)
      _argIndex = 16
      _stmt.bindLong(_argIndex, activeOnDayInUtcMs)
      _argIndex = 17
      _stmt.bindLong(_argIndex, activeOnDayInUtcMs)
      _argIndex = 18
      _stmt.bindLong(_argIndex, notRemovedBefore)
      _argIndex = 19
      _stmt.bindLong(_argIndex, notRemovedBefore)
      _argIndex = 20
      _stmt.bindLong(_argIndex, sortByFlag.toLong())
    }
    return object : LimitOffsetPagingSource<EnrollmentEntity>(_rawQuery, __db, "PersonRelatedPersonEntity", "PersonRoleEntity", "ClassPermissionEntity", "EnrollmentEntity", "SchoolPermissionGrantEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int): List<EnrollmentEntity> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfEUid: Int = getColumnIndexOrThrow(_stmt, "eUid")
          val _columnIndexOfEUidNum: Int = getColumnIndexOrThrow(_stmt, "eUidNum")
          val _columnIndexOfEStatus: Int = getColumnIndexOrThrow(_stmt, "eStatus")
          val _columnIndexOfELastModified: Int = getColumnIndexOrThrow(_stmt, "eLastModified")
          val _columnIndexOfEStored: Int = getColumnIndexOrThrow(_stmt, "eStored")
          val _columnIndexOfEMetadata: Int = getColumnIndexOrThrow(_stmt, "eMetadata")
          val _columnIndexOfEClassUid: Int = getColumnIndexOrThrow(_stmt, "eClassUid")
          val _columnIndexOfEClassUidNum: Int = getColumnIndexOrThrow(_stmt, "eClassUidNum")
          val _columnIndexOfEPersonUid: Int = getColumnIndexOrThrow(_stmt, "ePersonUid")
          val _columnIndexOfEPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ePersonUidNum")
          val _columnIndexOfERole: Int = getColumnIndexOrThrow(_stmt, "eRole")
          val _columnIndexOfEBeginDate: Int = getColumnIndexOrThrow(_stmt, "eBeginDate")
          val _columnIndexOfEEndDate: Int = getColumnIndexOrThrow(_stmt, "eEndDate")
          val _columnIndexOfERemovedAt: Int = getColumnIndexOrThrow(_stmt, "eRemovedAt")
          val _columnIndexOfEInviteCode: Int = getColumnIndexOrThrow(_stmt, "eInviteCode")
          val _columnIndexOfEApprovedByPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUidNum")
          val _columnIndexOfEApprovedByPersonUid: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUid")
          val _result: MutableList<EnrollmentEntity> = mutableListOf()
          while (_stmt.step()) {
            val _item: EnrollmentEntity
            val _tmpEUid: String
            _tmpEUid = _stmt.getText(_columnIndexOfEUid)
            val _tmpEUidNum: Long
            _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum)
            val _tmpEStatus: StatusEnum
            val _tmp_1: Int
            _tmp_1 = _stmt.getLong(_columnIndexOfEStatus).toInt()
            _tmpEStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
            val _tmpELastModified: Instant
            val _tmp_2: Long?
            if (_stmt.isNull(_columnIndexOfELastModified)) {
              _tmp_2 = null
            } else {
              _tmp_2 = _stmt.getLong(_columnIndexOfELastModified)
            }
            val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
            if (_tmp_3 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpELastModified = _tmp_3
            }
            val _tmpEStored: Instant
            val _tmp_4: Long?
            if (_stmt.isNull(_columnIndexOfEStored)) {
              _tmp_4 = null
            } else {
              _tmp_4 = _stmt.getLong(_columnIndexOfEStored)
            }
            val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
            if (_tmp_5 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpEStored = _tmp_5
            }
            val _tmpEMetadata: JsonObject?
            val _tmp_6: String?
            if (_stmt.isNull(_columnIndexOfEMetadata)) {
              _tmp_6 = null
            } else {
              _tmp_6 = _stmt.getText(_columnIndexOfEMetadata)
            }
            _tmpEMetadata = __schoolTypeConverters.toJsonObject(_tmp_6)
            val _tmpEClassUid: String
            _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid)
            val _tmpEClassUidNum: Long
            _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum)
            val _tmpEPersonUid: String
            _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid)
            val _tmpEPersonUidNum: Long
            _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum)
            val _tmpERole: EnrollmentRoleEnum
            val _tmp_7: Int
            _tmp_7 = _stmt.getLong(_columnIndexOfERole).toInt()
            _tmpERole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_7)
            val _tmpEBeginDate: LocalDate?
            val _tmp_8: Long?
            if (_stmt.isNull(_columnIndexOfEBeginDate)) {
              _tmp_8 = null
            } else {
              _tmp_8 = _stmt.getLong(_columnIndexOfEBeginDate)
            }
            _tmpEBeginDate = __schoolTypeConverters.toLocalDate(_tmp_8)
            val _tmpEEndDate: LocalDate?
            val _tmp_9: Long?
            if (_stmt.isNull(_columnIndexOfEEndDate)) {
              _tmp_9 = null
            } else {
              _tmp_9 = _stmt.getLong(_columnIndexOfEEndDate)
            }
            _tmpEEndDate = __schoolTypeConverters.toLocalDate(_tmp_9)
            val _tmpERemovedAt: Instant?
            val _tmp_10: Long?
            if (_stmt.isNull(_columnIndexOfERemovedAt)) {
              _tmp_10 = null
            } else {
              _tmp_10 = _stmt.getLong(_columnIndexOfERemovedAt)
            }
            _tmpERemovedAt = __sharedConverters.toInstant(_tmp_10)
            val _tmpEInviteCode: String?
            if (_stmt.isNull(_columnIndexOfEInviteCode)) {
              _tmpEInviteCode = null
            } else {
              _tmpEInviteCode = _stmt.getText(_columnIndexOfEInviteCode)
            }
            val _tmpEApprovedByPersonUidNum: Long
            _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum)
            val _tmpEApprovedByPersonUid: String?
            if (_stmt.isNull(_columnIndexOfEApprovedByPersonUid)) {
              _tmpEApprovedByPersonUid = null
            } else {
              _tmpEApprovedByPersonUid = _stmt.getText(_columnIndexOfEApprovedByPersonUid)
            }
            _item = EnrollmentEntity(_tmpEUid,_tmpEUidNum,_tmpEStatus,_tmpELastModified,_tmpEStored,_tmpEMetadata,_tmpEClassUid,_tmpEClassUidNum,_tmpEPersonUid,_tmpEPersonUidNum,_tmpERole,_tmpEBeginDate,_tmpEEndDate,_tmpERemovedAt,_tmpEInviteCode,_tmpEApprovedByPersonUidNum,_tmpEApprovedByPersonUid)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public override suspend fun list(
    authenticatedPersonUidNum: Long,
    since: Long,
    uidNum: Long,
    classUidNum: Long,
    classUidRoleFlag: Int,
    personUidNum: Long,
    activeOnDayInUtcMs: Long,
    notRemovedBefore: Long,
    includeDeleted: Boolean,
    sortByFlag: Int,
  ): List<EnrollmentEntity> {
    val _sql: String = """
        |
        |          WITH 
        |            AuthenticatedPermissionPersonUids(uidNum) AS (
        |                SELECT ? AS uidNum
        |                UNION
        |                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum
        |                  FROM PersonRelatedPersonEntity
        |                 WHERE 5 IN 
        |                       (SELECT PersonRoleEntity.prRoleEnum
        |                          FROM PersonRoleEntity
        |                         WHERE PersonRoleEntity.prPersonGuidHash = ?)
        |                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     
        |        ,  
        |               
        |            AuthenticatedPersonClassPermissions AS (
        |                SELECT ClassPermissionEntity.*
        |                  FROM ClassPermissionEntity
        |                 WHERE (ClassPermissionEntity.cpeToEnrollmentRole, ClassPermissionEntity.cpeClassUidNum) IN 
        |                       (SELECT EnrollmentEntity.eRole, EnrollmentEntity.eClassUidNum
        |                          FROM EnrollmentEntity
        |                         WHERE EnrollmentEntity.ePersonUidNum IN 
        |                               (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        )
        |                           AND EnrollmentEntity.eStatus = 1)
        |            )
        |        
        |            
        |        SELECT EnrollmentEntity.*
        |          FROM EnrollmentEntity
        |         WHERE (? <= 0 OR EnrollmentEntity.eStored > ?)
        |           AND (? = 0 OR EnrollmentEntity.eUidNum = ?)
        |           AND (? = 0 OR EnrollmentEntity.eClassUidNum = ?)
        |           AND (? = 0 OR EnrollmentEntity.eRole = ?)
        |           AND (? = 0 OR EnrollmentEntity.ePersonUidNum = ?)
        |           AND (? OR EnrollmentEntity.eStatus = 1)
        |           AND (? = 0 
        |                OR (     (? >= COALESCE(EnrollmentEntity.eBeginDate, 0))
        |                    AND ((? - 86399999) < COALESCE(EnrollmentEntity.eEndDate, 9223372036854775807))))
        |           AND (? = 0 OR EnrollmentEntity.eRemovedAt > ?)
        |           AND (   EnrollmentEntity.ePersonUidNum IN 
        |                   (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        ) 
        |                OR EXISTS(
        |                     SELECT 1
        |                       FROM SchoolPermissionGrantEntity
        |                      WHERE SchoolPermissionGrantEntity.spgToRole IN 
        |                            (SELECT PersonRoleEntity.prRoleEnum
        |                               FROM PersonRoleEntity
        |                              WHERE PersonRoleEntity.prPersonGuidHash IN 
        |                                    (SELECT AuthenticatedPermissionPersonUids.uidNum
        |                                       FROM AuthenticatedPermissionPersonUids)
        |                                AND (SchoolPermissionGrantEntity.spgPermissions & (
        |            CASE(EnrollmentEntity.eRole)
        |            WHEN 2 THEN 4
        |            WHEN 4 THEN 4
        |            WHEN 1 THEN 64
        |            WHEN 3 THEN 64
        |            ELSE 9223372036854775807
        |            END
        |        )) > 0))  
        |                OR EXISTS(
        |                     SELECT 1
        |                       FROM AuthenticatedPersonClassPermissions
        |                      WHERE AuthenticatedPersonClassPermissions.cpeClassUidNum = EnrollmentEntity.eClassUidNum
        |                        AND (AuthenticatedPersonClassPermissions.cpePermissions & (
        |            CASE(EnrollmentEntity.eRole)
        |            WHEN 2 THEN 4
        |            WHEN 4 THEN 4
        |            WHEN 1 THEN 64
        |            WHEN 3 THEN 64
        |            ELSE 9223372036854775807
        |            END
        |        )) > 0)
        |               )
        |      ORDER BY CASE(?)
        |                    WHEN 20 THEN EnrollmentEntity.eStored
        |                    ELSE EnrollmentEntity.eUidNum
        |               END
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 3
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 4
        _stmt.bindLong(_argIndex, since)
        _argIndex = 5
        _stmt.bindLong(_argIndex, since)
        _argIndex = 6
        _stmt.bindLong(_argIndex, uidNum)
        _argIndex = 7
        _stmt.bindLong(_argIndex, uidNum)
        _argIndex = 8
        _stmt.bindLong(_argIndex, classUidNum)
        _argIndex = 9
        _stmt.bindLong(_argIndex, classUidNum)
        _argIndex = 10
        _stmt.bindLong(_argIndex, classUidRoleFlag.toLong())
        _argIndex = 11
        _stmt.bindLong(_argIndex, classUidRoleFlag.toLong())
        _argIndex = 12
        _stmt.bindLong(_argIndex, personUidNum)
        _argIndex = 13
        _stmt.bindLong(_argIndex, personUidNum)
        _argIndex = 14
        val _tmp: Int = if (includeDeleted) 1 else 0
        _stmt.bindLong(_argIndex, _tmp.toLong())
        _argIndex = 15
        _stmt.bindLong(_argIndex, activeOnDayInUtcMs)
        _argIndex = 16
        _stmt.bindLong(_argIndex, activeOnDayInUtcMs)
        _argIndex = 17
        _stmt.bindLong(_argIndex, activeOnDayInUtcMs)
        _argIndex = 18
        _stmt.bindLong(_argIndex, notRemovedBefore)
        _argIndex = 19
        _stmt.bindLong(_argIndex, notRemovedBefore)
        _argIndex = 20
        _stmt.bindLong(_argIndex, sortByFlag.toLong())
        val _columnIndexOfEUid: Int = getColumnIndexOrThrow(_stmt, "eUid")
        val _columnIndexOfEUidNum: Int = getColumnIndexOrThrow(_stmt, "eUidNum")
        val _columnIndexOfEStatus: Int = getColumnIndexOrThrow(_stmt, "eStatus")
        val _columnIndexOfELastModified: Int = getColumnIndexOrThrow(_stmt, "eLastModified")
        val _columnIndexOfEStored: Int = getColumnIndexOrThrow(_stmt, "eStored")
        val _columnIndexOfEMetadata: Int = getColumnIndexOrThrow(_stmt, "eMetadata")
        val _columnIndexOfEClassUid: Int = getColumnIndexOrThrow(_stmt, "eClassUid")
        val _columnIndexOfEClassUidNum: Int = getColumnIndexOrThrow(_stmt, "eClassUidNum")
        val _columnIndexOfEPersonUid: Int = getColumnIndexOrThrow(_stmt, "ePersonUid")
        val _columnIndexOfEPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ePersonUidNum")
        val _columnIndexOfERole: Int = getColumnIndexOrThrow(_stmt, "eRole")
        val _columnIndexOfEBeginDate: Int = getColumnIndexOrThrow(_stmt, "eBeginDate")
        val _columnIndexOfEEndDate: Int = getColumnIndexOrThrow(_stmt, "eEndDate")
        val _columnIndexOfERemovedAt: Int = getColumnIndexOrThrow(_stmt, "eRemovedAt")
        val _columnIndexOfEInviteCode: Int = getColumnIndexOrThrow(_stmt, "eInviteCode")
        val _columnIndexOfEApprovedByPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUidNum")
        val _columnIndexOfEApprovedByPersonUid: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUid")
        val _result: MutableList<EnrollmentEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: EnrollmentEntity
          val _tmpEUid: String
          _tmpEUid = _stmt.getText(_columnIndexOfEUid)
          val _tmpEUidNum: Long
          _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum)
          val _tmpEStatus: StatusEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfEStatus).toInt()
          _tmpEStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
          val _tmpELastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfELastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfELastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpELastModified = _tmp_3
          }
          val _tmpEStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfEStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfEStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpEStored = _tmp_5
          }
          val _tmpEMetadata: JsonObject?
          val _tmp_6: String?
          if (_stmt.isNull(_columnIndexOfEMetadata)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getText(_columnIndexOfEMetadata)
          }
          _tmpEMetadata = __schoolTypeConverters.toJsonObject(_tmp_6)
          val _tmpEClassUid: String
          _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid)
          val _tmpEClassUidNum: Long
          _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum)
          val _tmpEPersonUid: String
          _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid)
          val _tmpEPersonUidNum: Long
          _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum)
          val _tmpERole: EnrollmentRoleEnum
          val _tmp_7: Int
          _tmp_7 = _stmt.getLong(_columnIndexOfERole).toInt()
          _tmpERole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_7)
          val _tmpEBeginDate: LocalDate?
          val _tmp_8: Long?
          if (_stmt.isNull(_columnIndexOfEBeginDate)) {
            _tmp_8 = null
          } else {
            _tmp_8 = _stmt.getLong(_columnIndexOfEBeginDate)
          }
          _tmpEBeginDate = __schoolTypeConverters.toLocalDate(_tmp_8)
          val _tmpEEndDate: LocalDate?
          val _tmp_9: Long?
          if (_stmt.isNull(_columnIndexOfEEndDate)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfEEndDate)
          }
          _tmpEEndDate = __schoolTypeConverters.toLocalDate(_tmp_9)
          val _tmpERemovedAt: Instant?
          val _tmp_10: Long?
          if (_stmt.isNull(_columnIndexOfERemovedAt)) {
            _tmp_10 = null
          } else {
            _tmp_10 = _stmt.getLong(_columnIndexOfERemovedAt)
          }
          _tmpERemovedAt = __sharedConverters.toInstant(_tmp_10)
          val _tmpEInviteCode: String?
          if (_stmt.isNull(_columnIndexOfEInviteCode)) {
            _tmpEInviteCode = null
          } else {
            _tmpEInviteCode = _stmt.getText(_columnIndexOfEInviteCode)
          }
          val _tmpEApprovedByPersonUidNum: Long
          _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum)
          val _tmpEApprovedByPersonUid: String?
          if (_stmt.isNull(_columnIndexOfEApprovedByPersonUid)) {
            _tmpEApprovedByPersonUid = null
          } else {
            _tmpEApprovedByPersonUid = _stmt.getText(_columnIndexOfEApprovedByPersonUid)
          }
          _item = EnrollmentEntity(_tmpEUid,_tmpEUidNum,_tmpEStatus,_tmpELastModified,_tmpEStored,_tmpEMetadata,_tmpEClassUid,_tmpEClassUidNum,_tmpEPersonUid,_tmpEPersonUidNum,_tmpERole,_tmpEBeginDate,_tmpEEndDate,_tmpERemovedAt,_tmpEInviteCode,_tmpEApprovedByPersonUidNum,_tmpEApprovedByPersonUid)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getLastModifiedByUidNum(uidNum: Long): Long? {
    val _sql: String = """
        |
        |        SELECT EnrollmentEntity.eLastModified
        |          FROM EnrollmentEntity
        |         WHERE EnrollmentEntity.eUidNum = ? 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidNumList(uidNums: List<Long>): List<EnrollmentEntity> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT EnrollmentEntity.*")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM EnrollmentEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE EnrollmentEntity.eUidNum IN (")
    val _inputSize: Int = uidNums.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(") ")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uidNums) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfEUid: Int = getColumnIndexOrThrow(_stmt, "eUid")
        val _columnIndexOfEUidNum: Int = getColumnIndexOrThrow(_stmt, "eUidNum")
        val _columnIndexOfEStatus: Int = getColumnIndexOrThrow(_stmt, "eStatus")
        val _columnIndexOfELastModified: Int = getColumnIndexOrThrow(_stmt, "eLastModified")
        val _columnIndexOfEStored: Int = getColumnIndexOrThrow(_stmt, "eStored")
        val _columnIndexOfEMetadata: Int = getColumnIndexOrThrow(_stmt, "eMetadata")
        val _columnIndexOfEClassUid: Int = getColumnIndexOrThrow(_stmt, "eClassUid")
        val _columnIndexOfEClassUidNum: Int = getColumnIndexOrThrow(_stmt, "eClassUidNum")
        val _columnIndexOfEPersonUid: Int = getColumnIndexOrThrow(_stmt, "ePersonUid")
        val _columnIndexOfEPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "ePersonUidNum")
        val _columnIndexOfERole: Int = getColumnIndexOrThrow(_stmt, "eRole")
        val _columnIndexOfEBeginDate: Int = getColumnIndexOrThrow(_stmt, "eBeginDate")
        val _columnIndexOfEEndDate: Int = getColumnIndexOrThrow(_stmt, "eEndDate")
        val _columnIndexOfERemovedAt: Int = getColumnIndexOrThrow(_stmt, "eRemovedAt")
        val _columnIndexOfEInviteCode: Int = getColumnIndexOrThrow(_stmt, "eInviteCode")
        val _columnIndexOfEApprovedByPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUidNum")
        val _columnIndexOfEApprovedByPersonUid: Int = getColumnIndexOrThrow(_stmt, "eApprovedByPersonUid")
        val _result: MutableList<EnrollmentEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: EnrollmentEntity
          val _tmpEUid: String
          _tmpEUid = _stmt.getText(_columnIndexOfEUid)
          val _tmpEUidNum: Long
          _tmpEUidNum = _stmt.getLong(_columnIndexOfEUidNum)
          val _tmpEStatus: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfEStatus).toInt()
          _tmpEStatus = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpELastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfELastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfELastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpELastModified = _tmp_2
          }
          val _tmpEStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfEStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfEStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpEStored = _tmp_4
          }
          val _tmpEMetadata: JsonObject?
          val _tmp_5: String?
          if (_stmt.isNull(_columnIndexOfEMetadata)) {
            _tmp_5 = null
          } else {
            _tmp_5 = _stmt.getText(_columnIndexOfEMetadata)
          }
          _tmpEMetadata = __schoolTypeConverters.toJsonObject(_tmp_5)
          val _tmpEClassUid: String
          _tmpEClassUid = _stmt.getText(_columnIndexOfEClassUid)
          val _tmpEClassUidNum: Long
          _tmpEClassUidNum = _stmt.getLong(_columnIndexOfEClassUidNum)
          val _tmpEPersonUid: String
          _tmpEPersonUid = _stmt.getText(_columnIndexOfEPersonUid)
          val _tmpEPersonUidNum: Long
          _tmpEPersonUidNum = _stmt.getLong(_columnIndexOfEPersonUidNum)
          val _tmpERole: EnrollmentRoleEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfERole).toInt()
          _tmpERole = __schoolTypeConverters.toEnrollmentRoleEnum(_tmp_6)
          val _tmpEBeginDate: LocalDate?
          val _tmp_7: Long?
          if (_stmt.isNull(_columnIndexOfEBeginDate)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getLong(_columnIndexOfEBeginDate)
          }
          _tmpEBeginDate = __schoolTypeConverters.toLocalDate(_tmp_7)
          val _tmpEEndDate: LocalDate?
          val _tmp_8: Long?
          if (_stmt.isNull(_columnIndexOfEEndDate)) {
            _tmp_8 = null
          } else {
            _tmp_8 = _stmt.getLong(_columnIndexOfEEndDate)
          }
          _tmpEEndDate = __schoolTypeConverters.toLocalDate(_tmp_8)
          val _tmpERemovedAt: Instant?
          val _tmp_9: Long?
          if (_stmt.isNull(_columnIndexOfERemovedAt)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getLong(_columnIndexOfERemovedAt)
          }
          _tmpERemovedAt = __sharedConverters.toInstant(_tmp_9)
          val _tmpEInviteCode: String?
          if (_stmt.isNull(_columnIndexOfEInviteCode)) {
            _tmpEInviteCode = null
          } else {
            _tmpEInviteCode = _stmt.getText(_columnIndexOfEInviteCode)
          }
          val _tmpEApprovedByPersonUidNum: Long
          _tmpEApprovedByPersonUidNum = _stmt.getLong(_columnIndexOfEApprovedByPersonUidNum)
          val _tmpEApprovedByPersonUid: String?
          if (_stmt.isNull(_columnIndexOfEApprovedByPersonUid)) {
            _tmpEApprovedByPersonUid = null
          } else {
            _tmpEApprovedByPersonUid = _stmt.getText(_columnIndexOfEApprovedByPersonUid)
          }
          _item_1 = EnrollmentEntity(_tmpEUid,_tmpEUidNum,_tmpEStatus,_tmpELastModified,_tmpEStored,_tmpEMetadata,_tmpEClassUid,_tmpEClassUidNum,_tmpEPersonUid,_tmpEPersonUidNum,_tmpERole,_tmpEBeginDate,_tmpEEndDate,_tmpERemovedAt,_tmpEInviteCode,_tmpEApprovedByPersonUidNum,_tmpEApprovedByPersonUid)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
