/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.school.daos;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.school.entities.SchoolPermissionGrantEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00a7@\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000b\u001a\u00020\nH'J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00142\u0006\u0010\u000b\u001a\u00020\nH'J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00a7@\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u001a\u00c0\u0006\u0003"}, d2={"Lworld/respect/datalayer/db/school/daos/SchoolPermissionGrantDao;", "", "upsert", "", "entities", "", "Lworld/respect/datalayer/db/school/entities/SchoolPermissionGrantEntity;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "list", "authenticatedPersonUidNum", "", "uidNum", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listAsPagingSource", "Landroidx/paging/PagingSource;", "", "getLastModifiedByUidNum", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidNum", "findByUidNumAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findByUidNums", "uidNums", "personHasPermission", "", "permissionFlag", "respect-datalayer-db_debug"})
@Dao
public interface SchoolPermissionGrantDao {
    @Insert(onConflict=1)
    @Nullable
    public Object upsert(@NotNull List<SchoolPermissionGrantEntity> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n          WITH \n            AuthenticatedPermissionPersonUids(uidNum) AS (\n                SELECT :authenticatedPersonUidNum AS uidNum\n                UNION\n                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum\n                  FROM PersonRelatedPersonEntity\n                 WHERE 5 IN \n                       (SELECT PersonRoleEntity.prRoleEnum\n                          FROM PersonRoleEntity\n                         WHERE PersonRoleEntity.prPersonGuidHash = :authenticatedPersonUidNum)\n                   AND PersonRelatedPersonEntity.prpPersonUidNum = :authenticatedPersonUidNum)     \n        \n        SELECT SchoolPermissionGrantEntity.*\n          FROM SchoolPermissionGrantEntity\n         WHERE (:uidNum = 0 OR SchoolPermissionGrantEntity.spgUidNum = :uidNum)\n           AND (SchoolPermissionGrantEntity.spgToRole IN \n                (SELECT PersonRoleEntity.prRoleEnum\n                   FROM PersonRoleEntity\n                  WHERE PersonRoleEntity.prPersonGuidHash IN \n                        (\n            SELECT AuthenticatedPermissionPersonUids.uidNum\n              FROM AuthenticatedPermissionPersonUids\n        )))\n    ")
    @Nullable
    public Object list(long var1, long var3, @NotNull Continuation<? super List<SchoolPermissionGrantEntity>> var5);

    @Query(value="\n        SELECT SchoolPermissionGrantEntity.*\n          FROM SchoolPermissionGrantEntity\n         WHERE (:uidNum = 0 OR SchoolPermissionGrantEntity.spgUidNum = :uidNum)\n    ")
    @NotNull
    public PagingSource<Integer, SchoolPermissionGrantEntity> listAsPagingSource(long var1);

    @Query(value="\n        SELECT SchoolPermissionGrantEntity.spgLastModified\n          FROM SchoolPermissionGrantEntity\n         WHERE SchoolPermissionGrantEntity.spgUidNum = :uidNum\n    ")
    @Nullable
    public Object getLastModifiedByUidNum(long var1, @NotNull Continuation<? super Long> var3);

    @Query(value="\n        SELECT SchoolPermissionGrantEntity.*\n          FROM SchoolPermissionGrantEntity\n         WHERE SchoolPermissionGrantEntity.spgUidNum = :uidNum\n    ")
    @Nullable
    public Object findByUidNum(long var1, @NotNull Continuation<? super SchoolPermissionGrantEntity> var3);

    @Query(value="\n        SELECT SchoolPermissionGrantEntity.*\n          FROM SchoolPermissionGrantEntity\n         WHERE SchoolPermissionGrantEntity.spgUidNum = :uidNum\n    ")
    @NotNull
    public Flow<SchoolPermissionGrantEntity> findByUidNumAsFlow(long var1);

    @Query(value="\n        SELECT SchoolPermissionGrantEntity.*\n          FROM SchoolPermissionGrantEntity\n         WHERE SchoolPermissionGrantEntity.spgUidNum IN (:uidNums)\n    ")
    @Nullable
    public Object findByUidNums(@NotNull List<Long> var1, @NotNull Continuation<? super List<SchoolPermissionGrantEntity>> var2);

    @Query(value="\n        SELECT EXISTS(\n               SELECT 1\n                 FROM SchoolPermissionGrantEntity\n                WHERE SchoolPermissionGrantEntity.spgToRole IN (\n                      SELECT PersonRoleEntity.prRoleEnum\n                        FROM PersonRoleEntity\n                       WHERE PersonRoleEntity.prPersonGuidHash = :authenticatedPersonUidNum) \n                  AND (SchoolPermissionGrantEntity.spgPermissions & :permissionFlag) = :permissionFlag)\n    ")
    @Nullable
    public Object personHasPermission(long var1, long var3, @NotNull Continuation<? super Boolean> var5);
}

