/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRMath;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0011\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/internals/Polynomial;", "", "num", "", "shift", "", "([II)V", "data", "arraycopy", "", "from", "fromPos", "to", "toPos", "length", "get", "i", "len", "mod", "other", "multiply", "qrose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPolynomial.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polynomial.kt\nio/github/alexzhirkevich/qrose/qrcode/internals/Polynomial\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n1663#2,6:60\n13404#2,3:66\n*S KotlinDebug\n*F\n+ 1 Polynomial.kt\nio/github/alexzhirkevich/qrose/qrcode/internals/Polynomial\n*L\n18#1:60,6\n52#1:66,3\n*E\n"})
public final class Polynomial {
    @NotNull
    private final int[] data;
    public static final int $stable = 8;

    public Polynomial(@NotNull int[] num, int shift) {
        int n;
        int n2;
        block2: {
            Intrinsics.checkNotNullParameter(num, "num");
            int[] $this$indexOfFirst$iv = num;
            boolean $i$f$indexOfFirst = false;
            n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                int it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it != 0)) continue;
                n = index$iv;
                break block2;
            }
            n = -1;
        }
        int offset = RangesKt.coerceAtLeast(n, 0);
        int n3 = 0;
        int n4 = num.length - offset + shift;
        int[] nArray = new int[n4];
        Polynomial polynomial = this;
        while (n3 < n4) {
            n2 = n3++;
            nArray[n2] = 0;
        }
        polynomial.data = nArray;
        this.arraycopy(num, offset, this.data, 0, num.length - offset);
    }

    public /* synthetic */ Polynomial(int[] nArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(nArray, n);
    }

    private final void arraycopy(int[] from, int fromPos, int[] to, int toPos, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            to[toPos + i2] = from[fromPos + i2];
        }
    }

    public final int get(int i2) {
        return this.data[i2];
    }

    public final int len() {
        return this.data.length;
    }

    @NotNull
    public final Polynomial multiply(@NotNull Polynomial other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int n = 0;
        int n2 = this.len() + other.len() - 1;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = 0;
        }
        int[] it = nArray;
        boolean bl = false;
        int n4 = this.len();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = other.len();
            for (int j = 0; j < n5; ++j) {
                it[i2 + j] = it[i2 + j] ^ QRMath.INSTANCE.gexp(QRMath.INSTANCE.glog(this.get(i2)) + QRMath.INSTANCE.glog(other.get(j)));
            }
        }
        return new Polynomial(it, 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Polynomial mod(@NotNull Polynomial other) {
        Polynomial polynomial;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.len() - other.len() < 0) {
            polynomial = this;
        } else {
            int ratio = QRMath.INSTANCE.glog(this.get(0)) - QRMath.INSTANCE.glog(other.get(0));
            int[] nArray = Arrays.copyOf(this.data, this.data.length);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
            int[] result2 = nArray;
            int[] $this$forEachIndexed$iv = other.data;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (int item$iv : $this$forEachIndexed$iv) {
                void it;
                int n = index$iv++;
                int n2 = item$iv;
                int i2 = n;
                boolean bl = false;
                result2[i2] = result2[i2] ^ QRMath.INSTANCE.gexp(QRMath.INSTANCE.glog((int)it) + ratio);
            }
            polynomial = new Polynomial(result2, 0, 2, null).mod(other);
        }
        return polynomial;
    }
}

