/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.MyersDiffKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u001e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0010J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J \u0010 \u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Landroidx/compose/ui/node/IntStack;", "", "initialCapacity", "", "<init>", "(I)V", "stack", "", "lastIndex", "get", "index", "size", "getSize", "()I", "resizeStack", "pushRange", "", "oldStart", "oldEnd", "newStart", "newEnd", "pushDiagonal", "x", "y", "pop", "isNotEmpty", "", "sortDiagonals", "quickSort", "start", "end", "elSize", "partition", "swapDiagonal", "i", "j", "compareDiagonal", "a", "b", "ui"})
@SourceDebugExtension(value={"SMAP\nMyersDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyersDiff.kt\nandroidx/compose/ui/node/IntStack\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,488:1\n57#2,4:489\n*S KotlinDebug\n*F\n+ 1 MyersDiff.kt\nandroidx/compose/ui/node/IntStack\n*L\n440#1:489,4\n*E\n"})
final class IntStack {
    @NotNull
    private int[] stack;
    private int lastIndex;

    public IntStack(int initialCapacity) {
        this.stack = new int[initialCapacity];
    }

    public final int get(int index2) {
        return this.stack[index2];
    }

    public final int getSize() {
        return this.lastIndex;
    }

    private final int[] resizeStack(int[] stack) {
        int[] nArray = Arrays.copyOf(stack, stack.length * 2);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
        int[] copy2 = nArray;
        this.stack = copy2;
        return copy2;
    }

    public final void pushRange(int oldStart, int oldEnd, int newStart, int newEnd) {
        int i2 = this.lastIndex;
        int[] stack = this.stack;
        if (i2 + 4 >= stack.length) {
            stack = this.resizeStack(stack);
        }
        stack[i2 + 0] = oldStart;
        stack[i2 + 1] = oldEnd;
        stack[i2 + 2] = newStart;
        stack[i2 + 3] = newEnd;
        this.lastIndex = i2 + 4;
    }

    public final void pushDiagonal(int x2, int y2, int size2) {
        int i2 = this.lastIndex;
        int[] stack = this.stack;
        if (i2 + 3 >= stack.length) {
            stack = this.resizeStack(stack);
        }
        stack[i2 + 0] = x2 + size2;
        stack[i2 + 1] = y2 + size2;
        stack[i2 + 2] = size2;
        this.lastIndex = i2 + 3;
    }

    public final int pop() {
        this.lastIndex += -1;
        return this.stack[this.lastIndex];
    }

    public final boolean isNotEmpty() {
        return this.lastIndex != 0;
    }

    public final void sortDiagonals() {
        int i2 = this.lastIndex;
        boolean value$iv = i2 % 3 == 0;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("Array size not a multiple of 3");
        }
        if (i2 > 3) {
            this.quickSort(0, i2 - 3, 3);
        }
    }

    private final void quickSort(int start2, int end, int elSize) {
        if (start2 < end) {
            int i2 = this.partition(start2, end, elSize);
            this.quickSort(start2, i2 - elSize, elSize);
            this.quickSort(i2 + elSize, end, elSize);
        }
    }

    private final int partition(int start2, int end, int elSize) {
        int i2 = start2 - elSize;
        for (int j = start2; j < end; j += elSize) {
            if (!this.compareDiagonal(j, end)) continue;
            this.swapDiagonal(i2 += elSize, j);
        }
        this.swapDiagonal(i2 + elSize, end);
        return i2 + elSize;
    }

    private final void swapDiagonal(int i2, int j) {
        int[] stack = this.stack;
        MyersDiffKt.access$swap(stack, i2, j);
        MyersDiffKt.access$swap(stack, i2 + 1, j + 1);
        MyersDiffKt.access$swap(stack, i2 + 2, j + 2);
    }

    private final boolean compareDiagonal(int a2, int b2) {
        int[] stack = this.stack;
        int a0 = stack[a2];
        int b0 = stack[b2];
        return a0 < b0 || a0 == b0 && stack[a2 + 1] <= stack[b2 + 1];
    }
}

