/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.kerby.asn1.UniversalTag;
import org.apache.kerby.asn1.type.Asn1Simple;

public abstract class Asn1String
extends Asn1Simple<String> {
    public Asn1String(UniversalTag universalTag) {
        super(universalTag, null);
    }

    public Asn1String(UniversalTag tagNo, String value) {
        super(tagNo, value);
    }

    @Override
    protected void toBytes() {
        if (this.getValue() != null) {
            byte[] bytes = ((String)this.getValue()).getBytes(StandardCharsets.US_ASCII);
            this.setBytes(bytes);
        }
    }

    @Override
    protected int encodingBodyLength() {
        if (this.getValue() != null) {
            return ((String)this.getValue()).length();
        }
        return 0;
    }

    @Override
    protected void toValue() throws IOException {
        byte[] bytes = this.getBytes();
        this.setValue(new String(bytes, StandardCharsets.US_ASCII));
    }

    public static String fromUTF8ByteArray(byte[] bytes) {
        int i2 = 0;
        int length = 0;
        while (i2 < bytes.length) {
            ++length;
            if ((bytes[i2] & 0xF0) == 240) {
                ++length;
                i2 += 4;
                continue;
            }
            if ((bytes[i2] & 0xE0) == 224) {
                i2 += 3;
                continue;
            }
            if ((bytes[i2] & 0xC0) == 192) {
                i2 += 2;
                continue;
            }
            ++i2;
        }
        char[] cs = new char[length];
        i2 = 0;
        length = 0;
        while (i2 < bytes.length) {
            char ch;
            if ((bytes[i2] & 0xF0) == 240) {
                int codePoint = (bytes[i2] & 3) << 18 | (bytes[i2 + 1] & 0x3F) << 12 | (bytes[i2 + 2] & 0x3F) << 6 | bytes[i2 + 3] & 0x3F;
                int u2 = codePoint - 65536;
                char w1 = (char)(0xD800 | u2 >> 10);
                char w2 = (char)(0xDC00 | u2 & 0x3FF);
                cs[length++] = w1;
                ch = w2;
                i2 += 4;
            } else if ((bytes[i2] & 0xE0) == 224) {
                ch = (char)((bytes[i2] & 0xF) << 12 | (bytes[i2 + 1] & 0x3F) << 6 | bytes[i2 + 2] & 0x3F);
                i2 += 3;
            } else if ((bytes[i2] & 0xD0) == 208) {
                ch = (char)((bytes[i2] & 0x1F) << 6 | bytes[i2 + 1] & 0x3F);
                i2 += 2;
            } else if ((bytes[i2] & 0xC0) == 192) {
                ch = (char)((bytes[i2] & 0x1F) << 6 | bytes[i2 + 1] & 0x3F);
                i2 += 2;
            } else {
                ch = (char)(bytes[i2] & 0xFF);
                ++i2;
            }
            cs[length++] = ch;
        }
        return new String(cs);
    }

    public static byte[] toUTF8ByteArray(String string2) {
        return Asn1String.toUTF8ByteArray(string2.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] string2) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            Asn1String.toUTF8ByteArray(string2, bOut);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
        return bOut.toByteArray();
    }

    public static void toUTF8ByteArray(char[] string2, OutputStream sOut) throws IOException {
        char[] c = string2;
        for (int i2 = 0; i2 < c.length; ++i2) {
            char ch = c[i2];
            if (ch < '\u0080') {
                sOut.write(ch);
                continue;
            }
            if (ch < '\u0800') {
                sOut.write(0xC0 | ch >> 6);
                sOut.write(0x80 | ch & 0x3F);
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udfff') {
                if (i2 + 1 >= c.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char w1 = ch;
                char w2 = ch = c[++i2];
                if (w1 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int codePoint = (w1 & 0x3FF) << 10 | (w2 & 0x3FF) + 65536;
                sOut.write(0xF0 | codePoint >> 18);
                sOut.write(0x80 | codePoint >> 12 & 0x3F);
                sOut.write(0x80 | codePoint >> 6 & 0x3F);
                sOut.write(0x80 | codePoint & 0x3F);
                continue;
            }
            sOut.write(0xE0 | ch >> 12);
            sOut.write(0x80 | ch >> 6 & 0x3F);
            sOut.write(0x80 | ch & 0x3F);
        }
    }

    public static String toUpperCase(String string2) {
        boolean changed = false;
        char[] chars = string2.toCharArray();
        for (int i2 = 0; i2 != chars.length; ++i2) {
            char ch = chars[i2];
            if ('a' > ch || 'z' < ch) continue;
            changed = true;
            chars[i2] = (char)(ch - 97 + 65);
        }
        if (changed) {
            return new String(chars);
        }
        return string2;
    }

    public static String toLowerCase(String string2) {
        boolean changed = false;
        char[] chars = string2.toCharArray();
        for (int i2 = 0; i2 != chars.length; ++i2) {
            char ch = chars[i2];
            if ('A' > ch || 'Z' < ch) continue;
            changed = true;
            chars[i2] = (char)(ch - 65 + 97);
        }
        if (changed) {
            return new String(chars);
        }
        return string2;
    }

    public static byte[] toByteArray(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int i2 = 0; i2 != bytes.length; ++i2) {
            bytes[i2] = (byte)chars[i2];
        }
        return bytes;
    }

    public static byte[] toByteArray(String string2) {
        byte[] bytes = new byte[string2.length()];
        for (int i2 = 0; i2 != bytes.length; ++i2) {
            char ch = string2.charAt(i2);
            bytes[i2] = (byte)ch;
        }
        return bytes;
    }

    public static String fromByteArray(byte[] bytes) {
        return new String(Asn1String.asCharArray(bytes));
    }

    public static char[] asCharArray(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i2 = 0; i2 != chars.length; ++i2) {
            chars[i2] = (char)(bytes[i2] & 0xFF);
        }
        return chars;
    }

    public static String[] split(String input2, char delimiter) {
        ArrayList<String> v = new ArrayList<String>();
        boolean moreTokens = true;
        while (moreTokens) {
            int tokenLocation = input2.indexOf(delimiter);
            if (tokenLocation > 0) {
                String subString = input2.substring(0, tokenLocation);
                v.add(subString);
                input2 = input2.substring(tokenLocation + 1);
                continue;
            }
            moreTokens = false;
            v.add(input2);
        }
        return v.toArray(new String[v.size()]);
    }
}

