/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterSet;
import androidx.collection.ScatterSetKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusEventModifierNode;
import androidx.compose.ui.focus.FocusOwner;
import androidx.compose.ui.focus.FocusStateImpl;
import androidx.compose.ui.focus.FocusTargetNode;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.NodeChain;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.node.Owner;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/focus/FocusInvalidationManager;", "", "focusOwner", "Landroidx/compose/ui/focus/FocusOwner;", "owner", "Landroidx/compose/ui/node/Owner;", "<init>", "(Landroidx/compose/ui/focus/FocusOwner;Landroidx/compose/ui/node/Owner;)V", "focusTargetNodes", "Landroidx/collection/MutableScatterSet;", "Landroidx/compose/ui/focus/FocusTargetNode;", "focusEventNodes", "Landroidx/compose/ui/focus/FocusEventModifierNode;", "isInvalidationScheduled", "", "scheduleInvalidation", "", "node", "hasPendingInvalidation", "invalidateNodes", "invalidateOwnerFocusState", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFocusInvalidationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FocusInvalidationManager.kt\nandroidx/compose/ui/focus/FocusInvalidationManager\n+ 2 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 4 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 5 NodeKind.kt\nandroidx/compose/ui/node/NodeKind\n+ 6 DelegatableNode.kt\nandroidx/compose/ui/node/DelegatableNodeKt\n+ 7 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 8 Modifier.kt\nandroidx/compose/ui/Modifier$Node\n*L\n1#1,119:1\n231#2,3:120\n200#2,7:123\n211#2,3:131\n214#2,9:135\n234#2:144\n231#2,3:177\n200#2,7:180\n211#2,3:188\n214#2,9:192\n234#2:201\n1399#3:130\n1270#3:134\n1399#3:187\n1270#3:191\n118#4,9:145\n118#4:168\n54#5:154\n91#6:155\n92#6,8:160\n101#6,7:170\n57#7,4:156\n247#8:169\n*S KotlinDebug\n*F\n+ 1 FocusInvalidationManager.kt\nandroidx/compose/ui/focus/FocusInvalidationManager\n*L\n61#1:120,3\n61#1:123,7\n61#1:131,3\n61#1:135,9\n61#1:144\n98#1:177,3\n98#1:180,7\n98#1:188,3\n98#1:192,9\n98#1:201\n61#1:130\n61#1:134\n98#1:187\n98#1:191\n70#1:145,9\n76#1:168\n70#1:154\n69#1:155\n69#1:160,8\n69#1:170,7\n69#1:156,4\n76#1:169\n*E\n"})
public final class FocusInvalidationManager {
    @NotNull
    private final FocusOwner focusOwner;
    @NotNull
    private final Owner owner;
    @NotNull
    private final MutableScatterSet<FocusTargetNode> focusTargetNodes;
    @NotNull
    private final MutableScatterSet<FocusEventModifierNode> focusEventNodes;
    private boolean isInvalidationScheduled;
    public static final int $stable = 8;

    public FocusInvalidationManager(@NotNull FocusOwner focusOwner, @NotNull Owner owner2) {
        Intrinsics.checkNotNullParameter((Object)focusOwner, (String)"focusOwner");
        Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
        this.focusOwner = focusOwner;
        this.owner = owner2;
        this.focusTargetNodes = ScatterSetKt.mutableScatterSetOf();
        this.focusEventNodes = ScatterSetKt.mutableScatterSetOf();
    }

    public final void scheduleInvalidation(@NotNull FocusTargetNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.focusTargetNodes.add((Object)node)) {
            this.scheduleInvalidation();
        }
    }

    public final void scheduleInvalidation(@NotNull FocusEventModifierNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.focusEventNodes.add((Object)node)) {
            this.scheduleInvalidation();
        }
    }

    public final void scheduleInvalidation() {
        if (!this.isInvalidationScheduled) {
            this.owner.registerOnEndApplyChangesListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    FocusInvalidationManager.access$invalidateNodes((FocusInvalidationManager)this.receiver);
                }
            }));
            this.isInvalidationScheduled = true;
        }
    }

    public final boolean hasPendingInvalidation() {
        return this.isInvalidationScheduled;
    }

    /*
     * WARNING - void declaration
     */
    private final void invalidateNodes() {
        FocusTargetNode activeFocusTargetNode = this.focusOwner.getActiveFocusTargetNode();
        if (activeFocusTargetNode == null) {
            ScatterSet this_$iv = (ScatterSet)this.focusEventNodes;
            boolean $i$f$forEach = false;
            Object[] elements$iv = this_$iv.elements;
            ScatterSet this_$iv$iv = this_$iv;
            boolean $i$f$forEachIndex = false;
            int i$iv$iv = 0;
            long[] m$iv$iv = this_$iv$iv.metadata;
            int lastIndex$iv$iv = m$iv$iv.length - 2;
            if (i$iv$iv <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                        for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                int index$iv$iv;
                                int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                boolean bl = false;
                                FocusEventModifierNode it = (FocusEventModifierNode)elements$iv[index$iv];
                                boolean bl2 = false;
                                it.onFocusEvent(FocusStateImpl.Inactive);
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv != lastIndex$iv$iv) {
                        ++i$iv$iv;
                        continue;
                    }
                    break;
                }
            }
        } else if (activeFocusTargetNode.isAttached()) {
            void $this$visitAncestors$iv;
            boolean other$iv;
            if (this.focusTargetNodes.contains((Object)activeFocusTargetNode)) {
                activeFocusTargetNode.invalidateFocus$ui();
            }
            FocusStateImpl activeFocusTargetNodeState = activeFocusTargetNode.getFocusState();
            int traversedFocusTargetCount = 0;
            DelegatableNode elements$iv = activeFocusTargetNode;
            int n = 0;
            n = NodeKind.constructor-impl(1024);
            int n2 = 0;
            n2 = NodeKind.constructor-impl(4096);
            boolean bl = false;
            arg0$iv |= other$iv;
            other$iv = true;
            boolean $i$f$visitAncestors = false;
            boolean value$iv$iv = $this$visitAncestors$iv.getNode().isAttached();
            boolean $i$f$checkPrecondition = false;
            if (!value$iv$iv) {
                boolean bl3 = false;
                InlineClassHelperKt.throwIllegalStateException("visitAncestors called on an unattached node");
            }
            Modifier.Node node$iv = $this$visitAncestors$iv.getNode();
            LayoutNode layout$iv = DelegatableNodeKt.requireLayoutNode((DelegatableNode)$this$visitAncestors$iv);
            while (layout$iv != null) {
                Object object;
                void mask$iv;
                Modifier.Node head$iv = layout$iv.getNodes$ui().getHead$ui();
                if ((head$iv.getAggregateChildKindSet$ui() & mask$iv) != 0) {
                    while (node$iv != null) {
                        if ((node$iv.getKindSet$ui() & mask$iv) != 0) {
                            void this_$iv;
                            Modifier.Node it = node$iv;
                            boolean bl4 = false;
                            Modifier.Node node = it;
                            boolean bl5 = false;
                            int kind$iv = NodeKind.constructor-impl(1024);
                            boolean bl6 = false;
                            if ((this_$iv.getKindSet$ui() & kind$iv) != 0) {
                                ++traversedFocusTargetCount;
                            }
                            if (it instanceof FocusEventModifierNode && this.focusEventNodes.contains((Object)it)) {
                                if (traversedFocusTargetCount <= 1) {
                                    ((FocusEventModifierNode)((Object)it)).onFocusEvent(activeFocusTargetNodeState);
                                } else {
                                    ((FocusEventModifierNode)((Object)it)).onFocusEvent(FocusStateImpl.ActiveParent);
                                }
                                this.focusEventNodes.remove((Object)it);
                            }
                        }
                        node$iv = node$iv.getParent$ui();
                    }
                }
                node$iv = (object = (layout$iv = layout$iv.getParent$ui())) != null && (object = ((LayoutNode)object).getNodes$ui()) != null ? ((NodeChain)object).getTail$ui() : null;
            }
            ScatterSet this_$iv = (ScatterSet)this.focusEventNodes;
            boolean $i$f$forEach = false;
            Object[] elements$iv2 = this_$iv.elements;
            ScatterSet this_$iv$iv = this_$iv;
            boolean $i$f$forEachIndex = false;
            int i$iv$iv = 0;
            long[] m$iv$iv = this_$iv$iv.metadata;
            int lastIndex$iv$iv = m$iv$iv.length - 2;
            if (i$iv$iv <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                        for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                int index$iv$iv;
                                int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                boolean bl7 = false;
                                FocusEventModifierNode it = (FocusEventModifierNode)elements$iv2[index$iv];
                                boolean bl8 = false;
                                it.onFocusEvent(FocusStateImpl.Inactive);
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv == lastIndex$iv$iv) break;
                    ++i$iv$iv;
                }
            }
        }
        this.invalidateOwnerFocusState();
        this.focusTargetNodes.clear();
        this.focusEventNodes.clear();
        this.isInvalidationScheduled = false;
    }

    private final void invalidateOwnerFocusState() {
        if (this.focusOwner.getActiveFocusTargetNode() == null || this.focusOwner.getRootState() == FocusStateImpl.Inactive) {
            this.focusOwner.clearOwnerFocus();
        }
    }

    public static final /* synthetic */ void access$invalidateNodes(FocusInvalidationManager $this) {
        $this.invalidateNodes();
    }
}

