/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HMACGetSecretInput {
    private final byte[] salt1;
    private final byte[] salt2;

    public HMACGetSecretInput(@NotNull byte[] salt1, @Nullable byte[] salt2) {
        this.salt1 = ArrayUtil.clone(salt1);
        this.salt2 = ArrayUtil.clone(salt2);
    }

    public HMACGetSecretInput(@NotNull byte[] salt1) {
        this.salt1 = ArrayUtil.clone(salt1);
        this.salt2 = null;
    }

    @NotNull
    public byte[] getSalt1() {
        return ArrayUtil.clone(this.salt1);
    }

    @Nullable
    public byte[] getSalt2() {
        return ArrayUtil.clone(this.salt2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMACGetSecretInput that = (HMACGetSecretInput)o;
        return Arrays.equals(this.salt1, that.salt1) && Arrays.equals(this.salt2, that.salt2);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.salt1);
        result2 = 31 * result2 + Arrays.hashCode(this.salt2);
        return result2;
    }
}

