/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal;

import com.ethlo.time.Duration;
import java.time.format.DateTimeParseException;

class DurationPartsConsumer {
    private static final int[] POW10_TABLE = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    private final int startOffset;
    private final boolean negative;
    private long seconds;
    private int nano;
    private boolean readingFractionalPart;
    private boolean afterT;
    private boolean pFound;
    private int wFound;
    private int dFound;
    private int hFound;
    private int mFound;
    private int sFound;
    private boolean dotFound;
    private boolean fractionsFound;

    DurationPartsConsumer(int startOffset, boolean negative) {
        this.startOffset = startOffset;
        this.negative = negative;
    }

    protected static void error(String errorMessage, String text, int index2) {
        throw new DateTimeParseException(errorMessage + ": " + text, text, index2);
    }

    public final void accept(String text, int index2, int length, char unit, long value) {
        int relIndex = index2 - this.startOffset;
        if (relIndex == 0) {
            if (unit != 'P') {
                DurationPartsConsumer.error("Duration must start with 'P'", text, index2);
            }
            this.pFound = true;
            return;
        }
        if (!this.pFound) {
            DurationPartsConsumer.error("Duration must start with 'P'", text, index2);
        }
        if (unit == '\u0000') {
            if (!this.dotFound) {
                DurationPartsConsumer.error("No unit defined for value " + value, text, index2);
            }
            DurationPartsConsumer.error("No unit defined for value " + this.seconds % 60L + '.' + value, text, index2);
        }
        if (length == 0 && (unit == 'W' || unit == 'D' || unit == 'H' || unit == 'M' || unit == 'S' || unit == '.')) {
            DurationPartsConsumer.error("Zero-length value prior to unit '" + unit + "'", text, index2);
        }
        switch (unit) {
            case 'T': {
                if (length != 0) {
                    DurationPartsConsumer.error("There is no unit for the number prior to the 'T'", text, index2);
                }
                this.assertNonFractional('T', text, index2);
                if (this.afterT) {
                    DurationPartsConsumer.error("Only one 'T' is allowed and must precede time units", text, index2);
                }
                this.afterT = true;
                break;
            }
            case 'W': {
                this.assertNonFractional('W', text, index2);
                if (this.wFound > 0) {
                    DurationPartsConsumer.error("'W' (week) can only appear once", text, index2);
                }
                if (this.afterT) {
                    DurationPartsConsumer.error("'W' (week) must appear before 'T' in the duration", text, index2);
                }
                this.seconds = Math.addExact(this.seconds, Math.multiplyExact(value, 604800L));
                this.wFound = index2;
                break;
            }
            case 'D': {
                this.assertNonFractional('D', text, index2);
                if (this.dFound > 0) {
                    DurationPartsConsumer.error("'D' (days) can only appear once", text, index2);
                }
                if (this.afterT) {
                    DurationPartsConsumer.error("'D' (days) must appear before 'T' in the duration", text, index2);
                }
                this.seconds = Math.addExact(this.seconds, Math.multiplyExact(value, 86400L));
                this.dFound = index2;
                break;
            }
            case 'H': {
                this.assertNonFractional('H', text, index2);
                if (this.hFound > 0) {
                    DurationPartsConsumer.error("'H' (hours) can only appear once", text, index2);
                }
                if (!this.afterT) {
                    DurationPartsConsumer.error("'H' (hours) must appear after 'T' in the duration", text, index2);
                }
                this.seconds = Math.addExact(this.seconds, Math.multiplyExact(value, 3600L));
                this.hFound = index2;
                break;
            }
            case 'M': {
                this.assertNonFractional('M', text, index2);
                if (this.mFound > 0) {
                    DurationPartsConsumer.error("'M' (minutes) can only appear once", text, index2);
                }
                if (!this.afterT) {
                    DurationPartsConsumer.error("'M' (minutes) must appear after 'T' in the duration", text, index2);
                }
                this.seconds = Math.addExact(this.seconds, Math.multiplyExact(value, 60L));
                this.mFound = index2;
                break;
            }
            case 'S': {
                if (this.sFound > 0) {
                    DurationPartsConsumer.error("'S' (seconds) can only appear once", text, index2);
                }
                if (!this.afterT) {
                    DurationPartsConsumer.error("'S' (seconds) must appear after 'T' in the duration", text, index2);
                }
                this.sFound = index2;
                if (this.readingFractionalPart) {
                    if (length > 9) {
                        DurationPartsConsumer.error("Maximum allowed is 9 fraction digits", text, index2);
                    }
                    this.nano = Math.toIntExact(value);
                    int remainingDigits = 9 - length;
                    if (remainingDigits > 0) {
                        this.nano *= POW10_TABLE[remainingDigits];
                    }
                    if (this.negative && this.nano > 0) {
                        ++this.seconds;
                        this.nano = 1000000000 - this.nano;
                    }
                    this.fractionsFound = true;
                    this.readingFractionalPart = false;
                    break;
                }
                this.seconds += value;
                break;
            }
            case '.': {
                if (this.dotFound) {
                    DurationPartsConsumer.error("'.' can only appear once", text, index2);
                }
                if (!this.afterT) {
                    DurationPartsConsumer.error("Fractional seconds (.) must come after 'T'", text, index2);
                }
                this.readingFractionalPart = true;
                this.seconds += value;
                this.dotFound = true;
                break;
            }
            default: {
                DurationPartsConsumer.error("Invalid unit: " + unit, text, index2);
            }
        }
    }

    private void assertNonFractional(char unit, String chars, int index2) {
        if (this.readingFractionalPart) {
            DurationPartsConsumer.error("Cannot have fractional values for unit " + unit, chars, index2);
        }
    }

    public void validate(String chars, int index2) {
        if (this.afterT && this.hFound + this.mFound + this.sFound == 0) {
            DurationPartsConsumer.error("Expected at least one value and unit after the 'T'", chars, index2);
        }
        if (this.dotFound && !this.fractionsFound) {
            DurationPartsConsumer.error("Expected at least one fractional digit after the dot", chars, index2);
        }
        if (this.fractionsFound && this.sFound == 0) {
            DurationPartsConsumer.error("Expected 'S' after fractional number", chars, index2);
        }
        if (this.wFound + this.dFound + this.hFound + this.mFound + this.sFound == 0) {
            DurationPartsConsumer.error("Expected at least one value and unit", chars, index2);
        }
        this.validateUnitOrder(chars);
    }

    private void validateUnitOrder(String chars) {
        int lastIndex = -1;
        lastIndex = this.verifyUnitIndex(this.wFound, lastIndex, chars);
        lastIndex = this.verifyUnitIndex(this.dFound, lastIndex, chars);
        lastIndex = this.verifyUnitIndex(this.hFound, lastIndex, chars);
        lastIndex = this.verifyUnitIndex(this.mFound, lastIndex, chars);
        lastIndex = this.verifyUnitIndex(this.sFound, lastIndex, chars);
    }

    private int verifyUnitIndex(int unitIndex, int lastIndex, String chars) {
        if (unitIndex > 0) {
            if (unitIndex < lastIndex) {
                DurationPartsConsumer.error("Units must be in order from largest to smallest", chars, unitIndex);
            }
            return unitIndex;
        }
        return lastIndex;
    }

    public Duration getResult() {
        return Duration.of(this.negative ? -this.seconds : this.seconds, this.nano);
    }
}

