/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

final class UnsafeByteBufUtil {
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();
    private static final byte ZERO = 0;
    private static final int MAX_HAND_ROLLED_SET_ZERO_BYTES = 64;

    static byte getByte(long address2) {
        return PlatformDependent.getByte(address2);
    }

    static short getShort(long address2) {
        if (UNALIGNED) {
            short v = PlatformDependent.getShort(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Short.reverseBytes(v);
        }
        return (short)(PlatformDependent.getByte(address2) << 8 | PlatformDependent.getByte(address2 + 1L) & 0xFF);
    }

    static short getShortLE(long address2) {
        if (UNALIGNED) {
            short v = PlatformDependent.getShort(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(v) : v;
        }
        return (short)(PlatformDependent.getByte(address2) & 0xFF | PlatformDependent.getByte(address2 + 1L) << 8);
    }

    static int getUnsignedMedium(long address2) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte(address2) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort(address2 + 1L) : Short.reverseBytes(PlatformDependent.getShort(address2 + 1L))) & 0xFFFF;
        }
        return (PlatformDependent.getByte(address2) & 0xFF) << 16 | (PlatformDependent.getByte(address2 + 1L) & 0xFF) << 8 | PlatformDependent.getByte(address2 + 2L) & 0xFF;
    }

    static int getUnsignedMediumLE(long address2) {
        if (UNALIGNED) {
            return PlatformDependent.getByte(address2) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort(address2 + 1L)) : PlatformDependent.getShort(address2 + 1L)) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte(address2) & 0xFF | (PlatformDependent.getByte(address2 + 1L) & 0xFF) << 8 | (PlatformDependent.getByte(address2 + 2L) & 0xFF) << 16;
    }

    static int getInt(long address2) {
        if (UNALIGNED) {
            int v = PlatformDependent.getInt(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Integer.reverseBytes(v);
        }
        return PlatformDependent.getByte(address2) << 24 | (PlatformDependent.getByte(address2 + 1L) & 0xFF) << 16 | (PlatformDependent.getByte(address2 + 2L) & 0xFF) << 8 | PlatformDependent.getByte(address2 + 3L) & 0xFF;
    }

    static int getIntLE(long address2) {
        if (UNALIGNED) {
            int v = PlatformDependent.getInt(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(v) : v;
        }
        return PlatformDependent.getByte(address2) & 0xFF | (PlatformDependent.getByte(address2 + 1L) & 0xFF) << 8 | (PlatformDependent.getByte(address2 + 2L) & 0xFF) << 16 | PlatformDependent.getByte(address2 + 3L) << 24;
    }

    static long getLong(long address2) {
        if (UNALIGNED) {
            long v = PlatformDependent.getLong(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Long.reverseBytes(v);
        }
        return (long)PlatformDependent.getByte(address2) << 56 | ((long)PlatformDependent.getByte(address2 + 1L) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(address2 + 2L) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(address2 + 3L) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(address2 + 4L) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(address2 + 5L) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(address2 + 6L) & 0xFFL) << 8 | (long)PlatformDependent.getByte(address2 + 7L) & 0xFFL;
    }

    static long getLongLE(long address2) {
        if (UNALIGNED) {
            long v = PlatformDependent.getLong(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(v) : v;
        }
        return (long)PlatformDependent.getByte(address2) & 0xFFL | ((long)PlatformDependent.getByte(address2 + 1L) & 0xFFL) << 8 | ((long)PlatformDependent.getByte(address2 + 2L) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(address2 + 3L) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(address2 + 4L) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(address2 + 5L) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(address2 + 6L) & 0xFFL) << 48 | (long)PlatformDependent.getByte(address2 + 7L) << 56;
    }

    static void setByte(long address2, int value) {
        PlatformDependent.putByte(address2, (byte)value);
    }

    static void setShort(long address2, int value) {
        if (UNALIGNED) {
            PlatformDependent.putShort(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value));
        } else {
            PlatformDependent.putByte(address2, (byte)(value >>> 8));
            PlatformDependent.putByte(address2 + 1L, (byte)value);
        }
    }

    static void setShortLE(long address2, int value) {
        if (UNALIGNED) {
            PlatformDependent.putShort(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)value) : (short)value);
        } else {
            PlatformDependent.putByte(address2, (byte)value);
            PlatformDependent.putByte(address2 + 1L, (byte)(value >>> 8));
        }
    }

    static void setMedium(long address2, int value) {
        PlatformDependent.putByte(address2, (byte)(value >>> 16));
        if (UNALIGNED) {
            PlatformDependent.putShort(address2 + 1L, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value));
        } else {
            PlatformDependent.putByte(address2 + 1L, (byte)(value >>> 8));
            PlatformDependent.putByte(address2 + 2L, (byte)value);
        }
    }

    static void setMediumLE(long address2, int value) {
        PlatformDependent.putByte(address2, (byte)value);
        if (UNALIGNED) {
            PlatformDependent.putShort(address2 + 1L, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(value >>> 8)) : (short)(value >>> 8));
        } else {
            PlatformDependent.putByte(address2 + 1L, (byte)(value >>> 8));
            PlatformDependent.putByte(address2 + 2L, (byte)(value >>> 16));
        }
    }

    static void setInt(long address2, int value) {
        if (UNALIGNED) {
            PlatformDependent.putInt(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Integer.reverseBytes(value));
        } else {
            PlatformDependent.putByte(address2, (byte)(value >>> 24));
            PlatformDependent.putByte(address2 + 1L, (byte)(value >>> 16));
            PlatformDependent.putByte(address2 + 2L, (byte)(value >>> 8));
            PlatformDependent.putByte(address2 + 3L, (byte)value);
        }
    }

    static void setIntLE(long address2, int value) {
        if (UNALIGNED) {
            PlatformDependent.putInt(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(value) : value);
        } else {
            PlatformDependent.putByte(address2, (byte)value);
            PlatformDependent.putByte(address2 + 1L, (byte)(value >>> 8));
            PlatformDependent.putByte(address2 + 2L, (byte)(value >>> 16));
            PlatformDependent.putByte(address2 + 3L, (byte)(value >>> 24));
        }
    }

    static void setLong(long address2, long value) {
        if (UNALIGNED) {
            PlatformDependent.putLong(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Long.reverseBytes(value));
        } else {
            PlatformDependent.putByte(address2, (byte)(value >>> 56));
            PlatformDependent.putByte(address2 + 1L, (byte)(value >>> 48));
            PlatformDependent.putByte(address2 + 2L, (byte)(value >>> 40));
            PlatformDependent.putByte(address2 + 3L, (byte)(value >>> 32));
            PlatformDependent.putByte(address2 + 4L, (byte)(value >>> 24));
            PlatformDependent.putByte(address2 + 5L, (byte)(value >>> 16));
            PlatformDependent.putByte(address2 + 6L, (byte)(value >>> 8));
            PlatformDependent.putByte(address2 + 7L, (byte)value);
        }
    }

    static void setLongLE(long address2, long value) {
        if (UNALIGNED) {
            PlatformDependent.putLong(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(value) : value);
        } else {
            PlatformDependent.putByte(address2, (byte)value);
            PlatformDependent.putByte(address2 + 1L, (byte)(value >>> 8));
            PlatformDependent.putByte(address2 + 2L, (byte)(value >>> 16));
            PlatformDependent.putByte(address2 + 3L, (byte)(value >>> 24));
            PlatformDependent.putByte(address2 + 4L, (byte)(value >>> 32));
            PlatformDependent.putByte(address2 + 5L, (byte)(value >>> 40));
            PlatformDependent.putByte(address2 + 6L, (byte)(value >>> 48));
            PlatformDependent.putByte(address2 + 7L, (byte)(value >>> 56));
        }
    }

    static byte getByte(byte[] array2, int index2) {
        return PlatformDependent.getByte(array2, index2);
    }

    static short getShort(byte[] array2, int index2) {
        if (UNALIGNED) {
            short v = PlatformDependent.getShort(array2, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Short.reverseBytes(v);
        }
        return (short)(PlatformDependent.getByte(array2, index2) << 8 | PlatformDependent.getByte(array2, index2 + 1) & 0xFF);
    }

    static short getShortLE(byte[] array2, int index2) {
        if (UNALIGNED) {
            short v = PlatformDependent.getShort(array2, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(v) : v;
        }
        return (short)(PlatformDependent.getByte(array2, index2) & 0xFF | PlatformDependent.getByte(array2, index2 + 1) << 8);
    }

    static int getUnsignedMedium(byte[] array2, int index2) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte(array2, index2) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort(array2, index2 + 1) : Short.reverseBytes(PlatformDependent.getShort(array2, index2 + 1))) & 0xFFFF;
        }
        return (PlatformDependent.getByte(array2, index2) & 0xFF) << 16 | (PlatformDependent.getByte(array2, index2 + 1) & 0xFF) << 8 | PlatformDependent.getByte(array2, index2 + 2) & 0xFF;
    }

    static int getUnsignedMediumLE(byte[] array2, int index2) {
        if (UNALIGNED) {
            return PlatformDependent.getByte(array2, index2) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort(array2, index2 + 1)) : PlatformDependent.getShort(array2, index2 + 1)) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte(array2, index2) & 0xFF | (PlatformDependent.getByte(array2, index2 + 1) & 0xFF) << 8 | (PlatformDependent.getByte(array2, index2 + 2) & 0xFF) << 16;
    }

    static int getInt(byte[] array2, int index2) {
        if (UNALIGNED) {
            int v = PlatformDependent.getInt(array2, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Integer.reverseBytes(v);
        }
        return PlatformDependent.getByte(array2, index2) << 24 | (PlatformDependent.getByte(array2, index2 + 1) & 0xFF) << 16 | (PlatformDependent.getByte(array2, index2 + 2) & 0xFF) << 8 | PlatformDependent.getByte(array2, index2 + 3) & 0xFF;
    }

    static int getIntLE(byte[] array2, int index2) {
        if (UNALIGNED) {
            int v = PlatformDependent.getInt(array2, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(v) : v;
        }
        return PlatformDependent.getByte(array2, index2) & 0xFF | (PlatformDependent.getByte(array2, index2 + 1) & 0xFF) << 8 | (PlatformDependent.getByte(array2, index2 + 2) & 0xFF) << 16 | PlatformDependent.getByte(array2, index2 + 3) << 24;
    }

    static long getLong(byte[] array2, int index2) {
        if (UNALIGNED) {
            long v = PlatformDependent.getLong(array2, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Long.reverseBytes(v);
        }
        return (long)PlatformDependent.getByte(array2, index2) << 56 | ((long)PlatformDependent.getByte(array2, index2 + 1) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(array2, index2 + 2) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(array2, index2 + 3) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(array2, index2 + 4) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(array2, index2 + 5) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(array2, index2 + 6) & 0xFFL) << 8 | (long)PlatformDependent.getByte(array2, index2 + 7) & 0xFFL;
    }

    static long getLongLE(byte[] array2, int index2) {
        if (UNALIGNED) {
            long v = PlatformDependent.getLong(array2, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(v) : v;
        }
        return (long)PlatformDependent.getByte(array2, index2) & 0xFFL | ((long)PlatformDependent.getByte(array2, index2 + 1) & 0xFFL) << 8 | ((long)PlatformDependent.getByte(array2, index2 + 2) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(array2, index2 + 3) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(array2, index2 + 4) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(array2, index2 + 5) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(array2, index2 + 6) & 0xFFL) << 48 | (long)PlatformDependent.getByte(array2, index2 + 7) << 56;
    }

    static void setByte(byte[] array2, int index2, int value) {
        PlatformDependent.putByte(array2, index2, (byte)value);
    }

    static void setShort(byte[] array2, int index2, int value) {
        if (UNALIGNED) {
            PlatformDependent.putShort(array2, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value));
        } else {
            PlatformDependent.putByte(array2, index2, (byte)(value >>> 8));
            PlatformDependent.putByte(array2, index2 + 1, (byte)value);
        }
    }

    static void setShortLE(byte[] array2, int index2, int value) {
        if (UNALIGNED) {
            PlatformDependent.putShort(array2, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)value) : (short)value);
        } else {
            PlatformDependent.putByte(array2, index2, (byte)value);
            PlatformDependent.putByte(array2, index2 + 1, (byte)(value >>> 8));
        }
    }

    static void setMedium(byte[] array2, int index2, int value) {
        PlatformDependent.putByte(array2, index2, (byte)(value >>> 16));
        if (UNALIGNED) {
            PlatformDependent.putShort(array2, index2 + 1, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value));
        } else {
            PlatformDependent.putByte(array2, index2 + 1, (byte)(value >>> 8));
            PlatformDependent.putByte(array2, index2 + 2, (byte)value);
        }
    }

    static void setMediumLE(byte[] array2, int index2, int value) {
        PlatformDependent.putByte(array2, index2, (byte)value);
        if (UNALIGNED) {
            PlatformDependent.putShort(array2, index2 + 1, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(value >>> 8)) : (short)(value >>> 8));
        } else {
            PlatformDependent.putByte(array2, index2 + 1, (byte)(value >>> 8));
            PlatformDependent.putByte(array2, index2 + 2, (byte)(value >>> 16));
        }
    }

    static void setInt(byte[] array2, int index2, int value) {
        if (UNALIGNED) {
            PlatformDependent.putInt(array2, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Integer.reverseBytes(value));
        } else {
            PlatformDependent.putByte(array2, index2, (byte)(value >>> 24));
            PlatformDependent.putByte(array2, index2 + 1, (byte)(value >>> 16));
            PlatformDependent.putByte(array2, index2 + 2, (byte)(value >>> 8));
            PlatformDependent.putByte(array2, index2 + 3, (byte)value);
        }
    }

    static void setIntLE(byte[] array2, int index2, int value) {
        if (UNALIGNED) {
            PlatformDependent.putInt(array2, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(value) : value);
        } else {
            PlatformDependent.putByte(array2, index2, (byte)value);
            PlatformDependent.putByte(array2, index2 + 1, (byte)(value >>> 8));
            PlatformDependent.putByte(array2, index2 + 2, (byte)(value >>> 16));
            PlatformDependent.putByte(array2, index2 + 3, (byte)(value >>> 24));
        }
    }

    static void setLong(byte[] array2, int index2, long value) {
        if (UNALIGNED) {
            PlatformDependent.putLong(array2, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Long.reverseBytes(value));
        } else {
            PlatformDependent.putByte(array2, index2, (byte)(value >>> 56));
            PlatformDependent.putByte(array2, index2 + 1, (byte)(value >>> 48));
            PlatformDependent.putByte(array2, index2 + 2, (byte)(value >>> 40));
            PlatformDependent.putByte(array2, index2 + 3, (byte)(value >>> 32));
            PlatformDependent.putByte(array2, index2 + 4, (byte)(value >>> 24));
            PlatformDependent.putByte(array2, index2 + 5, (byte)(value >>> 16));
            PlatformDependent.putByte(array2, index2 + 6, (byte)(value >>> 8));
            PlatformDependent.putByte(array2, index2 + 7, (byte)value);
        }
    }

    static void setLongLE(byte[] array2, int index2, long value) {
        if (UNALIGNED) {
            PlatformDependent.putLong(array2, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(value) : value);
        } else {
            PlatformDependent.putByte(array2, index2, (byte)value);
            PlatformDependent.putByte(array2, index2 + 1, (byte)(value >>> 8));
            PlatformDependent.putByte(array2, index2 + 2, (byte)(value >>> 16));
            PlatformDependent.putByte(array2, index2 + 3, (byte)(value >>> 24));
            PlatformDependent.putByte(array2, index2 + 4, (byte)(value >>> 32));
            PlatformDependent.putByte(array2, index2 + 5, (byte)(value >>> 40));
            PlatformDependent.putByte(array2, index2 + 6, (byte)(value >>> 48));
            PlatformDependent.putByte(array2, index2 + 7, (byte)(value >>> 56));
        }
    }

    private static void batchSetZero(byte[] data2, int index2, int length) {
        int longBatches = length >>> 3;
        for (int i2 = 0; i2 < longBatches; ++i2) {
            PlatformDependent.putLong(data2, index2, 0L);
            index2 += 8;
        }
        int remaining = length & 7;
        for (int i3 = 0; i3 < remaining; ++i3) {
            PlatformDependent.putByte(data2, index2 + i3, (byte)0);
        }
    }

    static void setZero(byte[] array2, int index2, int length) {
        if (length == 0) {
            return;
        }
        if (UNALIGNED && length <= 64) {
            UnsafeByteBufUtil.batchSetZero(array2, index2, length);
        } else {
            PlatformDependent.setMemory(array2, index2, length, (byte)0);
        }
    }

    static ByteBuf copy(AbstractByteBuf buf, long addr, int index2, int length) {
        buf.checkIndex(index2, length);
        ByteBuf copy2 = buf.alloc().directBuffer(length, buf.maxCapacity());
        if (length != 0) {
            if (copy2.hasMemoryAddress()) {
                PlatformDependent.copyMemory(addr, copy2.memoryAddress(), length);
                copy2.setIndex(0, length);
            } else {
                copy2.writeBytes(buf, index2, length);
            }
        }
        return copy2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setBytes(AbstractByteBuf buf, long addr, int index2, InputStream in, int length) throws IOException {
        buf.checkIndex(index2, length);
        ByteBuf tmpBuf = buf.alloc().heapBuffer(length);
        try {
            byte[] tmp = tmpBuf.array();
            int offset = tmpBuf.arrayOffset();
            int readBytes2 = in.read(tmp, offset, length);
            if (readBytes2 > 0) {
                PlatformDependent.copyMemory(tmp, offset, addr, (long)readBytes2);
            }
            int n = readBytes2;
            return n;
        }
        finally {
            tmpBuf.release();
        }
    }

    static void getBytes(AbstractByteBuf buf, long addr, int index2, ByteBuf dst, int dstIndex, int length) {
        buf.checkIndex(index2, length);
        ObjectUtil.checkNotNull(dst, "dst");
        if (MathUtil.isOutOfBounds(dstIndex, length, dst.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory(addr, dst.memoryAddress() + (long)dstIndex, length);
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory(addr, dst.array(), dst.arrayOffset() + dstIndex, (long)length);
        } else {
            dst.setBytes(dstIndex, buf, index2, length);
        }
    }

    static void getBytes(AbstractByteBuf buf, long addr, int index2, byte[] dst, int dstIndex, int length) {
        buf.checkIndex(index2, length);
        ObjectUtil.checkNotNull(dst, "dst");
        if (MathUtil.isOutOfBounds(dstIndex, length, dst.length)) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (length != 0) {
            PlatformDependent.copyMemory(addr, dst, dstIndex, (long)length);
        }
    }

    static void getBytes(AbstractByteBuf buf, long addr, int index2, ByteBuffer dst) {
        buf.checkIndex(index2, dst.remaining());
        if (dst.remaining() == 0) {
            return;
        }
        if (dst.isDirect()) {
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            long dstAddress = PlatformDependent.directBufferAddress(dst);
            PlatformDependent.copyMemory(addr, dstAddress + (long)dst.position(), dst.remaining());
            dst.position(dst.position() + dst.remaining());
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory(addr, dst.array(), dst.arrayOffset() + dst.position(), (long)dst.remaining());
            dst.position(dst.position() + dst.remaining());
        } else {
            dst.put(buf.nioBuffer());
        }
    }

    static void setBytes(AbstractByteBuf buf, long addr, int index2, ByteBuf src, int srcIndex, int length) {
        buf.checkIndex(index2, length);
        ObjectUtil.checkNotNull(src, "src");
        if (MathUtil.isOutOfBounds(srcIndex, length, src.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + srcIndex);
        }
        if (length != 0) {
            if (src.hasMemoryAddress()) {
                PlatformDependent.copyMemory(src.memoryAddress() + (long)srcIndex, addr, length);
            } else if (src.hasArray()) {
                PlatformDependent.copyMemory(src.array(), src.arrayOffset() + srcIndex, addr, (long)length);
            } else {
                src.getBytes(srcIndex, buf, index2, length);
            }
        }
    }

    static void setBytes(AbstractByteBuf buf, long addr, int index2, byte[] src, int srcIndex, int length) {
        buf.checkIndex(index2, length);
        ObjectUtil.checkNotNull(src, "src");
        if (MathUtil.isOutOfBounds(srcIndex, length, src.length)) {
            throw new IndexOutOfBoundsException("srcIndex: " + srcIndex);
        }
        if (length != 0) {
            PlatformDependent.copyMemory(src, srcIndex, addr, (long)length);
        }
    }

    static void setBytes(AbstractByteBuf buf, long addr, int index2, ByteBuffer src) {
        int length = src.remaining();
        if (length == 0) {
            return;
        }
        if (src.isDirect()) {
            buf.checkIndex(index2, length);
            long srcAddress = PlatformDependent.directBufferAddress(src);
            PlatformDependent.copyMemory(srcAddress + (long)src.position(), addr, length);
            src.position(src.position() + length);
        } else if (src.hasArray()) {
            buf.checkIndex(index2, length);
            PlatformDependent.copyMemory(src.array(), src.arrayOffset() + src.position(), addr, (long)length);
            src.position(src.position() + length);
        } else if (length < 8) {
            UnsafeByteBufUtil.setSingleBytes(buf, addr, index2, src, length);
        } else {
            assert (buf.nioBufferCount() == 1);
            ByteBuffer internalBuffer = buf.internalNioBuffer(index2, length);
            internalBuffer.put(src);
        }
    }

    private static void setSingleBytes(AbstractByteBuf buf, long addr, int index2, ByteBuffer src, int length) {
        buf.checkIndex(index2, length);
        int srcPosition = src.position();
        int srcLimit = src.limit();
        long dstAddr = addr;
        for (int srcIndex = srcPosition; srcIndex < srcLimit; ++srcIndex) {
            byte value = src.get(srcIndex);
            PlatformDependent.putByte(dstAddr, value);
            ++dstAddr;
        }
        src.position(srcLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getBytes(AbstractByteBuf buf, long addr, int index2, OutputStream out, int length) throws IOException {
        buf.checkIndex(index2, length);
        if (length != 0) {
            int len = Math.min(length, 8192);
            if (len <= 1024 || !buf.alloc().isDirectBufferPooled()) {
                UnsafeByteBufUtil.getBytes(addr, ByteBufUtil.threadLocalTempArray(len), 0, len, out, length);
            } else {
                ByteBuf tmpBuf = buf.alloc().heapBuffer(len);
                try {
                    byte[] tmp = tmpBuf.array();
                    int offset = tmpBuf.arrayOffset();
                    UnsafeByteBufUtil.getBytes(addr, tmp, offset, len, out, length);
                }
                finally {
                    tmpBuf.release();
                }
            }
        }
    }

    private static void getBytes(long inAddr, byte[] in, int inOffset, int inLen, OutputStream out, int outLen) throws IOException {
        int len;
        do {
            len = Math.min(inLen, outLen);
            PlatformDependent.copyMemory(inAddr, in, inOffset, (long)len);
            out.write(in, inOffset, len);
            inAddr += (long)len;
        } while ((outLen -= len) > 0);
    }

    private static void batchSetZero(long addr, int length) {
        int longBatches = length >>> 3;
        for (int i2 = 0; i2 < longBatches; ++i2) {
            PlatformDependent.putLong(addr, 0L);
            addr += 8L;
        }
        int remaining = length & 7;
        for (int i3 = 0; i3 < remaining; ++i3) {
            PlatformDependent.putByte(addr + (long)i3, (byte)0);
        }
    }

    static void setZero(long addr, int length) {
        if (length == 0) {
            return;
        }
        if (length <= 64) {
            if (!UNALIGNED) {
                int bytesToGetAligned = UnsafeByteBufUtil.zeroTillAligned(addr, length);
                addr += (long)bytesToGetAligned;
                if ((length -= bytesToGetAligned) == 0) {
                    return;
                }
                assert (addr % 8L == 0L);
            }
            UnsafeByteBufUtil.batchSetZero(addr, length);
        } else {
            PlatformDependent.setMemory(addr, length, (byte)0);
        }
    }

    private static int zeroTillAligned(long addr, int length) {
        int bytesToGetAligned = Math.min((int)(addr % 8L), length);
        for (int i2 = 0; i2 < bytesToGetAligned; ++i2) {
            PlatformDependent.putByte(addr + (long)i2, (byte)0);
        }
        return bytesToGetAligned;
    }

    static UnpooledUnsafeDirectByteBuf newUnsafeDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            return new UnpooledUnsafeNoCleanerDirectByteBuf(alloc, initialCapacity, maxCapacity);
        }
        return new UnpooledUnsafeDirectByteBuf(alloc, initialCapacity, maxCapacity);
    }

    private UnsafeByteBufUtil() {
    }
}

