/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account.validateqrbadge;

import androidx.compose.runtime.internal.StabilityInferred;
import io.ktor.http.URLUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.shared.domain.account.validateqrbadge.QrValidationResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0010"}, d2={"Lworld/respect/shared/domain/account/validateqrbadge/ValidateQrCodeUseCase;", "", "<init>", "()V", "invoke", "Lworld/respect/shared/domain/account/validateqrbadge/QrValidationResult;", "qrCodeUrl", "", "schoolUrl", "personGuid", "allowReplacement", "", "validateUrlFormat", "validateSchoolUrl", "validateQrBadgeSection", "validateFormatOnly", "respect-lib-shared"})
@StabilityInferred(parameters=1)
public final class ValidateQrCodeUseCase {
    public static final int $stable;

    @NotNull
    public final QrValidationResult invoke(@NotNull String qrCodeUrl, @Nullable String schoolUrl, @Nullable String personGuid, boolean allowReplacement) {
        Intrinsics.checkNotNullParameter(qrCodeUrl, "qrCodeUrl");
        QrValidationResult formatValidation = this.validateUrlFormat(qrCodeUrl);
        if (!formatValidation.isValid()) {
            return formatValidation;
        }
        QrValidationResult schoolUrlValidation = this.validateSchoolUrl(qrCodeUrl, schoolUrl);
        if (!schoolUrlValidation.isValid()) {
            return schoolUrlValidation;
        }
        QrValidationResult badgeValidation = this.validateQrBadgeSection(qrCodeUrl);
        if (!badgeValidation.isValid()) {
            return badgeValidation;
        }
        return QrValidationResult.Companion.getValid();
    }

    public static /* synthetic */ QrValidationResult invoke$default(ValidateQrCodeUseCase validateQrCodeUseCase, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string4 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return validateQrCodeUseCase.invoke(string2, string3, string4, bl);
    }

    private final QrValidationResult validateUrlFormat(String qrCodeUrl) {
        QrValidationResult qrValidationResult;
        try {
            URLUtilsKt.Url(qrCodeUrl);
            qrValidationResult = QrValidationResult.Companion.getValid();
        }
        catch (Exception e) {
            qrValidationResult = QrValidationResult.Companion.getInvalidFormat();
        }
        return qrValidationResult;
    }

    private final QrValidationResult validateSchoolUrl(String qrCodeUrl, String schoolUrl) {
        return schoolUrl != null && !StringsKt.startsWith$default(qrCodeUrl, schoolUrl, false, 2, null) ? QrValidationResult.Companion.getInvalidSchoolUrl() : QrValidationResult.Companion.getValid();
    }

    private final QrValidationResult validateQrBadgeSection(String qrCodeUrl) {
        return !StringsKt.contains((CharSequence)qrCodeUrl, "/respect_qr_badge", true) ? QrValidationResult.Companion.getMissingBadgeSection() : QrValidationResult.Companion.getValid();
    }

    @NotNull
    public final QrValidationResult validateFormatOnly(@NotNull String qrCodeUrl, @Nullable String schoolUrl) {
        Intrinsics.checkNotNullParameter(qrCodeUrl, "qrCodeUrl");
        QrValidationResult formatCheck = this.validateUrlFormat(qrCodeUrl);
        if (!formatCheck.isValid()) {
            return formatCheck;
        }
        QrValidationResult schoolCheck = this.validateSchoolUrl(qrCodeUrl, schoolUrl);
        if (!schoolCheck.isValid()) {
            return schoolCheck;
        }
        return this.validateQrBadgeSection(qrCodeUrl);
    }
}

