/*
 * Decompiled with CFR 0.152.
 */
package com.eygraber.uri.parts;

import com.eygraber.uri.NotCachedHolder;
import com.eygraber.uri.PathSegments;
import com.eygraber.uri.PathSegmentsBuilder;
import com.eygraber.uri.UriCodec;
import com.eygraber.uri.parts.AbstractPart;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0014R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/eygraber/uri/parts/PathPart;", "Lcom/eygraber/uri/parts/AbstractPart;", "encoded", "", "decoded", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "encode", "pathSegments", "Lcom/eygraber/uri/PathSegments;", "getPathSegments", "()Lcom/eygraber/uri/PathSegments;", "pathSegments$delegate", "Lkotlin/Lazy;", "Companion", "uri"})
@SourceDebugExtension(value={"SMAP\nPathPart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathPart.kt\ncom/eygraber/uri/parts/PathPart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class PathPart
extends AbstractPart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy pathSegments$delegate = LazyKt.lazy(() -> PathPart.pathSegments_delegate$lambda$1(encoded));
    @NotNull
    private static final PathPart NULL = new PathPart(null, null);
    @NotNull
    private static final PathPart EMPTY = new PathPart("", "");

    public PathPart(@Nullable String encoded, @Nullable String decoded) {
        super(encoded, decoded);
    }

    @Override
    @Nullable
    protected String encode(@Nullable String decoded) {
        return UriCodec.INSTANCE.encodeOrNull(decoded, "/");
    }

    @NotNull
    public final PathSegments getPathSegments() {
        Lazy lazy = this.pathSegments$delegate;
        return (PathSegments)lazy.getValue();
    }

    private static final PathSegments pathSegments_delegate$lambda$1(String $encoded) {
        String string2 = $encoded;
        if (string2 == null) {
            return PathSegments.Companion.getEMPTY();
        }
        String path = string2;
        PathSegmentsBuilder segmentBuilder = new PathSegmentsBuilder();
        int previous2 = 0;
        int current = 0;
        while (true) {
            int n;
            int it = n = StringsKt.indexOf$default((CharSequence)path, '/', previous2, false, 4, null);
            boolean bl = false;
            current = it;
            if (n <= -1) break;
            if (previous2 < current) {
                String string3 = path.substring(previous2, current);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                segmentBuilder.add(UriCodec.decode$default(UriCodec.INSTANCE, string3, false, false, 6, null));
            }
            previous2 = current + 1;
        }
        if (previous2 < path.length()) {
            String string4 = path.substring(previous2);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            segmentBuilder.add(UriCodec.decode$default(UriCodec.INSTANCE, string4, false, false, 6, null));
        }
        return segmentBuilder.build();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0012\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u0013\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/eygraber/uri/parts/PathPart$Companion;", "", "<init>", "()V", "NULL", "Lcom/eygraber/uri/parts/PathPart;", "getNULL", "()Lcom/eygraber/uri/parts/PathPart;", "EMPTY", "getEMPTY", "appendEncodedSegment", "oldPart", "newSegment", "", "appendDecodedSegment", "decoded", "fromEncoded", "encoded", "fromDecoded", "from", "makeAbsolute", "uri"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PathPart getNULL() {
            return NULL;
        }

        @NotNull
        public final PathPart getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final PathPart appendEncodedSegment(@Nullable PathPart oldPart, @NotNull String newSegment) {
            Intrinsics.checkNotNullParameter(newSegment, "newSegment");
            if (oldPart == null) {
                return this.fromEncoded("/" + newSegment);
            }
            String oldPath = oldPart.getEncoded();
            if (oldPath == null) {
                oldPath = "";
            }
            int oldPathLength = oldPath.length();
            String newPath = oldPathLength == 0 ? "/" + newSegment : (oldPath.charAt(oldPathLength - 1) == '/' ? oldPath + newSegment : oldPath + "/" + newSegment);
            return this.fromEncoded(newPath);
        }

        @NotNull
        public final PathPart appendDecodedSegment(@Nullable PathPart oldPart, @NotNull String decoded) {
            Intrinsics.checkNotNullParameter(decoded, "decoded");
            String encoded = UriCodec.INSTANCE.encode(decoded);
            return this.appendEncodedSegment(oldPart, encoded);
        }

        @NotNull
        public final PathPart fromEncoded(@Nullable String encoded) {
            return this.from(encoded, NotCachedHolder.INSTANCE.getNotCached());
        }

        @NotNull
        public final PathPart fromDecoded(@Nullable String decoded) {
            return this.from(NotCachedHolder.INSTANCE.getNotCached(), decoded);
        }

        @NotNull
        public final PathPart from(@Nullable String encoded, @Nullable String decoded) {
            if (encoded == null) {
                return this.getNULL();
            }
            return ((CharSequence)encoded).length() == 0 ? this.getEMPTY() : new PathPart(encoded, decoded);
        }

        @NotNull
        public final PathPart makeAbsolute(@NotNull PathPart oldPart) {
            Intrinsics.checkNotNullParameter(oldPart, "oldPart");
            String oldPath = oldPart.getWasEncodedCached$uri() ? oldPart.getEncoded() : oldPart.getDecoded();
            CharSequence charSequence = oldPath;
            if (charSequence == null || charSequence.length() == 0 || StringsKt.startsWith$default(oldPath, "/", false, 2, null)) {
                return oldPart;
            }
            Object newEncoded = oldPart.getWasEncodedCached$uri() ? "/" + oldPart.getEncoded() : NotCachedHolder.INSTANCE.getNotCached();
            Object newDecoded = oldPart.getWasDecodedCached$uri() ? "/" + oldPart.getDecoded() : NotCachedHolder.INSTANCE.getNotCached();
            return new PathPart((String)newEncoded, (String)newDecoded);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

