package world.respect.datalayer.db.opds.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import world.respect.datalayer.db.opds.entities.OpdsGroupEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class OpdsGroupEntityDao_Impl(
  __db: RoomDatabase,
) : OpdsGroupEntityDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfOpdsGroupEntity: EntityInsertAdapter<OpdsGroupEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfOpdsGroupEntity = object : EntityInsertAdapter<OpdsGroupEntity>() {
      protected override fun createQuery(): String = "INSERT OR ABORT INTO `OpdsGroupEntity` (`ogeUid`,`ogeOfeUid`,`ogeIndex`) VALUES (nullif(?, 0),?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: OpdsGroupEntity) {
        statement.bindLong(1, entity.ogeUid)
        statement.bindLong(2, entity.ogeOfeUid)
        statement.bindLong(3, entity.ogeIndex.toLong())
      }
    }
  }

  public override suspend fun insertList(entities: List<OpdsGroupEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfOpdsGroupEntity.insert(_connection, entities)
  }

  public override suspend fun findByFeedUid(feedUid: Long): List<OpdsGroupEntity> {
    val _sql: String = """
        |
        |        SELECT OpdsGroupEntity.*
        |          FROM OpdsGroupEntity
        |         WHERE OpdsGroupEntity.ogeOfeUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        val _columnIndexOfOgeUid: Int = getColumnIndexOrThrow(_stmt, "ogeUid")
        val _columnIndexOfOgeOfeUid: Int = getColumnIndexOrThrow(_stmt, "ogeOfeUid")
        val _columnIndexOfOgeIndex: Int = getColumnIndexOrThrow(_stmt, "ogeIndex")
        val _result: MutableList<OpdsGroupEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: OpdsGroupEntity
          val _tmpOgeUid: Long
          _tmpOgeUid = _stmt.getLong(_columnIndexOfOgeUid)
          val _tmpOgeOfeUid: Long
          _tmpOgeOfeUid = _stmt.getLong(_columnIndexOfOgeOfeUid)
          val _tmpOgeIndex: Int
          _tmpOgeIndex = _stmt.getLong(_columnIndexOfOgeIndex).toInt()
          _item = OpdsGroupEntity(_tmpOgeUid,_tmpOgeOfeUid,_tmpOgeIndex)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteByFeedUid(feedUid: Long) {
    val _sql: String = """
        |
        |        DELETE FROM OpdsGroupEntity 
        |         WHERE OpdsGroupEntity.ogeOfeUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
