package world.respect.datalayer.db.compatibleapps.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import com.eygraber.uri.Uri
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.compatibleapps.entities.CompatibleAppEntity
import world.respect.datalayer.db.shared.LastModifiedAndETagDb
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class CompatibleAppEntityDao_Impl(
  __db: RoomDatabase,
) : CompatibleAppEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfCompatibleAppEntity: EntityInsertAdapter<CompatibleAppEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfCompatibleAppEntity = object : EntityInsertAdapter<CompatibleAppEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `CompatibleAppEntity` (`caeUid`,`caeUrl`,`caeIcon`,`caeLastModified`,`caeEtag`,`caeLicense`,`caeWebsite`,`caeLearningUnits`,`caeDefaultLaunchUri`,`caeAndroidPackageId`,`caeAndroidStoreList`,`caeAndroidSourceCode`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: CompatibleAppEntity) {
        statement.bindLong(1, entity.caeUid)
        val _tmp: String? = __sharedConverters.fromUrl(entity.caeUrl)
        if (_tmp == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp)
        }
        val _tmpCaeIcon: Uri? = entity.caeIcon
        val _tmp_1: String? = __sharedConverters.fromUri(_tmpCaeIcon)
        if (_tmp_1 == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmp_1)
        }
        statement.bindLong(4, entity.caeLastModified)
        val _tmpCaeEtag: String? = entity.caeEtag
        if (_tmpCaeEtag == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpCaeEtag)
        }
        statement.bindText(6, entity.caeLicense)
        statement.bindText(7, entity.caeWebsite)
        statement.bindText(8, entity.caeLearningUnits)
        statement.bindText(9, entity.caeDefaultLaunchUri)
        val _tmpCaeAndroidPackageId: String? = entity.caeAndroidPackageId
        if (_tmpCaeAndroidPackageId == null) {
          statement.bindNull(10)
        } else {
          statement.bindText(10, _tmpCaeAndroidPackageId)
        }
        val _tmpCaeAndroidStoreList: String? = entity.caeAndroidStoreList
        if (_tmpCaeAndroidStoreList == null) {
          statement.bindNull(11)
        } else {
          statement.bindText(11, _tmpCaeAndroidStoreList)
        }
        val _tmpCaeAndroidSourceCode: String? = entity.caeAndroidSourceCode
        if (_tmpCaeAndroidSourceCode == null) {
          statement.bindNull(12)
        } else {
          statement.bindText(12, _tmpCaeAndroidSourceCode)
        }
      }
    }
  }

  public override suspend fun upsert(compatibleApps: List<CompatibleAppEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfCompatibleAppEntity.insert(_connection, compatibleApps)
  }

  public override suspend fun getNetworkValidationInfo(caeUid: Long): LastModifiedAndETagDb? {
    val _sql: String = """
        |
        |        SELECT CompatibleAppEntity.caeLastModified AS lastModified,
        |               CompatibleAppEntity.caeEtag AS etag
        |          FROM CompatibleAppEntity
        |         WHERE caeUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, caeUid)
        val _columnIndexOfLastModified: Int = 0
        val _columnIndexOfEtag: Int = 1
        val _result: LastModifiedAndETagDb?
        if (_stmt.step()) {
          val _tmpLastModified: Long
          _tmpLastModified = _stmt.getLong(_columnIndexOfLastModified)
          val _tmpEtag: String?
          if (_stmt.isNull(_columnIndexOfEtag)) {
            _tmpEtag = null
          } else {
            _tmpEtag = _stmt.getText(_columnIndexOfEtag)
          }
          _result = LastModifiedAndETagDb(_tmpLastModified,_tmpEtag)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun selectByUid(caeUid: Long): CompatibleAppEntity? {
    val _sql: String = """
        |SELECT * 
        |                        FROM CompatibleAppEntity 
        |                       WHERE caeUid = ?
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, caeUid)
        val _columnIndexOfCaeUid: Int = getColumnIndexOrThrow(_stmt, "caeUid")
        val _columnIndexOfCaeUrl: Int = getColumnIndexOrThrow(_stmt, "caeUrl")
        val _columnIndexOfCaeIcon: Int = getColumnIndexOrThrow(_stmt, "caeIcon")
        val _columnIndexOfCaeLastModified: Int = getColumnIndexOrThrow(_stmt, "caeLastModified")
        val _columnIndexOfCaeEtag: Int = getColumnIndexOrThrow(_stmt, "caeEtag")
        val _columnIndexOfCaeLicense: Int = getColumnIndexOrThrow(_stmt, "caeLicense")
        val _columnIndexOfCaeWebsite: Int = getColumnIndexOrThrow(_stmt, "caeWebsite")
        val _columnIndexOfCaeLearningUnits: Int = getColumnIndexOrThrow(_stmt, "caeLearningUnits")
        val _columnIndexOfCaeDefaultLaunchUri: Int = getColumnIndexOrThrow(_stmt, "caeDefaultLaunchUri")
        val _columnIndexOfCaeAndroidPackageId: Int = getColumnIndexOrThrow(_stmt, "caeAndroidPackageId")
        val _columnIndexOfCaeAndroidStoreList: Int = getColumnIndexOrThrow(_stmt, "caeAndroidStoreList")
        val _columnIndexOfCaeAndroidSourceCode: Int = getColumnIndexOrThrow(_stmt, "caeAndroidSourceCode")
        val _result: CompatibleAppEntity?
        if (_stmt.step()) {
          val _tmpCaeUid: Long
          _tmpCaeUid = _stmt.getLong(_columnIndexOfCaeUid)
          val _tmpCaeUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfCaeUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfCaeUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpCaeUrl = _tmp_1
          }
          val _tmpCaeIcon: Uri?
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfCaeIcon)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfCaeIcon)
          }
          _tmpCaeIcon = __sharedConverters.toUri(_tmp_2)
          val _tmpCaeLastModified: Long
          _tmpCaeLastModified = _stmt.getLong(_columnIndexOfCaeLastModified)
          val _tmpCaeEtag: String?
          if (_stmt.isNull(_columnIndexOfCaeEtag)) {
            _tmpCaeEtag = null
          } else {
            _tmpCaeEtag = _stmt.getText(_columnIndexOfCaeEtag)
          }
          val _tmpCaeLicense: String
          _tmpCaeLicense = _stmt.getText(_columnIndexOfCaeLicense)
          val _tmpCaeWebsite: String
          _tmpCaeWebsite = _stmt.getText(_columnIndexOfCaeWebsite)
          val _tmpCaeLearningUnits: String
          _tmpCaeLearningUnits = _stmt.getText(_columnIndexOfCaeLearningUnits)
          val _tmpCaeDefaultLaunchUri: String
          _tmpCaeDefaultLaunchUri = _stmt.getText(_columnIndexOfCaeDefaultLaunchUri)
          val _tmpCaeAndroidPackageId: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidPackageId)) {
            _tmpCaeAndroidPackageId = null
          } else {
            _tmpCaeAndroidPackageId = _stmt.getText(_columnIndexOfCaeAndroidPackageId)
          }
          val _tmpCaeAndroidStoreList: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidStoreList)) {
            _tmpCaeAndroidStoreList = null
          } else {
            _tmpCaeAndroidStoreList = _stmt.getText(_columnIndexOfCaeAndroidStoreList)
          }
          val _tmpCaeAndroidSourceCode: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidSourceCode)) {
            _tmpCaeAndroidSourceCode = null
          } else {
            _tmpCaeAndroidSourceCode = _stmt.getText(_columnIndexOfCaeAndroidSourceCode)
          }
          _result = CompatibleAppEntity(_tmpCaeUid,_tmpCaeUrl,_tmpCaeIcon,_tmpCaeLastModified,_tmpCaeEtag,_tmpCaeLicense,_tmpCaeWebsite,_tmpCaeLearningUnits,_tmpCaeDefaultLaunchUri,_tmpCaeAndroidPackageId,_tmpCaeAndroidStoreList,_tmpCaeAndroidSourceCode)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun selectAllAsFlow(): Flow<List<CompatibleAppEntity>> {
    val _sql: String = "SELECT * FROM CompatibleAppEntity"
    return createFlow(__db, false, arrayOf("CompatibleAppEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfCaeUid: Int = getColumnIndexOrThrow(_stmt, "caeUid")
        val _columnIndexOfCaeUrl: Int = getColumnIndexOrThrow(_stmt, "caeUrl")
        val _columnIndexOfCaeIcon: Int = getColumnIndexOrThrow(_stmt, "caeIcon")
        val _columnIndexOfCaeLastModified: Int = getColumnIndexOrThrow(_stmt, "caeLastModified")
        val _columnIndexOfCaeEtag: Int = getColumnIndexOrThrow(_stmt, "caeEtag")
        val _columnIndexOfCaeLicense: Int = getColumnIndexOrThrow(_stmt, "caeLicense")
        val _columnIndexOfCaeWebsite: Int = getColumnIndexOrThrow(_stmt, "caeWebsite")
        val _columnIndexOfCaeLearningUnits: Int = getColumnIndexOrThrow(_stmt, "caeLearningUnits")
        val _columnIndexOfCaeDefaultLaunchUri: Int = getColumnIndexOrThrow(_stmt, "caeDefaultLaunchUri")
        val _columnIndexOfCaeAndroidPackageId: Int = getColumnIndexOrThrow(_stmt, "caeAndroidPackageId")
        val _columnIndexOfCaeAndroidStoreList: Int = getColumnIndexOrThrow(_stmt, "caeAndroidStoreList")
        val _columnIndexOfCaeAndroidSourceCode: Int = getColumnIndexOrThrow(_stmt, "caeAndroidSourceCode")
        val _result: MutableList<CompatibleAppEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: CompatibleAppEntity
          val _tmpCaeUid: Long
          _tmpCaeUid = _stmt.getLong(_columnIndexOfCaeUid)
          val _tmpCaeUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfCaeUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfCaeUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpCaeUrl = _tmp_1
          }
          val _tmpCaeIcon: Uri?
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfCaeIcon)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfCaeIcon)
          }
          _tmpCaeIcon = __sharedConverters.toUri(_tmp_2)
          val _tmpCaeLastModified: Long
          _tmpCaeLastModified = _stmt.getLong(_columnIndexOfCaeLastModified)
          val _tmpCaeEtag: String?
          if (_stmt.isNull(_columnIndexOfCaeEtag)) {
            _tmpCaeEtag = null
          } else {
            _tmpCaeEtag = _stmt.getText(_columnIndexOfCaeEtag)
          }
          val _tmpCaeLicense: String
          _tmpCaeLicense = _stmt.getText(_columnIndexOfCaeLicense)
          val _tmpCaeWebsite: String
          _tmpCaeWebsite = _stmt.getText(_columnIndexOfCaeWebsite)
          val _tmpCaeLearningUnits: String
          _tmpCaeLearningUnits = _stmt.getText(_columnIndexOfCaeLearningUnits)
          val _tmpCaeDefaultLaunchUri: String
          _tmpCaeDefaultLaunchUri = _stmt.getText(_columnIndexOfCaeDefaultLaunchUri)
          val _tmpCaeAndroidPackageId: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidPackageId)) {
            _tmpCaeAndroidPackageId = null
          } else {
            _tmpCaeAndroidPackageId = _stmt.getText(_columnIndexOfCaeAndroidPackageId)
          }
          val _tmpCaeAndroidStoreList: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidStoreList)) {
            _tmpCaeAndroidStoreList = null
          } else {
            _tmpCaeAndroidStoreList = _stmt.getText(_columnIndexOfCaeAndroidStoreList)
          }
          val _tmpCaeAndroidSourceCode: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidSourceCode)) {
            _tmpCaeAndroidSourceCode = null
          } else {
            _tmpCaeAndroidSourceCode = _stmt.getText(_columnIndexOfCaeAndroidSourceCode)
          }
          _item = CompatibleAppEntity(_tmpCaeUid,_tmpCaeUrl,_tmpCaeIcon,_tmpCaeLastModified,_tmpCaeEtag,_tmpCaeLicense,_tmpCaeWebsite,_tmpCaeLearningUnits,_tmpCaeDefaultLaunchUri,_tmpCaeAndroidPackageId,_tmpCaeAndroidStoreList,_tmpCaeAndroidSourceCode)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun selectAddedAppsAsFlow(): Flow<List<CompatibleAppEntity>> {
    val _sql: String = """
        |
        |        SELECT *
        |          FROM CompatibleAppEntity
        |               JOIN CompatibleAppAddJoin
        |                    ON CompatibleAppEntity.caeUid = CompatibleAppAddJoin.appCaeUid
        |         WHERE CompatibleAppAddJoin.added = 1
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("CompatibleAppEntity", "CompatibleAppAddJoin")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfCaeUid: Int = getColumnIndexOrThrow(_stmt, "caeUid")
        val _columnIndexOfCaeUrl: Int = getColumnIndexOrThrow(_stmt, "caeUrl")
        val _columnIndexOfCaeIcon: Int = getColumnIndexOrThrow(_stmt, "caeIcon")
        val _columnIndexOfCaeLastModified: Int = getColumnIndexOrThrow(_stmt, "caeLastModified")
        val _columnIndexOfCaeEtag: Int = getColumnIndexOrThrow(_stmt, "caeEtag")
        val _columnIndexOfCaeLicense: Int = getColumnIndexOrThrow(_stmt, "caeLicense")
        val _columnIndexOfCaeWebsite: Int = getColumnIndexOrThrow(_stmt, "caeWebsite")
        val _columnIndexOfCaeLearningUnits: Int = getColumnIndexOrThrow(_stmt, "caeLearningUnits")
        val _columnIndexOfCaeDefaultLaunchUri: Int = getColumnIndexOrThrow(_stmt, "caeDefaultLaunchUri")
        val _columnIndexOfCaeAndroidPackageId: Int = getColumnIndexOrThrow(_stmt, "caeAndroidPackageId")
        val _columnIndexOfCaeAndroidStoreList: Int = getColumnIndexOrThrow(_stmt, "caeAndroidStoreList")
        val _columnIndexOfCaeAndroidSourceCode: Int = getColumnIndexOrThrow(_stmt, "caeAndroidSourceCode")
        val _result: MutableList<CompatibleAppEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: CompatibleAppEntity
          val _tmpCaeUid: Long
          _tmpCaeUid = _stmt.getLong(_columnIndexOfCaeUid)
          val _tmpCaeUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfCaeUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfCaeUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpCaeUrl = _tmp_1
          }
          val _tmpCaeIcon: Uri?
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfCaeIcon)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfCaeIcon)
          }
          _tmpCaeIcon = __sharedConverters.toUri(_tmp_2)
          val _tmpCaeLastModified: Long
          _tmpCaeLastModified = _stmt.getLong(_columnIndexOfCaeLastModified)
          val _tmpCaeEtag: String?
          if (_stmt.isNull(_columnIndexOfCaeEtag)) {
            _tmpCaeEtag = null
          } else {
            _tmpCaeEtag = _stmt.getText(_columnIndexOfCaeEtag)
          }
          val _tmpCaeLicense: String
          _tmpCaeLicense = _stmt.getText(_columnIndexOfCaeLicense)
          val _tmpCaeWebsite: String
          _tmpCaeWebsite = _stmt.getText(_columnIndexOfCaeWebsite)
          val _tmpCaeLearningUnits: String
          _tmpCaeLearningUnits = _stmt.getText(_columnIndexOfCaeLearningUnits)
          val _tmpCaeDefaultLaunchUri: String
          _tmpCaeDefaultLaunchUri = _stmt.getText(_columnIndexOfCaeDefaultLaunchUri)
          val _tmpCaeAndroidPackageId: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidPackageId)) {
            _tmpCaeAndroidPackageId = null
          } else {
            _tmpCaeAndroidPackageId = _stmt.getText(_columnIndexOfCaeAndroidPackageId)
          }
          val _tmpCaeAndroidStoreList: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidStoreList)) {
            _tmpCaeAndroidStoreList = null
          } else {
            _tmpCaeAndroidStoreList = _stmt.getText(_columnIndexOfCaeAndroidStoreList)
          }
          val _tmpCaeAndroidSourceCode: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidSourceCode)) {
            _tmpCaeAndroidSourceCode = null
          } else {
            _tmpCaeAndroidSourceCode = _stmt.getText(_columnIndexOfCaeAndroidSourceCode)
          }
          _item = CompatibleAppEntity(_tmpCaeUid,_tmpCaeUrl,_tmpCaeIcon,_tmpCaeLastModified,_tmpCaeEtag,_tmpCaeLicense,_tmpCaeWebsite,_tmpCaeLearningUnits,_tmpCaeDefaultLaunchUri,_tmpCaeAndroidPackageId,_tmpCaeAndroidStoreList,_tmpCaeAndroidSourceCode)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun selectByUidAsFlow(caeUid: Long): Flow<CompatibleAppEntity?> {
    val _sql: String = """
        |SELECT * 
        |                        FROM CompatibleAppEntity 
        |                       WHERE caeUid = ?
        """.trimMargin()
    return createFlow(__db, false, arrayOf("CompatibleAppEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, caeUid)
        val _columnIndexOfCaeUid: Int = getColumnIndexOrThrow(_stmt, "caeUid")
        val _columnIndexOfCaeUrl: Int = getColumnIndexOrThrow(_stmt, "caeUrl")
        val _columnIndexOfCaeIcon: Int = getColumnIndexOrThrow(_stmt, "caeIcon")
        val _columnIndexOfCaeLastModified: Int = getColumnIndexOrThrow(_stmt, "caeLastModified")
        val _columnIndexOfCaeEtag: Int = getColumnIndexOrThrow(_stmt, "caeEtag")
        val _columnIndexOfCaeLicense: Int = getColumnIndexOrThrow(_stmt, "caeLicense")
        val _columnIndexOfCaeWebsite: Int = getColumnIndexOrThrow(_stmt, "caeWebsite")
        val _columnIndexOfCaeLearningUnits: Int = getColumnIndexOrThrow(_stmt, "caeLearningUnits")
        val _columnIndexOfCaeDefaultLaunchUri: Int = getColumnIndexOrThrow(_stmt, "caeDefaultLaunchUri")
        val _columnIndexOfCaeAndroidPackageId: Int = getColumnIndexOrThrow(_stmt, "caeAndroidPackageId")
        val _columnIndexOfCaeAndroidStoreList: Int = getColumnIndexOrThrow(_stmt, "caeAndroidStoreList")
        val _columnIndexOfCaeAndroidSourceCode: Int = getColumnIndexOrThrow(_stmt, "caeAndroidSourceCode")
        val _result: CompatibleAppEntity?
        if (_stmt.step()) {
          val _tmpCaeUid: Long
          _tmpCaeUid = _stmt.getLong(_columnIndexOfCaeUid)
          val _tmpCaeUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfCaeUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfCaeUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpCaeUrl = _tmp_1
          }
          val _tmpCaeIcon: Uri?
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfCaeIcon)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfCaeIcon)
          }
          _tmpCaeIcon = __sharedConverters.toUri(_tmp_2)
          val _tmpCaeLastModified: Long
          _tmpCaeLastModified = _stmt.getLong(_columnIndexOfCaeLastModified)
          val _tmpCaeEtag: String?
          if (_stmt.isNull(_columnIndexOfCaeEtag)) {
            _tmpCaeEtag = null
          } else {
            _tmpCaeEtag = _stmt.getText(_columnIndexOfCaeEtag)
          }
          val _tmpCaeLicense: String
          _tmpCaeLicense = _stmt.getText(_columnIndexOfCaeLicense)
          val _tmpCaeWebsite: String
          _tmpCaeWebsite = _stmt.getText(_columnIndexOfCaeWebsite)
          val _tmpCaeLearningUnits: String
          _tmpCaeLearningUnits = _stmt.getText(_columnIndexOfCaeLearningUnits)
          val _tmpCaeDefaultLaunchUri: String
          _tmpCaeDefaultLaunchUri = _stmt.getText(_columnIndexOfCaeDefaultLaunchUri)
          val _tmpCaeAndroidPackageId: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidPackageId)) {
            _tmpCaeAndroidPackageId = null
          } else {
            _tmpCaeAndroidPackageId = _stmt.getText(_columnIndexOfCaeAndroidPackageId)
          }
          val _tmpCaeAndroidStoreList: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidStoreList)) {
            _tmpCaeAndroidStoreList = null
          } else {
            _tmpCaeAndroidStoreList = _stmt.getText(_columnIndexOfCaeAndroidStoreList)
          }
          val _tmpCaeAndroidSourceCode: String?
          if (_stmt.isNull(_columnIndexOfCaeAndroidSourceCode)) {
            _tmpCaeAndroidSourceCode = null
          } else {
            _tmpCaeAndroidSourceCode = _stmt.getText(_columnIndexOfCaeAndroidSourceCode)
          }
          _result = CompatibleAppEntity(_tmpCaeUid,_tmpCaeUrl,_tmpCaeIcon,_tmpCaeLastModified,_tmpCaeEtag,_tmpCaeLicense,_tmpCaeWebsite,_tmpCaeLearningUnits,_tmpCaeDefaultLaunchUri,_tmpCaeAndroidPackageId,_tmpCaeAndroidStoreList,_tmpCaeAndroidSourceCode)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
