/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.io;

import com.ustadmobile.libcache.CompressionType;
import com.ustadmobile.libcache.io.InputStreamExtKt;
import com.ustadmobile.libcache.io.OutputStreamExtKt;
import com.ustadmobile.libcache.io.RangeInputStream;
import com.ustadmobile.libcache.io.TransferResult;
import com.ustadmobile.libcache.io.UnzippedEntry;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.SinksJvmKt;
import kotlinx.io.Source;
import kotlinx.io.SourcesJvmKt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a)\u0010\u0007\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0011\u0010\n\u001a\u00020\t*\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u00002\u0006\u0010\f\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0019\u0010\u0012\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a!\u0010\u0018\u001a\u00020\u0017*\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lkotlinx/io/Source;", "Lkotlinx/io/files/Path;", "path", "Lcom/ustadmobile/libcache/CompressionType;", "sourceCompression", "destCompressionType", "Lcom/ustadmobile/libcache/io/TransferResult;", "transferToAndGetSha256", "(Lkotlinx/io/Source;Lkotlinx/io/files/Path;Lcom/ustadmobile/libcache/CompressionType;Lcom/ustadmobile/libcache/CompressionType;)Lcom/ustadmobile/libcache/io/TransferResult;", "", "useAndReadSha256", "(Lkotlinx/io/Source;)[B", "destPath", "", "Lcom/ustadmobile/libcache/io/UnzippedEntry;", "unzipTo", "(Lkotlinx/io/Source;Lkotlinx/io/files/Path;)Ljava/util/List;", "compressionType", "uncompress", "(Lkotlinx/io/Source;Lcom/ustadmobile/libcache/CompressionType;)Lkotlinx/io/Source;", "", "fromByte", "toByte", "Lkotlinx/io/RawSource;", "range", "(Lkotlinx/io/Source;JJ)Lkotlinx/io/RawSource;", "respect-lib-cache"})
@SourceDebugExtension(value={"SMAP\nSourceExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceExt.kt\ncom/ustadmobile/libcache/io/SourceExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class SourceExtKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final TransferResult transferToAndGetSha256(@NotNull Source $this$transferToAndGetSha256, @NotNull Path path, @NotNull CompressionType sourceCompression, @NotNull CompressionType destCompressionType) {
        long l;
        Intrinsics.checkNotNullParameter($this$transferToAndGetSha256, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter((Object)sourceCompression, "sourceCompression");
        Intrinsics.checkNotNullParameter((Object)destCompressionType, "destCompressionType");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Closeable closeable = OutputStreamExtKt.compressIfRequired(SinksJvmKt.asOutputStream(CoreKt.buffered(FileSystem.sink$default(FileSystemJvmKt.SystemFileSystem, path, false, 2, null))), destCompressionType);
        Throwable throwable = null;
        try {
            long l2;
            OutputStream outStream = (OutputStream)closeable;
            boolean bl = false;
            long it = l2 = ByteStreamsKt.copyTo$default(InputStreamExtKt.uncompress(new DigestInputStream(SourcesJvmKt.asInputStream($this$transferToAndGetSha256), messageDigest), sourceCompression), outStream, 0, 2, null);
            boolean bl2 = false;
            outStream.flush();
            l = l2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        long bytesTransferred = l;
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
        return new TransferResult(byArray, bytesTransferred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] useAndReadSha256(@NotNull Source $this$useAndReadSha256) {
        Intrinsics.checkNotNullParameter($this$useAndReadSha256, "<this>");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Closeable closeable = SourcesJvmKt.asInputStream($this$useAndReadSha256);
        Throwable throwable = null;
        try {
            InputStream inStream = (InputStream)closeable;
            boolean bl = false;
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while (true) {
                int n;
                int it = n = inStream.read(buffer);
                boolean bl2 = false;
                bytesRead = it;
                if (n == -1) break;
                messageDigest.update(buffer, 0, bytesRead);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<UnzippedEntry> unzipTo(@NotNull Source $this$unzipTo, @NotNull Path destPath) {
        Intrinsics.checkNotNullParameter($this$unzipTo, "<this>");
        Intrinsics.checkNotNullParameter(destPath, "destPath");
        List unzippedEntries = new ArrayList();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Closeable closeable = new ZipInputStream(SourcesJvmKt.asInputStream($this$unzipTo));
        Throwable throwable = null;
        try {
            ZipInputStream zipInput = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry zipEntry = null;
            while (true) {
                Serializable serializable;
                ZipEntry zipEntry2;
                Closeable closeable2;
                if (zipInput.getNextEntry() != null) {
                    ZipEntry it = closeable2;
                    boolean bl2 = false;
                    zipEntry = it;
                    zipEntry2 = closeable2;
                } else {
                    zipEntry2 = null;
                }
                if (zipEntry2 == null) break;
                ZipEntry zipEntry3 = zipEntry;
                if (zipEntry3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("zipEntry");
                    zipEntry3 = null;
                }
                if (zipEntry3.isDirectory()) continue;
                File destFile = new File(destPath.toString(), zipEntry.getName());
                File it = serializable = destFile.getParentFile();
                boolean bl3 = false;
                File file2 = !it.exists() ? serializable : null;
                if (file2 != null) {
                    file2.mkdirs();
                }
                closeable2 = new DigestOutputStream(new FileOutputStream(destFile), messageDigest);
                serializable = null;
                try {
                    DigestOutputStream outStream = (DigestOutputStream)closeable2;
                    boolean bl4 = false;
                    ByteStreamsKt.copyTo$default(zipInput, outStream, 0, 2, null);
                    outStream.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    serializable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, (Throwable)serializable);
                }
                String string2 = destFile.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                Path path = PathsJvmKt.Path(string2);
                String string3 = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                byte[] byArray = messageDigest.digest();
                Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
                unzippedEntries.add(new UnzippedEntry(path, string3, byArray));
                messageDigest.reset();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return unzippedEntries;
    }

    @NotNull
    public static final Source uncompress(@NotNull Source $this$uncompress, @NotNull CompressionType compressionType) {
        Intrinsics.checkNotNullParameter($this$uncompress, "<this>");
        Intrinsics.checkNotNullParameter((Object)compressionType, "compressionType");
        return compressionType != CompressionType.NONE ? CoreKt.buffered(JvmCoreKt.asSource(InputStreamExtKt.uncompress(SourcesJvmKt.asInputStream($this$uncompress), compressionType))) : $this$uncompress;
    }

    @NotNull
    public static final RawSource range(@NotNull Source $this$range, long fromByte, long toByte) {
        Intrinsics.checkNotNullParameter($this$range, "<this>");
        return JvmCoreKt.asSource(new RangeInputStream(SourcesJvmKt.asInputStream($this$range), fromByte, toByte));
    }
}

