/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.util;

import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\u001a\u001d\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000*\b\u0012\u0004\u0012\u00020\u00010\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a'\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000*\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a!\u0010\u000b\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0013\u0010\u000e\u001a\u00020\r*\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001c\u0010\u0016\u001a\u00020\r*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0082\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\"\u0014\u0010\u0018\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\"\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\"\u0014\u0010\u001d\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0019\u00a8\u0006\u001e"}, d2={"", "", "normalizePathComponents", "(Ljava/util/List;)Ljava/util/List;", "", "startIndex", "filterComponentsImpl", "(Ljava/util/List;I)Ljava/util/List;", "", "component", "", "processAndReplaceComponent", "(Ljava/util/List;Ljava/lang/String;)V", "", "shouldBeReplaced", "(Ljava/lang/String;)Z", "", "", "toASCIITable", "([C)[Z", "", "char", "contains", "([ZC)Z", "FirstReservedLetters", "[Z", "", "ReservedWords", "Ljava/util/Set;", "ReservedCharacters", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Paths.kt\nio/ktor/server/util/PathsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n434#2:113\n507#2,5:114\n1088#2,2:126\n140#3:119\n129#3,5:120\n1#4:125\n*S KotlinDebug\n*F\n+ 1 Paths.kt\nio/ktor/server/util/PathsKt\n*L\n59#1:113\n59#1:114,5\n104#1:126,2\n60#1:119\n60#1:120,5\n*E\n"})
public final class PathsKt {
    @NotNull
    private static final boolean[] FirstReservedLetters;
    @NotNull
    private static final Set<String> ReservedWords;
    @NotNull
    private static final boolean[] ReservedCharacters;

    @NotNull
    public static final List<String> normalizePathComponents(@NotNull List<String> $this$normalizePathComponents) {
        Intrinsics.checkNotNullParameter($this$normalizePathComponents, "<this>");
        int n = ((Collection)$this$normalizePathComponents).size();
        for (int index2 = 0; index2 < n; ++index2) {
            String component = $this$normalizePathComponents.get(index2);
            if (!PathsKt.shouldBeReplaced(component)) continue;
            return PathsKt.filterComponentsImpl($this$normalizePathComponents, index2);
        }
        return $this$normalizePathComponents;
    }

    private static final List<String> filterComponentsImpl(List<String> $this$filterComponentsImpl, int startIndex) {
        ArrayList<String> result2 = new ArrayList<String>($this$filterComponentsImpl.size());
        if (startIndex > 0) {
            result2.addAll((Collection)$this$filterComponentsImpl.subList(0, startIndex));
        }
        PathsKt.processAndReplaceComponent((List<String>)result2, $this$filterComponentsImpl.get(startIndex));
        int n = $this$filterComponentsImpl.size();
        for (int index2 = startIndex + 1; index2 < n; ++index2) {
            String component = $this$filterComponentsImpl.get(index2);
            if (PathsKt.shouldBeReplaced(component)) {
                PathsKt.processAndReplaceComponent((List<String>)result2, component);
                continue;
            }
            result2.add(component);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void processAndReplaceComponent(List<String> $this$processAndReplaceComponent, String component) {
        block7: {
            String string2;
            String string3;
            CharSequence charSequence;
            block6: {
                int index$iv$iv;
                void $this$filterTo$iv$iv;
                if (((CharSequence)component).length() == 0 || Intrinsics.areEqual(component, ".") || Intrinsics.areEqual(component, "~") || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules(component))) {
                    return;
                }
                if (Intrinsics.areEqual(component, "..")) {
                    if (!((Collection)$this$processAndReplaceComponent).isEmpty()) {
                        $this$processAndReplaceComponent.remove(CollectionsKt.getLastIndex($this$processAndReplaceComponent));
                    }
                    return;
                }
                String $this$filter$iv = component;
                boolean $i$f$filter = false;
                CharSequence charSequence2 = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n = $this$filterTo$iv$iv.length();
                for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char element$iv$iv;
                    char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (!(Intrinsics.compare(it, 32) >= 0 && !PathsKt.contains(ReservedCharacters, it))) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                String $this$trimEnd$iv = ((StringBuilder)destination$iv$iv).toString();
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                int n2 = $this$trimEnd$iv$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        index$iv$iv = n2--;
                        char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        if (it == ' ' || it == '.') continue;
                        charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                        break block6;
                    } while (0 <= n2);
                }
                charSequence = "";
            }
            String it = string3 = ((Object)charSequence).toString();
            boolean bl = false;
            String string4 = string2 = ((CharSequence)it).length() > 0 ? string3 : null;
            if (string2 == null) break block7;
            String filtered = string2;
            boolean bl2 = false;
            $this$processAndReplaceComponent.add(filtered);
        }
    }

    private static final boolean shouldBeReplaced(String $this$shouldBeReplaced) {
        boolean bl;
        block8: {
            int length = $this$shouldBeReplaced.length();
            if (length == 0) {
                return true;
            }
            char first2 = $this$shouldBeReplaced.charAt(0);
            if (first2 == '.' && (length == 1 || length == 2 && $this$shouldBeReplaced.charAt(1) == '.')) {
                return true;
            }
            if (first2 == '~' && length == 1) {
                return true;
            }
            if (PathsKt.contains(FirstReservedLetters, first2) && (ReservedWords.contains($this$shouldBeReplaced) || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules($this$shouldBeReplaced)))) {
                return true;
            }
            char last2 = $this$shouldBeReplaced.charAt(length - 1);
            switch (last2) {
                case ' ': 
                case '.': {
                    return true;
                }
            }
            boolean[] ReservedCharacters = PathsKt.ReservedCharacters;
            CharSequence $this$any$iv = $this$shouldBeReplaced;
            boolean $i$f$any = false;
            for (int j = 0; j < $this$any$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(j);
                boolean bl2 = false;
                if (!(Intrinsics.compare(it, 32) < 0 || PathsKt.contains(ReservedCharacters, it))) continue;
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean[] toASCIITable(char[] $this$toASCIITable) {
        int n = 0;
        boolean[] blArray = new boolean[256];
        while (n < 256) {
            int n2 = n++;
            blArray[n2] = ArraysKt.contains($this$toASCIITable, (char)n2);
        }
        return blArray;
    }

    private static final boolean contains(boolean[] $this$contains, char c) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        char codepoint = c;
        return codepoint < $this$contains.length && $this$contains[codepoint];
    }

    static {
        Object[] objectArray = new char[]{'A', 'a', 'C', 'c', 'l', 'L', 'P', 'p', 'n', 'N'};
        FirstReservedLetters = PathsKt.toASCIITable(objectArray);
        objectArray = new String[22];
        objectArray[0] = (char)"CON";
        objectArray[1] = (char)"PRN";
        objectArray[2] = (char)"AUX";
        objectArray[3] = (char)"NUL";
        objectArray[4] = (char)"COM1";
        objectArray[5] = (char)"COM2";
        objectArray[6] = (char)"COM3";
        objectArray[7] = (char)"COM4";
        objectArray[8] = (char)"COM5";
        objectArray[9] = (char)"COM6";
        objectArray[10] = (char)"COM7";
        objectArray[11] = (char)"COM8";
        objectArray[12] = (char)"COM9";
        objectArray[13] = (char)"LPT1";
        objectArray[14] = (char)"LPT2";
        objectArray[15] = (char)"LPT3";
        objectArray[16] = (char)"LPT4";
        objectArray[17] = (char)"LPT5";
        objectArray[18] = (char)"LPT6";
        objectArray[19] = (char)"LPT7";
        objectArray[20] = (char)"LPT8";
        objectArray[21] = (char)"LPT9";
        ReservedWords = SetsKt.setOf(objectArray);
        objectArray = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        ReservedCharacters = PathsKt.toASCIITable(objectArray);
    }
}

