/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AttestationVerifier;
import com.webauthn4j.verifier.AuthenticatorExtensionVerifier;
import com.webauthn4j.verifier.BeanAssertUtil;
import com.webauthn4j.verifier.ChallengeVerifier;
import com.webauthn4j.verifier.ClientExtensionVerifier;
import com.webauthn4j.verifier.CustomRegistrationVerifier;
import com.webauthn4j.verifier.OriginVerifier;
import com.webauthn4j.verifier.OriginVerifierImpl;
import com.webauthn4j.verifier.RegistrationObject;
import com.webauthn4j.verifier.RpIdHashVerifier;
import com.webauthn4j.verifier.TokenBindingVerifier;
import com.webauthn4j.verifier.attestation.statement.AttestationStatementVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import com.webauthn4j.verifier.exception.CredentialIdTooLongException;
import com.webauthn4j.verifier.exception.IllegalBackupStateException;
import com.webauthn4j.verifier.exception.InconsistentClientDataTypeException;
import com.webauthn4j.verifier.exception.NotAllowedAlgorithmException;
import com.webauthn4j.verifier.exception.UserNotPresentException;
import com.webauthn4j.verifier.exception.UserNotVerifiedException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RegistrationDataVerifier {
    private static final int DEFAULT_MAX_CREDENTIAL_ID_LENGTH = 1023;
    private final ChallengeVerifier challengeVerifier = new ChallengeVerifier();
    private final TokenBindingVerifier tokenBindingVerifier = new TokenBindingVerifier();
    private final RpIdHashVerifier rpIdHashVerifier = new RpIdHashVerifier();
    private final ClientExtensionVerifier clientExtensionVerifier = new ClientExtensionVerifier();
    private final AuthenticatorExtensionVerifier authenticatorExtensionVerifier = new AuthenticatorExtensionVerifier();
    private final List<CustomRegistrationVerifier> customRegistrationVerifiers;
    private final AttestationVerifier attestationVerifier;
    private OriginVerifier originVerifier = new OriginVerifierImpl();
    private int maxCredentialIdLength = 1023;

    public RegistrationDataVerifier(@NotNull List<AttestationStatementVerifier> attestationStatementVerifiers, @NotNull CertPathTrustworthinessVerifier certPathTrustworthinessVerifier, @NotNull SelfAttestationTrustworthinessVerifier selfAttestationTrustworthinessVerifier, @NotNull List<CustomRegistrationVerifier> customRegistrationVerifiers, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(attestationStatementVerifiers, (String)"attestationStatementVerifiers must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessVerifier, (String)"certPathTrustworthinessVerifier must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessVerifier, (String)"selfAttestationTrustworthinessVerifier must not be null");
        AssertUtil.notNull(customRegistrationVerifiers, (String)"customRegistrationVerifiers must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.attestationVerifier = new AttestationVerifier(attestationStatementVerifiers, certPathTrustworthinessVerifier, selfAttestationTrustworthinessVerifier);
        this.customRegistrationVerifiers = customRegistrationVerifiers;
    }

    public void verify(@NotNull RegistrationData registrationData, @NotNull RegistrationParameters registrationParameters) {
        BeanAssertUtil.validate(registrationData);
        AssertUtil.notNull((Object)registrationParameters, (String)"registrationParameters must not be null");
        byte[] clientDataBytes = registrationData.getCollectedClientDataBytes();
        byte[] attestationObjectBytes = registrationData.getAttestationObjectBytes();
        CollectedClientData collectedClientData = registrationData.getCollectedClientData();
        AttestationObject attestationObject = registrationData.getAttestationObject();
        Set<AuthenticatorTransport> transports = registrationData.getTransports();
        AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions = registrationData.getClientExtensions();
        this.verifyAuthenticatorDataField(attestationObject.getAuthenticatorData());
        ServerProperty serverProperty = registrationParameters.getServerProperty();
        RegistrationObject registrationObject = new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, clientDataBytes, clientExtensions, transports, serverProperty);
        AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData = attestationObject.getAuthenticatorData();
        if (!Objects.equals(collectedClientData.getType(), ClientDataType.WEBAUTHN_CREATE)) {
            throw new InconsistentClientDataTypeException("ClientData.type must be 'create' on registration, but it isn't.");
        }
        this.challengeVerifier.verify(collectedClientData, serverProperty);
        this.originVerifier.verify(registrationObject);
        this.tokenBindingVerifier.verify(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashVerifier.verify(authenticatorData.getRpIdHash(), serverProperty);
        this.verifyUVUPFlags(authenticatorData, registrationParameters.isUserVerificationRequired(), registrationParameters.isUserPresenceRequired());
        this.verifyBEBSFlags(authenticatorData);
        COSEAlgorithmIdentifier alg = authenticatorData.getAttestedCredentialData().getCOSEKey().getAlgorithm();
        List<PublicKeyCredentialParameters> pubKeyCredParams = registrationParameters.getPubKeyCredParams();
        this.verifyAlg(alg, pubKeyCredParams);
        AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.clientExtensionVerifier.verify(clientExtensions);
        this.authenticatorExtensionVerifier.verify(authenticationExtensionsAuthenticatorOutputs);
        this.attestationVerifier.verify(registrationObject);
        this.verifyCredentialIdLength(attestationObject.getAuthenticatorData().getAttestedCredentialData().getCredentialId());
        for (CustomRegistrationVerifier customRegistrationVerifier : this.customRegistrationVerifiers) {
            customRegistrationVerifier.verify(registrationObject);
        }
    }

    void verifyAlg(COSEAlgorithmIdentifier alg, List<PublicKeyCredentialParameters> pubKeyCredParams) {
        if (pubKeyCredParams != null && pubKeyCredParams.stream().noneMatch(item -> item.getAlg().equals(alg))) {
            throw new NotAllowedAlgorithmException("alg not listed in options.pubKeyCredParams is used.");
        }
    }

    void verifyAuthenticatorDataField(AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() == null) {
            throw new ConstraintViolationException("attestedCredentialData must not be null on registration");
        }
    }

    void verifyUVUPFlags(AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData, boolean isUserVerificationRequired, boolean isUserPresenceRequired) {
        if (isUserPresenceRequired && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Verifier is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        if (isUserVerificationRequired && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Verifier is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
    }

    void verifyBEBSFlags(AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData) {
        if (!authenticatorData.isFlagBE() && authenticatorData.isFlagBS()) {
            throw new IllegalBackupStateException("Backup state bit must not be set if backup eligibility bit is not set");
        }
    }

    void verifyCredentialIdLength(byte[] credentialId) {
        if (this.maxCredentialIdLength >= 0 && credentialId.length > this.maxCredentialIdLength) {
            throw new CredentialIdTooLongException(String.format("credentialId exceeds maxCredentialIdSize(%d bytes)", this.maxCredentialIdLength));
        }
    }

    public OriginVerifier getOriginVerifier() {
        return this.originVerifier;
    }

    public void setOriginVerifier(OriginVerifier originVerifier) {
        this.originVerifier = originVerifier;
    }

    public int getMaxCredentialIdLength() {
        return this.maxCredentialIdLength;
    }

    public void setMaxCredentialIdLength(int maxCredentialIdLength) {
        this.maxCredentialIdLength = maxCredentialIdLength;
    }

    public List<CustomRegistrationVerifier> getCustomRegistrationVerifiers() {
        return this.customRegistrationVerifiers;
    }
}

