/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.report.formatter;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.school.model.report.ReportSeries;
import world.respect.datalayer.school.model.report.ReportXAxis;
import world.respect.shared.domain.report.formatter.CountGraphFormatter;
import world.respect.shared.domain.report.formatter.DateGraphFormatter;
import world.respect.shared.domain.report.formatter.DurationGraphFormatter;
import world.respect.shared.domain.report.formatter.GenderGraphFormatter;
import world.respect.shared.domain.report.formatter.GraphFormatter;
import world.respect.shared.domain.report.formatter.NoOpGraphFormatter;
import world.respect.shared.domain.report.query.RunReportUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0086\u0002\u00a8\u0006\f"}, d2={"Lworld/respect/shared/domain/report/formatter/CreateGraphFormatterUseCase;", "", "<init>", "()V", "invoke", "Lworld/respect/shared/domain/report/formatter/GraphFormatter;", "T", "reportResult", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult;", "options", "Lworld/respect/shared/domain/report/formatter/CreateGraphFormatterUseCase$FormatterOptions;", "FormatterOptions", "respect-lib-shared"})
@StabilityInferred(parameters=1)
public final class CreateGraphFormatterUseCase {
    public static final int $stable;

    @NotNull
    public final <T> GraphFormatter<T> invoke(@NotNull RunReportUseCase.RunReportResult reportResult, @NotNull FormatterOptions<T> options) {
        GraphFormatter graphFormatter;
        Intrinsics.checkNotNullParameter((Object)reportResult, (String)"reportResult");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        if (options.getAxis() == FormatterOptions.Axis.Y_AXIS_VALUES && Intrinsics.areEqual(options.getParamType(), (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            graphFormatter = Intrinsics.areEqual((Object)((ReportSeries)CollectionsKt.first((List)reportResult.getRequest().getReportOptions().getSeries())).getReportSeriesYAxis().getType(), (Object)"DURATION") ? (GraphFormatter)new DurationGraphFormatter(reportResult) : (GraphFormatter)new CountGraphFormatter();
        } else if (options.getAxis() == FormatterOptions.Axis.X_AXIS_VALUES && Intrinsics.areEqual(options.getParamType(), (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            ReportXAxis reportXAxis;
            if (options.getForSubgroup()) {
                reportXAxis = ((ReportSeries)CollectionsKt.first((List)reportResult.getRequest().getReportOptions().getSeries())).getReportSeriesSubGroup();
                if (reportXAxis == null) {
                    reportXAxis = ReportXAxis.DAY;
                }
            } else {
                reportXAxis = reportResult.getRequest().getReportOptions().getXAxis();
            }
            ReportXAxis axisType = reportXAxis;
            switch (WhenMappings.$EnumSwitchMapping$0[axisType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    graphFormatter = new DateGraphFormatter(axisType);
                    break;
                }
                case 5: {
                    graphFormatter = new GenderGraphFormatter();
                    break;
                }
                default: {
                    graphFormatter = new NoOpGraphFormatter();
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported formatter options combination");
        }
        return graphFormatter;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u001bB'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J3\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lworld/respect/shared/domain/report/formatter/CreateGraphFormatterUseCase$FormatterOptions;", "T", "", "paramType", "Lkotlin/reflect/KClass;", "axis", "Lworld/respect/shared/domain/report/formatter/CreateGraphFormatterUseCase$FormatterOptions$Axis;", "forSubgroup", "", "<init>", "(Lkotlin/reflect/KClass;Lworld/respect/shared/domain/report/formatter/CreateGraphFormatterUseCase$FormatterOptions$Axis;Z)V", "getParamType", "()Lkotlin/reflect/KClass;", "getAxis", "()Lworld/respect/shared/domain/report/formatter/CreateGraphFormatterUseCase$FormatterOptions$Axis;", "getForSubgroup", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Axis", "respect-lib-shared"})
    @StabilityInferred(parameters=0)
    public static final class FormatterOptions<T> {
        @NotNull
        private final KClass<T> paramType;
        @NotNull
        private final Axis axis;
        private final boolean forSubgroup;
        public static final int $stable = 8;

        public FormatterOptions(@NotNull KClass<T> paramType, @NotNull Axis axis, boolean forSubgroup) {
            Intrinsics.checkNotNullParameter(paramType, (String)"paramType");
            Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
            this.paramType = paramType;
            this.axis = axis;
            this.forSubgroup = forSubgroup;
        }

        public /* synthetic */ FormatterOptions(KClass kClass, Axis axis, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(kClass, axis, bl);
        }

        @NotNull
        public final KClass<T> getParamType() {
            return this.paramType;
        }

        @NotNull
        public final Axis getAxis() {
            return this.axis;
        }

        public final boolean getForSubgroup() {
            return this.forSubgroup;
        }

        @NotNull
        public final KClass<T> component1() {
            return this.paramType;
        }

        @NotNull
        public final Axis component2() {
            return this.axis;
        }

        public final boolean component3() {
            return this.forSubgroup;
        }

        @NotNull
        public final FormatterOptions<T> copy(@NotNull KClass<T> paramType, @NotNull Axis axis, boolean forSubgroup) {
            Intrinsics.checkNotNullParameter(paramType, (String)"paramType");
            Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
            return new FormatterOptions<T>(paramType, axis, forSubgroup);
        }

        public static /* synthetic */ FormatterOptions copy$default(FormatterOptions formatterOptions, KClass kClass, Axis axis, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                kClass = formatterOptions.paramType;
            }
            if ((n & 2) != 0) {
                axis = formatterOptions.axis;
            }
            if ((n & 4) != 0) {
                bl = formatterOptions.forSubgroup;
            }
            return formatterOptions.copy(kClass, axis, bl);
        }

        @NotNull
        public String toString() {
            return "FormatterOptions(paramType=" + this.paramType + ", axis=" + this.axis + ", forSubgroup=" + this.forSubgroup + ")";
        }

        public int hashCode() {
            int result = this.paramType.hashCode();
            result = result * 31 + this.axis.hashCode();
            result = result * 31 + Boolean.hashCode(this.forSubgroup);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FormatterOptions)) {
                return false;
            }
            FormatterOptions formatterOptions = (FormatterOptions)other;
            if (!Intrinsics.areEqual(this.paramType, formatterOptions.paramType)) {
                return false;
            }
            if (this.axis != formatterOptions.axis) {
                return false;
            }
            return this.forSubgroup == formatterOptions.forSubgroup;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lworld/respect/shared/domain/report/formatter/CreateGraphFormatterUseCase$FormatterOptions$Axis;", "", "<init>", "(Ljava/lang/String;I)V", "Y_AXIS_VALUES", "X_AXIS_VALUES", "respect-lib-shared"})
        public static final class Axis
        extends Enum<Axis> {
            public static final /* enum */ Axis Y_AXIS_VALUES = new Axis();
            public static final /* enum */ Axis X_AXIS_VALUES = new Axis();
            private static final /* synthetic */ Axis[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Axis[] values() {
                return (Axis[])$VALUES.clone();
            }

            public static Axis valueOf(String value) {
                return Enum.valueOf(Axis.class, value);
            }

            @NotNull
            public static EnumEntries<Axis> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = axisArray = new Axis[]{Axis.Y_AXIS_VALUES, Axis.X_AXIS_VALUES};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportXAxis.values().length];
            try {
                nArray[ReportXAxis.DAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.WEEK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.MONTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.YEAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportXAxis.GENDER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

