/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.test;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/meshrabiya/test/EchoDatagramServer;", "Ljava/lang/Runnable;", "port", "", "executor", "Ljava/util/concurrent/ExecutorService;", "(ILjava/util/concurrent/ExecutorService;)V", "datagramSocket", "Ljava/net/DatagramSocket;", "getDatagramSocket", "()Ljava/net/DatagramSocket;", "future", "Ljava/util/concurrent/Future;", "getFuture", "()Ljava/util/concurrent/Future;", "listeningPort", "getListeningPort", "()I", "close", "", "run", "test-shared_release"})
public final class EchoDatagramServer
implements Runnable {
    @NotNull
    private final DatagramSocket datagramSocket;
    @NotNull
    private final Future<?> future;
    private final int listeningPort;

    public EchoDatagramServer(int port, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.datagramSocket = new DatagramSocket(port);
        this.listeningPort = this.datagramSocket.getLocalPort();
        Future<?> future = executor.submit(this);
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        this.future = future;
    }

    @NotNull
    public final DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    @NotNull
    public final Future<?> getFuture() {
        return this.future;
    }

    public final int getListeningPort() {
        return this.listeningPort;
    }

    @Override
    public void run() {
        byte[] buf = new byte[1500];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        while (!Thread.interrupted()) {
            this.datagramSocket.receive(packet);
            DatagramPacket replyPacket = new DatagramPacket(buf, 0, packet.getLength(), packet.getAddress(), packet.getPort());
            this.datagramSocket.send(replyPacket);
        }
    }

    public final void close() {
        this.future.cancel(true);
        this.datagramSocket.close();
    }
}

