/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.util.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/ustadmobile/util/test/ReverseProxyDispatcher;", "Lokhttp3/mockwebserver/Dispatcher;", "serverUrl", "Lokhttp3/HttpUrl;", "(Lokhttp3/HttpUrl;)V", "client", "Lokhttp3/OkHttpClient;", "numTimesToFail", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumTimesToFail", "()Ljava/util/concurrent/atomic/AtomicInteger;", "throttleBytesPerPeriod", "", "getThrottleBytesPerPeriod", "()J", "setThrottleBytesPerPeriod", "(J)V", "throttlePeriod", "getThrottlePeriod", "setThrottlePeriod", "throttlePeriodUnit", "Ljava/util/concurrent/TimeUnit;", "getThrottlePeriodUnit", "()Ljava/util/concurrent/TimeUnit;", "setThrottlePeriodUnit", "(Ljava/util/concurrent/TimeUnit;)V", "dispatch", "Lokhttp3/mockwebserver/MockResponse;", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "lib-test-common"})
@SourceDebugExtension(value={"SMAP\nReverseProxyDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReverseProxyDispatcher.kt\ncom/ustadmobile/util/test/ReverseProxyDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n766#2:109\n857#2,2:110\n1855#2,2:112\n*S KotlinDebug\n*F\n+ 1 ReverseProxyDispatcher.kt\ncom/ustadmobile/util/test/ReverseProxyDispatcher\n*L\n90#1:109\n90#1:110,2\n91#1:112,2\n*E\n"})
public final class ReverseProxyDispatcher
extends Dispatcher {
    @NotNull
    private final HttpUrl serverUrl;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final AtomicInteger numTimesToFail;
    private long throttleBytesPerPeriod;
    private long throttlePeriod;
    @NotNull
    private TimeUnit throttlePeriodUnit;

    public ReverseProxyDispatcher(@NotNull HttpUrl serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
        this.numTimesToFail = new AtomicInteger(0);
        this.throttlePeriodUnit = TimeUnit.MILLISECONDS;
        this.client = new OkHttpClient.Builder().build();
    }

    @NotNull
    public final AtomicInteger getNumTimesToFail() {
        return this.numTimesToFail;
    }

    public final long getThrottleBytesPerPeriod() {
        return this.throttleBytesPerPeriod;
    }

    public final void setThrottleBytesPerPeriod(long l) {
        this.throttleBytesPerPeriod = l;
    }

    public final long getThrottlePeriod() {
        return this.throttlePeriod;
    }

    public final void setThrottlePeriod(long l) {
        this.throttlePeriod = l;
    }

    @NotNull
    public final TimeUnit getThrottlePeriodUnit() {
        return this.throttlePeriodUnit;
    }

    public final void setThrottlePeriodUnit(@NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"<set-?>");
        this.throttlePeriodUnit = timeUnit;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MockResponse dispatch(@NotNull RecordedRequest request) throws InterruptedException {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpUrl proxiedUri = HttpUrl.Companion.get("http://example.com" + request.getPath()).newBuilder().scheme(this.serverUrl.scheme()).host(this.serverUrl.host()).port(this.serverUrl.port()).build();
        String forwardedHost = this.serverUrl.port() == HttpUrl.Companion.defaultPort(this.serverUrl.scheme()) ? this.serverUrl.host() : this.serverUrl.host() + ":" + this.serverUrl.port();
        Request.Builder requestBuilder = new Request.Builder().url(proxiedUri).headers(request.getHeaders()).addHeader("Forwarded", "host=" + forwardedHost + ";proto=" + this.serverUrl.scheme());
        String string = request.getMethod();
        if (string == null) {
            throw new IllegalArgumentException("request has no method!");
        }
        String method = string;
        if (request.getBodySize() != 0L) {
            requestBuilder.method(method, new RequestBody(request){
                final /* synthetic */ RecordedRequest $request;
                {
                    this.$request = $request;
                }

                @NotNull
                public MediaType contentType() {
                    String string = this.$request.getHeader("Content-Type");
                    if (string == null) {
                        string = "application/octet-stream";
                    }
                    String contentType = string;
                    return MediaType.Companion.get(contentType);
                }

                public void writeTo(@NotNull BufferedSink sink) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    this.$request.getBody().readAll((Sink)sink);
                }
            });
        }
        Response response = null;
        try {
            response = this.client.newCall(requestBuilder.build()).execute();
        }
        catch (IOException e) {
            response = null;
        }
        if (response == null) {
            return new MockResponse().setStatus("Reverse proxy error").setResponseCode(500);
        }
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        byte[] responseBytes = responseBody.bytes();
        BufferedSource fileBuffer = Okio.buffer((Source)Okio.source((InputStream)new ByteArrayInputStream(responseBytes)));
        Buffer outBuffer = new Buffer();
        fileBuffer.readFully(outBuffer, (long)responseBytes.length);
        MockResponse mockResponse = new MockResponse().setBody(outBuffer).setResponseCode(response.code());
        Iterable $this$filter$iv = (Iterable)response.headers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"transfer-encoding", (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair responseHeader = (Pair)element$iv;
            boolean bl = false;
            mockResponse.addHeader((String)responseHeader.getFirst(), responseHeader.getSecond());
        }
        if (this.numTimesToFail.decrementAndGet() >= 0) {
            mockResponse.setSocketPolicy(SocketPolicy.DISCONNECT_DURING_RESPONSE_BODY);
        }
        if (this.throttleBytesPerPeriod != 0L) {
            mockResponse.throttleBody(this.throttleBytesPerPeriod, this.throttlePeriod, this.throttlePeriodUnit);
        }
        return mockResponse;
    }
}

