/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.ViewportHint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001'B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\u0004\b\n\u0010\u000bB\u001f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\n\u0010\rJ.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u001f\u001a\u00020\bH\u0016J\t\u0010 \u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\u0011\u0010#\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006H\u00c6\u0003JE\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006H\u00c6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006("}, d2={"Landroidx/paging/TransformablePage;", "T", "", "originalPageOffsets", "", "data", "", "hintOriginalPageOffset", "", "hintOriginalIndices", "<init>", "([ILjava/util/List;ILjava/util/List;)V", "originalPageOffset", "(ILjava/util/List;)V", "getOriginalPageOffsets", "()[I", "getData", "()Ljava/util/List;", "getHintOriginalPageOffset", "()I", "getHintOriginalIndices", "viewportHintFor", "Landroidx/paging/ViewportHint$Access;", "index", "presentedItemsBefore", "presentedItemsAfter", "originalPageOffsetFirst", "originalPageOffsetLast", "equals", "", "other", "hashCode", "component1", "component2", "component3", "component4", "copy", "toString", "", "Companion", "paging-common"})
public final class TransformablePage<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] originalPageOffsets;
    @NotNull
    private final List<T> data;
    private final int hintOriginalPageOffset;
    @Nullable
    private final List<Integer> hintOriginalIndices;
    @NotNull
    private static final TransformablePage<Object> EMPTY_INITIAL_PAGE = new TransformablePage(0, CollectionsKt.emptyList());

    public TransformablePage(@NotNull int[] originalPageOffsets, @NotNull List<? extends T> data2, int hintOriginalPageOffset, @Nullable List<Integer> hintOriginalIndices) {
        Intrinsics.checkNotNullParameter(originalPageOffsets, "originalPageOffsets");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.originalPageOffsets = originalPageOffsets;
        this.data = data2;
        this.hintOriginalPageOffset = hintOriginalPageOffset;
        this.hintOriginalIndices = hintOriginalIndices;
        if (!(!(this.originalPageOffsets.length == 0))) {
            boolean $i$a$-require-TransformablePage$32 = false;
            String $i$a$-require-TransformablePage$32 = "originalPageOffsets cannot be empty when constructing TransformablePage";
            throw new IllegalArgumentException($i$a$-require-TransformablePage$32.toString());
        }
        if (!(this.hintOriginalIndices == null || this.hintOriginalIndices.size() == this.data.size())) {
            boolean bl = false;
            List<Integer> list2 = this.hintOriginalIndices;
            Intrinsics.checkNotNull(list2);
            String string2 = "If originalIndices (size = " + list2.size() + ") is provided, it must be same length as data (size = " + this.data.size() + ")";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final int[] getOriginalPageOffsets() {
        return this.originalPageOffsets;
    }

    @NotNull
    public final List<T> getData() {
        return this.data;
    }

    public final int getHintOriginalPageOffset() {
        return this.hintOriginalPageOffset;
    }

    @Nullable
    public final List<Integer> getHintOriginalIndices() {
        return this.hintOriginalIndices;
    }

    public TransformablePage(int originalPageOffset, @NotNull List<? extends T> data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        int[] nArray = new int[]{originalPageOffset};
        this(nArray, data2, originalPageOffset, null);
    }

    @NotNull
    public final ViewportHint.Access viewportHintFor(int index2, int presentedItemsBefore, int presentedItemsAfter, int originalPageOffsetFirst, int originalPageOffsetLast) {
        Iterable<Integer> iterable = this.hintOriginalIndices;
        return new ViewportHint.Access(this.hintOriginalPageOffset, (iterable != null && (iterable = CollectionsKt.getIndices((Collection)iterable)) != null ? ((IntRange)iterable).contains(index2) : false) ? ((Number)this.hintOriginalIndices.get(index2)).intValue() : index2, presentedItemsBefore, presentedItemsAfter, originalPageOffsetFirst, originalPageOffsetLast);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformablePage cfr_ignored_0 = (TransformablePage)other;
        if (!Arrays.equals(this.originalPageOffsets, ((TransformablePage)other).originalPageOffsets)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.data, ((TransformablePage)other).data)) {
            return false;
        }
        if (this.hintOriginalPageOffset != ((TransformablePage)other).hintOriginalPageOffset) {
            return false;
        }
        return Intrinsics.areEqual(this.hintOriginalIndices, ((TransformablePage)other).hintOriginalIndices);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.originalPageOffsets);
        result2 = 31 * result2 + ((Object)this.data).hashCode();
        result2 = 31 * result2 + this.hintOriginalPageOffset;
        List<Integer> list2 = this.hintOriginalIndices;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        return result2;
    }

    @NotNull
    public final int[] component1() {
        return this.originalPageOffsets;
    }

    @NotNull
    public final List<T> component2() {
        return this.data;
    }

    public final int component3() {
        return this.hintOriginalPageOffset;
    }

    @Nullable
    public final List<Integer> component4() {
        return this.hintOriginalIndices;
    }

    @NotNull
    public final TransformablePage<T> copy(@NotNull int[] originalPageOffsets, @NotNull List<? extends T> data2, int hintOriginalPageOffset, @Nullable List<Integer> hintOriginalIndices) {
        Intrinsics.checkNotNullParameter(originalPageOffsets, "originalPageOffsets");
        Intrinsics.checkNotNullParameter(data2, "data");
        return new TransformablePage<T>(originalPageOffsets, data2, hintOriginalPageOffset, hintOriginalIndices);
    }

    public static /* synthetic */ TransformablePage copy$default(TransformablePage transformablePage, int[] nArray, List list2, int n, List list3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            nArray = transformablePage.originalPageOffsets;
        }
        if ((n2 & 2) != 0) {
            list2 = transformablePage.data;
        }
        if ((n2 & 4) != 0) {
            n = transformablePage.hintOriginalPageOffset;
        }
        if ((n2 & 8) != 0) {
            list3 = transformablePage.hintOriginalIndices;
        }
        return transformablePage.copy(nArray, list2, n, list3);
    }

    @NotNull
    public String toString() {
        return "TransformablePage(originalPageOffsets=" + Arrays.toString(this.originalPageOffsets) + ", data=" + this.data + ", hintOriginalPageOffset=" + this.hintOriginalPageOffset + ", hintOriginalIndices=" + this.hintOriginalIndices + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/paging/TransformablePage$Companion;", "", "<init>", "()V", "empty", "Landroidx/paging/TransformablePage;", "T", "EMPTY_INITIAL_PAGE", "getEMPTY_INITIAL_PAGE", "()Landroidx/paging/TransformablePage;", "paging-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> TransformablePage<T> empty() {
            TransformablePage<Object> transformablePage = this.getEMPTY_INITIAL_PAGE();
            Intrinsics.checkNotNull(transformablePage, "null cannot be cast to non-null type androidx.paging.TransformablePage<T of androidx.paging.TransformablePage.Companion.empty>");
            return transformablePage;
        }

        @NotNull
        public final TransformablePage<Object> getEMPTY_INITIAL_PAGE() {
            return EMPTY_INITIAL_PAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

