/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.FormatValidator;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonType;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;

public interface Format {
    public String getName();

    default public String getMessageKey() {
        return "format";
    }

    @Deprecated
    default public String getErrorMessageDescription() {
        return "";
    }

    default public boolean matches(ExecutionContext executionContext, String value) {
        return true;
    }

    default public boolean matches(ExecutionContext executionContext, ValidationContext validationContext, String value) {
        return this.matches(executionContext, value);
    }

    default public boolean matches(ExecutionContext executionContext, ValidationContext validationContext, JsonNode value) {
        JsonType nodeType = TypeFactory.getValueNodeType(value, validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return true;
        }
        return this.matches(executionContext, validationContext, value.textValue());
    }

    default public boolean matches(ExecutionContext executionContext, ValidationContext validationContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean assertionsEnabled, FormatValidator formatValidator) {
        return this.matches(executionContext, validationContext, node2);
    }

    default public Set<ValidationMessage> validate(ExecutionContext executionContext, ValidationContext validationContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean assertionsEnabled, Supplier<MessageSourceValidationMessage.Builder> message, FormatValidator formatValidator) {
        if (assertionsEnabled && !this.matches(executionContext, validationContext, node2, rootNode, instanceLocation, assertionsEnabled, formatValidator)) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)message.get().arguments(this.getName(), this.getErrorMessageDescription(), node2.asText())).build());
        }
        return Collections.emptySet();
    }
}

