/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.navigation.NavArgumentKt;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.savedstate.SavedState;
import androidx.savedstate.SavedStateReader;
import androidx.savedstate.SavedStateWriter;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Navigator.Name(value="navigation")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u0002H\u0016J*\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Landroidx/navigation/NavGraphNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/NavGraph;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "<init>", "(Landroidx/navigation/NavigatorProvider;)V", "backStack", "Lkotlinx/coroutines/flow/StateFlow;", "", "Landroidx/navigation/NavBackStackEntry;", "getBackStack", "()Lkotlinx/coroutines/flow/StateFlow;", "createDestination", "navigate", "", "entries", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "entry", "Companion", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavGraphNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavGraphNavigator.kt\nandroidx/navigation/NavGraphNavigator\n+ 2 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n+ 3 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n90#2:135\n106#2:141\n90#2:143\n30#3:136\n45#3:137\n34#3,2:138\n1#4:140\n1#4:142\n*S KotlinDebug\n*F\n+ 1 NavGraphNavigator.kt\nandroidx/navigation/NavGraphNavigator\n*L\n93#1:135\n94#1:141\n107#1:143\n94#1:136\n94#1:137\n94#1:138,2\n94#1:140\n*E\n"})
public class NavGraphNavigator
extends Navigator<NavGraph> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NavigatorProvider navigatorProvider;
    @NotNull
    public static final String NAME = "navigation";

    public NavGraphNavigator(@NotNull NavigatorProvider navigatorProvider) {
        Intrinsics.checkNotNullParameter(navigatorProvider, "navigatorProvider");
        super(NAME);
        this.navigatorProvider = navigatorProvider;
    }

    @NotNull
    public final StateFlow<List<NavBackStackEntry>> getBackStack() {
        return this.getState().getBackStack();
    }

    @Override
    @NotNull
    public NavGraph createDestination() {
        return new NavGraph(this);
    }

    @Override
    public void navigate(@NotNull List<NavBackStackEntry> entries2, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries2, "entries");
        for (NavBackStackEntry entry : entries2) {
            this.navigate(entry, navOptions, navigatorExtras);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void navigate(NavBackStackEntry entry, NavOptions navOptions, Navigator.Extras navigatorExtras) {
        NavDestination navDestination = entry.getDestination();
        Intrinsics.checkNotNull(navDestination, "null cannot be cast to non-null type androidx.navigation.NavGraph");
        NavGraph destination = (NavGraph)navDestination;
        Ref.ObjectRef args = new Ref.ObjectRef();
        args.element = entry.getArguments();
        int startId = destination.getStartDestinationId();
        String startRoute = destination.getStartDestinationRoute();
        if (!(startId != 0 || startRoute != null)) {
            boolean $i$a$-check-NavGraphNavigator$navigate$22 = false;
            String $i$a$-check-NavGraphNavigator$navigate$22 = "no start destination defined via app:startDestination for " + destination.getDisplayName();
            throw new IllegalStateException($i$a$-check-NavGraphNavigator$navigate$22.toString());
        }
        NavDestination startDestination = startRoute != null ? destination.findNode(startRoute, false) : destination.getNodes().get(startId);
        if (startDestination == null) {
            boolean bl = false;
            String dest = destination.getStartDestDisplayName();
            throw new IllegalArgumentException("navigation destination " + dest + " is not a direct child of this NavGraph");
        }
        if (startRoute != null) {
            List<String> missingRequiredArgs;
            if (!Intrinsics.areEqual(startRoute, startDestination.getRoute())) {
                SavedState matchingArgs;
                NavDestination.DeepLinkMatch deepLinkMatch = startDestination.matchRoute(startRoute);
                SavedState savedState2 = matchingArgs = deepLinkMatch != null ? deepLinkMatch.getMatchingArgs() : null;
                if (matchingArgs != null) {
                    SavedState $this$read$iv = matchingArgs;
                    boolean $i$f$read = false;
                    SavedState $this$navigate_u24lambda_u242 = SavedStateReader.constructor-impl($this$read$iv);
                    boolean bl = false;
                    if (!SavedStateReader.isEmpty-impl($this$navigate_u24lambda_u242)) {
                        void $this$navigate_u24lambda_u244;
                        SavedState savedState3;
                        Map initialState$iv = MapsKt.emptyMap();
                        boolean $i$f$savedState = false;
                        Map<String, Object> copiedState$iv = MapsKt.toMutableMap(initialState$iv);
                        SavedState $this$savedState_u24lambda_u240$iv = savedState3 = new SavedState(copiedState$iv);
                        boolean bl2 = false;
                        SavedState $this$write$iv$iv = $this$savedState_u24lambda_u240$iv;
                        boolean $i$f$write = false;
                        SavedState savedState4 = SavedStateWriter.constructor-impl($this$write$iv$iv);
                        Ref.ObjectRef objectRef = args;
                        boolean bl3 = false;
                        SavedStateWriter.putAll-impl((SavedState)$this$navigate_u24lambda_u244, matchingArgs);
                        SavedState savedState5 = (SavedState)args.element;
                        if (savedState5 != null) {
                            SavedState it = savedState5;
                            boolean bl4 = false;
                            SavedStateWriter.putAll-impl((SavedState)$this$navigate_u24lambda_u244, it);
                        }
                        objectRef.element = savedState3;
                    }
                }
            }
            if (!startDestination.getArguments().isEmpty() && !(missingRequiredArgs = NavArgumentKt.missingRequiredArguments(startDestination.getArguments(), arg_0 -> NavGraphNavigator.navigate$lambda$6(args, arg_0))).isEmpty()) {
                boolean bl = false;
                String string2 = "Cannot navigate to startDestination " + startDestination + ". Missing required arguments [" + missingRequiredArgs + "]";
                throw new IllegalArgumentException(string2.toString());
            }
        }
        Object navigator = this.navigatorProvider.getNavigator(startDestination.getNavigatorName());
        NavBackStackEntry startDestinationEntry = this.getState().createBackStackEntry(startDestination, startDestination.addInDefaultArgs((SavedState)args.element));
        ((Navigator)navigator).navigate(CollectionsKt.listOf(startDestinationEntry), navOptions, navigatorExtras);
    }

    private static final boolean navigate$lambda$6(Ref.ObjectRef $args, String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        if ($args.element == null) {
            bl = true;
        } else {
            SavedState $this$read$iv = (SavedState)$args.element;
            boolean $i$f$read = false;
            SavedState $this$navigate_u24lambda_u246_u24lambda_u245 = SavedStateReader.constructor-impl($this$read$iv);
            boolean bl2 = false;
            bl = !SavedStateReader.contains-impl($this$navigate_u24lambda_u246_u24lambda_u245, key);
        }
        return bl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/NavGraphNavigator$Companion;", "", "<init>", "()V", "NAME", "", "navigation-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

