/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;

public class Base64UrlUtil {
    private static final Base64.Decoder decoder = Base64.getUrlDecoder();
    private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();

    private Base64UrlUtil() {
    }

    @NotNull
    public static byte[] decode(@NotNull String source2) {
        AssertUtil.notNull(source2, "source must not be null");
        return decoder.decode(source2);
    }

    @NotNull
    public static byte[] decode(@NotNull byte[] source2) {
        AssertUtil.notNull(source2, "source must not be null");
        return decoder.decode(source2);
    }

    @NotNull
    public static byte[] encode(@NotNull byte[] source2) {
        AssertUtil.notNull(source2, "source must not be null");
        return encoder.encode(source2);
    }

    @NotNull
    public static String encodeToString(@NotNull byte[] source2) {
        AssertUtil.notNull(source2, "source must not be null");
        return encoder.encodeToString(source2);
    }
}

