/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.ItemKeyedDataSource;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0005B;\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u001e\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\tJ$\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00020\u001cH\u0016J$\u0010\u001d\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00020\u001fH\u0016J$\u0010 \u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00020\u001fH\u0016J\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010#R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006$"}, d2={"Landroidx/paging/WrapperItemKeyedDataSource;", "K", "", "A", "B", "Landroidx/paging/ItemKeyedDataSource;", "source", "listFunction", "Landroidx/arch/core/util/Function;", "", "<init>", "(Landroidx/paging/ItemKeyedDataSource;Landroidx/arch/core/util/Function;)V", "keyMap", "Ljava/util/IdentityHashMap;", "addInvalidatedCallback", "", "onInvalidatedCallback", "Landroidx/paging/DataSource$InvalidatedCallback;", "removeInvalidatedCallback", "invalidate", "isInvalid", "", "()Z", "convertWithStashedKeys", "loadInitial", "params", "Landroidx/paging/ItemKeyedDataSource$LoadInitialParams;", "callback", "Landroidx/paging/ItemKeyedDataSource$LoadInitialCallback;", "loadAfter", "Landroidx/paging/ItemKeyedDataSource$LoadParams;", "Landroidx/paging/ItemKeyedDataSource$LoadCallback;", "loadBefore", "getKey", "item", "(Ljava/lang/Object;)Ljava/lang/Object;", "paging-common"})
public final class WrapperItemKeyedDataSource<K, A, B>
extends ItemKeyedDataSource<K, B> {
    @NotNull
    private final ItemKeyedDataSource<K, A> source;
    @NotNull
    private final Function<List<A>, List<B>> listFunction;
    @NotNull
    private final IdentityHashMap<B, K> keyMap;

    public WrapperItemKeyedDataSource(@NotNull ItemKeyedDataSource<K, A> source2, @NotNull Function<List<A>, List<B>> listFunction) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(listFunction, "listFunction");
        this.source = source2;
        this.listFunction = listFunction;
        this.keyMap = new IdentityHashMap();
    }

    @Override
    public void addInvalidatedCallback(@NotNull DataSource.InvalidatedCallback onInvalidatedCallback) {
        Intrinsics.checkNotNullParameter(onInvalidatedCallback, "onInvalidatedCallback");
        this.source.addInvalidatedCallback(onInvalidatedCallback);
    }

    @Override
    public void removeInvalidatedCallback(@NotNull DataSource.InvalidatedCallback onInvalidatedCallback) {
        Intrinsics.checkNotNullParameter(onInvalidatedCallback, "onInvalidatedCallback");
        this.source.removeInvalidatedCallback(onInvalidatedCallback);
    }

    @Override
    public void invalidate() {
        this.source.invalidate();
    }

    @Override
    public boolean isInvalid() {
        return this.source.isInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<B> convertWithStashedKeys(@NotNull List<? extends A> source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        List<B> dest = DataSource.Companion.convert$paging_common(this.listFunction, source2);
        IdentityHashMap<B, K> identityHashMap = this.keyMap;
        synchronized (identityHashMap) {
            boolean bl = false;
            int n = ((Collection)dest).size();
            for (int i2 = 0; i2 < n; ++i2) {
                ((Map)this.keyMap).put(dest.get(i2), this.source.getKey(source2.get(i2)));
            }
            Unit unit = Unit.INSTANCE;
        }
        return dest;
    }

    @Override
    public void loadInitial(@NotNull ItemKeyedDataSource.LoadInitialParams<K> params, @NotNull ItemKeyedDataSource.LoadInitialCallback<B> callback) {
        Intrinsics.checkNotNullParameter(params, "params");
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.source.loadInitial(params, new ItemKeyedDataSource.LoadInitialCallback<A>(callback, this){
            final /* synthetic */ ItemKeyedDataSource.LoadInitialCallback<B> $callback;
            final /* synthetic */ WrapperItemKeyedDataSource<K, A, B> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResult(List<? extends A> data2, int position, int totalCount) {
                Intrinsics.checkNotNullParameter(data2, "data");
                this.$callback.onResult(this.this$0.convertWithStashedKeys(data2), position, totalCount);
            }

            public void onResult(List<? extends A> data2) {
                Intrinsics.checkNotNullParameter(data2, "data");
                this.$callback.onResult(this.this$0.convertWithStashedKeys(data2));
            }
        });
    }

    @Override
    public void loadAfter(@NotNull ItemKeyedDataSource.LoadParams<K> params, @NotNull ItemKeyedDataSource.LoadCallback<B> callback) {
        Intrinsics.checkNotNullParameter(params, "params");
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.source.loadAfter(params, new ItemKeyedDataSource.LoadCallback<A>(callback, this){
            final /* synthetic */ ItemKeyedDataSource.LoadCallback<B> $callback;
            final /* synthetic */ WrapperItemKeyedDataSource<K, A, B> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResult(List<? extends A> data2) {
                Intrinsics.checkNotNullParameter(data2, "data");
                this.$callback.onResult(this.this$0.convertWithStashedKeys(data2));
            }
        });
    }

    @Override
    public void loadBefore(@NotNull ItemKeyedDataSource.LoadParams<K> params, @NotNull ItemKeyedDataSource.LoadCallback<B> callback) {
        Intrinsics.checkNotNullParameter(params, "params");
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.source.loadBefore(params, new ItemKeyedDataSource.LoadCallback<A>(callback, this){
            final /* synthetic */ ItemKeyedDataSource.LoadCallback<B> $callback;
            final /* synthetic */ WrapperItemKeyedDataSource<K, A, B> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResult(List<? extends A> data2) {
                Intrinsics.checkNotNullParameter(data2, "data");
                this.$callback.onResult(this.this$0.convertWithStashedKeys(data2));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public K getKey(@NotNull B item2) {
        Intrinsics.checkNotNullParameter(item2, "item");
        IdentityHashMap<B, K> identityHashMap = this.keyMap;
        synchronized (identityHashMap) {
            boolean bl = false;
            K k = this.keyMap.get(item2);
            Intrinsics.checkNotNull(k);
            K k2 = k;
            return k2;
        }
    }
}

