/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.argparse4j.annotation.Arg;
import net.sourceforge.argparse4j.helper.HelpScreenException;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.ReflectHelper;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.helper.TextWidthCounter;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.ArgumentGroupImpl;
import net.sourceforge.argparse4j.internal.ArgumentImpl;
import net.sourceforge.argparse4j.internal.ArgumentParserConfigurationImpl;
import net.sourceforge.argparse4j.internal.ParseState;
import net.sourceforge.argparse4j.internal.SubparsersImpl;
import net.sourceforge.argparse4j.internal.UnrecognizedArgumentException;
import net.sourceforge.argparse4j.internal.UnrecognizedCommandException;

public final class ArgumentParserImpl
implements ArgumentParser {
    private static final int SUBSTITUTION_COST = 2;
    private static final int SWAP_COST = 0;
    private static final int DELETION_COST = 4;
    private static final int ADDITION_COST = 1;
    private final Map<String, ArgumentImpl> namedArgIndex_ = new HashMap<String, ArgumentImpl>();
    private final List<ArgumentImpl> namedArgs_ = new ArrayList<ArgumentImpl>();
    private final List<ArgumentImpl> posArgs_ = new ArrayList<ArgumentImpl>();
    private final List<ArgumentGroupImpl> argGroups_ = new ArrayList<ArgumentGroupImpl>();
    private final Map<String, Object> defaults_ = new HashMap<String, Object>();
    private final SubparsersImpl subparsers_ = new SubparsersImpl(this);
    private final ArgumentParserImpl mainParser_;
    private final String command_;
    private final ArgumentParserConfigurationImpl config_;
    private String usage_ = "";
    private String description_ = "";
    private String epilog_ = "";
    private String version_ = "";
    private boolean defaultHelp_ = false;
    private boolean negNumFlag_ = false;
    private static final Pattern NEG_NUM_PATTERN = Pattern.compile("-\\d+");
    private static final Pattern SHORT_OPTS_PATTERN = Pattern.compile("-[^-].*");

    public ArgumentParserImpl(ArgumentParserConfigurationImpl config2) {
        this(config2, null, null);
    }

    public ArgumentParserImpl(ArgumentParserConfigurationImpl config2, String command2, ArgumentParserImpl mainParser) {
        this.config_ = config2;
        this.command_ = command2;
        this.mainParser_ = mainParser;
        if (config2.prefixChars_ == null || config2.prefixChars_.isEmpty()) {
            throw new IllegalArgumentException("prefixChars cannot be a null or empty");
        }
        if (config2.formatWidth_ <= 0) {
            throw new IllegalArgumentException("formatWidth must be greater than 0");
        }
        if (config2.addHelp_) {
            String prefix = config2.prefixChars_.substring(0, 1);
            this.addArgument(prefix + "h", prefix + prefix + "help").action(Arguments.help()).help(this.localize("help")).setDefault(Arguments.SUPPRESS);
        }
    }

    @Override
    public ArgumentImpl addArgument(String ... nameOrFlags) {
        return this.addArgument((ArgumentGroupImpl)null, nameOrFlags);
    }

    public ArgumentImpl addArgument(ArgumentGroupImpl group, String ... nameOrFlags) {
        ArgumentImpl arg = new ArgumentImpl(this.config_, group, nameOrFlags);
        if (arg.isNamedArgument()) {
            for (String flag : arg.getFlags()) {
                ArgumentImpl another = this.namedArgIndex_.get(flag);
                if (another == null) continue;
                throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, this.localize("conflictingOptionStringsError"), flag, another.textualName()));
            }
            for (String flag : arg.getFlags()) {
                if (NEG_NUM_PATTERN.matcher(flag).matches()) {
                    this.negNumFlag_ = true;
                }
                this.namedArgIndex_.put(flag, arg);
            }
            this.namedArgs_.add(arg);
        } else {
            for (ArgumentImpl another : this.posArgs_) {
                if (!arg.getName().equals(another.getName())) continue;
                throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, this.localize("conflictingOptionStringsError"), arg.getName(), another.textualName()));
            }
            this.posArgs_.add(arg);
        }
        return arg;
    }

    @Override
    public SubparsersImpl addSubparsers() {
        return this.subparsers_;
    }

    @Override
    public ArgumentGroup addArgumentGroup(String title2) {
        ArgumentGroupImpl group = new ArgumentGroupImpl(this, title2);
        group.setIndex(this.argGroups_.size());
        this.argGroups_.add(group);
        return group;
    }

    @Override
    public MutuallyExclusiveGroup addMutuallyExclusiveGroup() {
        return this.addMutuallyExclusiveGroup("");
    }

    @Override
    public MutuallyExclusiveGroup addMutuallyExclusiveGroup(String title2) {
        ArgumentGroupImpl group = new ArgumentGroupImpl(this, title2);
        group.setIndex(this.argGroups_.size());
        group.setMutex(true);
        this.argGroups_.add(group);
        return group;
    }

    @Override
    public ArgumentParserImpl usage(String usage) {
        this.usage_ = TextHelper.nonNull(usage);
        return this;
    }

    @Override
    public ArgumentParserImpl description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    @Override
    public ArgumentParserImpl epilog(String epilog) {
        this.epilog_ = TextHelper.nonNull(epilog);
        return this;
    }

    @Override
    public ArgumentParserImpl version(String version) {
        this.version_ = TextHelper.nonNull(version);
        return this;
    }

    @Override
    public ArgumentParserImpl defaultHelp(boolean defaultHelp) {
        this.defaultHelp_ = defaultHelp;
        return this;
    }

    boolean isDefaultHelp() {
        return this.defaultHelp_;
    }

    private void printArgumentHelp(PrintWriter writer2, List<ArgumentImpl> args, int format_width) {
        for (ArgumentImpl arg : args) {
            if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isSeparateHelp()) continue;
            arg.printHelp(writer2, this.defaultHelp_, this.config_.textWidthCounter_, format_width);
        }
    }

    @Override
    public void printHelp() {
        PrintWriter writer2 = new PrintWriter(System.out);
        this.printHelp(writer2);
        writer2.flush();
    }

    @Override
    public void printHelp(PrintWriter writer2) {
        int formatWidth = this.config_.formatWidth_;
        this.printUsage(writer2, formatWidth);
        if (!this.description_.isEmpty()) {
            writer2.println();
            writer2.println(TextHelper.wrap(this.config_.textWidthCounter_, this.description_, formatWidth, 0, "", ""));
        }
        boolean subparsersUntitled = this.subparsers_.getTitle().isEmpty() && this.subparsers_.getDescription().isEmpty();
        boolean hasSubCommand = this.subparsers_.hasNotSuppressedSubCommand();
        if (this.checkDefaultGroup(this.posArgs_) || hasSubCommand && subparsersUntitled) {
            writer2.println();
            writer2.println(this.localize("positional.arguments"));
            this.printArgumentHelp(writer2, this.posArgs_, formatWidth);
            if (hasSubCommand && subparsersUntitled) {
                this.subparsers_.printSubparserHelp(writer2, formatWidth);
            }
        }
        if (this.checkDefaultGroup(this.namedArgs_)) {
            writer2.println();
            writer2.println(this.localize("named.arguments"));
            this.printArgumentHelp(writer2, this.namedArgs_, formatWidth);
        }
        if (hasSubCommand && !subparsersUntitled) {
            writer2.println();
            writer2.print(this.subparsers_.getTitle().isEmpty() ? this.localize("sub-commands") : this.subparsers_.getTitle());
            writer2.println(":");
            if (!this.subparsers_.getDescription().isEmpty()) {
                writer2.print("  ");
                writer2.println(TextHelper.wrap(this.config_.textWidthCounter_, this.subparsers_.getDescription(), formatWidth, 2, "", "  "));
                writer2.println();
            }
            this.subparsers_.printSubparserHelp(writer2, formatWidth);
        }
        for (ArgumentGroupImpl group : this.argGroups_) {
            if (!group.isSeparateHelp()) continue;
            writer2.println();
            group.printHelp(writer2, formatWidth);
        }
        if (!this.epilog_.isEmpty()) {
            writer2.println();
            writer2.println(TextHelper.wrap(this.config_.textWidthCounter_, this.epilog_, formatWidth, 0, "", ""));
        }
    }

    private boolean checkDefaultGroup(List<ArgumentImpl> args) {
        if (args.isEmpty()) {
            return false;
        }
        for (ArgumentImpl arg : args) {
            if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isSeparateHelp()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String formatHelp() {
        StringWriter writer2 = new StringWriter();
        this.printHelp(new PrintWriter(writer2));
        return writer2.toString();
    }

    private void printArgumentUsage(PrintWriter writer2, List<String> opts, int offset, String firstIndent, String subsequentIndent, int format_width) {
        int currentWidth = offset + firstIndent.length();
        writer2.print(firstIndent);
        boolean first2 = true;
        for (String syntax : opts) {
            if (!first2 && currentWidth + syntax.length() + 1 > format_width) {
                writer2.println();
                writer2.print(subsequentIndent);
                writer2.print(" ");
                writer2.print(syntax);
                currentWidth = subsequentIndent.length() + 1 + syntax.length();
                continue;
            }
            writer2.print(" ");
            writer2.print(syntax);
            currentWidth += 1 + syntax.length();
            first2 = false;
        }
        writer2.println();
    }

    @Override
    public void printUsage() {
        PrintWriter writer2 = new PrintWriter(System.out);
        this.printUsage(writer2);
        writer2.flush();
    }

    @Override
    public void printUsage(PrintWriter writer2) {
        this.printUsage(writer2, this.config_.formatWidth_);
    }

    private void printUsage(PrintWriter writer2, int format_width) {
        String firstIndent;
        String subsequentIndent;
        int offset;
        if (!this.usage_.isEmpty()) {
            writer2.print(this.localize("usage") + " ");
            writer2.println(this.substitutePlaceholder(this.usage_));
            return;
        }
        String usageProg = this.localize("usage") + " " + this.config_.prog_;
        writer2.print(usageProg);
        String indent = "                              ";
        int usageProgWidth = this.config_.textWidthCounter_.width(usageProg);
        if (usageProgWidth > indent.length()) {
            writer2.println();
            offset = 6;
            firstIndent = subsequentIndent = indent.substring(0, offset);
        } else {
            offset = usageProgWidth;
            firstIndent = "";
            subsequentIndent = indent.substring(0, offset);
        }
        ArrayList<String> opts = new ArrayList<String>();
        this.addUpperParserUsage(opts, this.mainParser_);
        if (this.command_ != null) {
            opts.add(this.command_);
        }
        for (ArgumentImpl arg : this.namedArgs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS || arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) continue;
            opts.add(arg.formatShortSyntax());
        }
        for (ArgumentGroupImpl group : this.argGroups_) {
            List<ArgumentImpl> args = ArgumentParserImpl.filterSuppressedArgs(group.getArgs());
            int numArgs = args.size();
            if (!group.isMutex()) continue;
            if (numArgs > 1) {
                opts.add((group.isRequired() ? "(" : "[") + args.get(0).formatShortSyntaxNoBracket());
                for (int i2 = 1; i2 < numArgs - 1; ++i2) {
                    ArgumentImpl arg = args.get(i2);
                    opts.add("|");
                    opts.add(arg.formatShortSyntaxNoBracket());
                }
                opts.add("|");
                opts.add(args.get(numArgs - 1).formatShortSyntaxNoBracket() + (group.isRequired() ? ")" : "]"));
                continue;
            }
            if (numArgs != 1) continue;
            if (group.isRequired()) {
                opts.add(args.get(0).formatShortSyntaxNoBracket());
                continue;
            }
            opts.add(args.get(0).formatShortSyntax());
        }
        for (ArgumentImpl arg : this.posArgs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            opts.add(arg.formatShortSyntax());
        }
        if (this.subparsers_.hasNotSuppressedSubCommand()) {
            opts.add(this.subparsers_.formatShortSyntax());
            opts.add("...");
        }
        this.printArgumentUsage(writer2, opts, offset, firstIndent, subsequentIndent, format_width);
    }

    private static List<ArgumentImpl> filterSuppressedArgs(Collection<ArgumentImpl> args) {
        ArrayList<ArgumentImpl> res = new ArrayList<ArgumentImpl>();
        for (ArgumentImpl arg : args) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            res.add(arg);
        }
        return res;
    }

    private void addUpperParserUsage(List<String> opts, ArgumentParserImpl parser) {
        if (parser == null) {
            return;
        }
        this.addUpperParserUsage(opts, parser.mainParser_);
        if (parser.command_ != null) {
            opts.add(parser.command_);
        }
        for (ArgumentImpl arg : parser.namedArgs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS || !arg.isRequired() || arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) continue;
            opts.add(arg.formatShortSyntax());
        }
        for (ArgumentGroupImpl group : parser.argGroups_) {
            List<ArgumentImpl> args = ArgumentParserImpl.filterSuppressedArgs(group.getArgs());
            int numArgs = args.size();
            if (!group.isMutex()) continue;
            if (numArgs > 1) {
                if (!group.isRequired()) continue;
                opts.add("(" + args.get(0).formatShortSyntaxNoBracket());
                for (int i2 = 1; i2 < numArgs - 1; ++i2) {
                    ArgumentImpl arg = args.get(i2);
                    opts.add("|");
                    opts.add(arg.formatShortSyntaxNoBracket());
                }
                opts.add("|");
                opts.add(args.get(numArgs - 1).formatShortSyntaxNoBracket() + ")");
                continue;
            }
            if (numArgs != 1) continue;
            if (group.isRequired()) {
                opts.add(args.get(0).formatShortSyntaxNoBracket());
                continue;
            }
            if (!args.get(0).isRequired()) continue;
            opts.add(args.get(0).formatShortSyntax());
        }
        for (ArgumentImpl arg : parser.posArgs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            opts.add(arg.formatShortSyntax());
        }
    }

    @Override
    public String formatUsage() {
        StringWriter writer2 = new StringWriter();
        this.printUsage(new PrintWriter(writer2));
        return writer2.toString();
    }

    @Override
    public ArgumentParserImpl setDefault(String dest, Object value) {
        this.defaults_.put(dest, value);
        return this;
    }

    @Override
    public ArgumentParserImpl setDefaults(Map<String, Object> attrs) {
        this.defaults_.putAll(attrs);
        return this;
    }

    @Override
    public Object getDefault(String dest) {
        for (ArgumentImpl arg : this.namedArgs_) {
            if (!dest.equals(arg.getDest()) || arg.getDefault() == null) continue;
            return arg.getDefault();
        }
        for (ArgumentImpl arg : this.posArgs_) {
            if (!dest.equals(arg.getDest()) || arg.getDefault() == null) continue;
            return arg.getDefault();
        }
        return this.defaults_.get(dest);
    }

    @Override
    public Namespace parseArgsOrFail(String[] args) {
        try {
            return this.parseArgs(args);
        }
        catch (HelpScreenException e) {
            this.handleError(e);
            System.exit(0);
        }
        catch (ArgumentParserException e) {
            this.handleError(e);
            System.exit(1);
        }
        return null;
    }

    @Override
    public Namespace parseKnownArgsOrFail(String[] args, List<String> unknown) {
        try {
            return this.parseKnownArgs(args, unknown);
        }
        catch (HelpScreenException e) {
            this.handleError(e);
            System.exit(0);
        }
        catch (ArgumentParserException e) {
            this.handleError(e);
            System.exit(1);
        }
        return null;
    }

    @Override
    public Namespace parseArgs(String[] args) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseArgs(args, attrs);
        return new Namespace(attrs);
    }

    @Override
    public Namespace parseKnownArgs(String[] args, List<String> unknown) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseKnownArgs(args, unknown, attrs);
        return new Namespace(attrs);
    }

    @Override
    public void parseArgs(String[] args, Map<String, Object> attrs) throws ArgumentParserException {
        this.parseArgsAtOffsetZero(args, null, attrs);
    }

    @Override
    public void parseKnownArgs(String[] args, List<String> unknown, Map<String, Object> attrs) throws ArgumentParserException {
        this.parseKnownArgsCreatingUnknownIfNeeded(args, unknown, attrs);
    }

    @Override
    public void parseArgs(String[] args, Object userData) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseArgs(args, attrs, userData);
    }

    @Override
    public void parseKnownArgs(String[] args, List<String> unknown, Object userData) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseKnownArgs(args, unknown, attrs, userData);
    }

    @Override
    public void parseArgs(String[] args, Map<String, Object> attrs, Object userData) throws ArgumentParserException {
        this.parseArgsAtOffsetZero(args, null, attrs);
        this.fillUserDataFromAttrs(userData, attrs);
    }

    @Override
    public void parseKnownArgs(String[] args, List<String> unknown, Map<String, Object> attrs, Object userData) throws ArgumentParserException {
        this.parseKnownArgsCreatingUnknownIfNeeded(args, unknown, attrs);
        this.fillUserDataFromAttrs(userData, attrs);
    }

    private void fillUserDataFromAttrs(Object userData, Map<String, Object> attrs) {
        for (Class<?> userClass = userData.getClass(); userClass != null; userClass = userClass.getSuperclass()) {
            Object val;
            String argDest;
            Arg ann;
            for (Field field : userClass.getDeclaredFields()) {
                ann = field.getAnnotation(Arg.class);
                if (ann == null) continue;
                argDest = ann.dest();
                if (argDest.isEmpty()) {
                    argDest = field.getName();
                }
                if (!attrs.containsKey(argDest)) continue;
                val = attrs.get(argDest);
                try {
                    AccessController.doPrivileged(() -> {
                        field.setAccessible(true);
                        return null;
                    });
                    field.set(userData, ReflectHelper.list2Array(field.getType(), val));
                }
                catch (RuntimeException e) {
                    if (ann.ignoreError()) continue;
                    throw e;
                }
                catch (Exception e) {
                    if (ann.ignoreError()) continue;
                    throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "Could not set %s to field %s", val, field.getName()), e);
                }
            }
            for (AccessibleObject accessibleObject : userClass.getDeclaredMethods()) {
                ann = ((Method)accessibleObject).getAnnotation(Arg.class);
                if (ann == null) continue;
                argDest = ann.dest();
                if (argDest.isEmpty()) {
                    argDest = ((Method)accessibleObject).getName();
                }
                if (!attrs.containsKey(argDest)) continue;
                val = attrs.get(argDest);
                Class<?>[] fargs = ((Method)accessibleObject).getParameterTypes();
                if (fargs.length != 1) {
                    throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "Method %s must have one formal parameter", ((Method)accessibleObject).getName()));
                }
                try {
                    AccessController.doPrivileged(() -> ArgumentParserImpl.lambda$fillUserDataFromAttrs$1((Method)accessibleObject));
                    ((Method)accessibleObject).invoke(userData, ReflectHelper.list2Array(fargs[0], val));
                }
                catch (RuntimeException e) {
                    if (ann.ignoreError()) continue;
                    throw e;
                }
                catch (Exception e) {
                    if (ann.ignoreError()) continue;
                    throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "Could not call method %s with %s", ((Method)accessibleObject).getName(), val), e);
                }
            }
        }
    }

    private void parseKnownArgsCreatingUnknownIfNeeded(String[] args, List<String> unknown, Map<String, Object> attrs) throws ArgumentParserException {
        if (unknown == null) {
            unknown = new ArrayList<String>();
        }
        this.parseArgsAtOffsetZero(args, unknown, attrs);
    }

    private void parseArgsAtOffsetZero(String[] args, List<String> unknown, Map<String, Object> attrs) throws ArgumentParserException {
        ParseState state2 = new ParseState(args, this.negNumFlag_, unknown);
        this.parseArgs(state2, attrs);
        if (state2.deferredException != null) {
            throw state2.deferredException;
        }
    }

    private boolean checkConcatenatedShortOpts(String term) {
        if (SHORT_OPTS_PATTERN.matcher(term).matches()) {
            int termLen = term.length();
            for (int i2 = 1; i2 < termLen; ++i2) {
                String shortFlag = "-" + term.charAt(i2);
                ArgumentImpl arg = this.namedArgIndex_.get(shortFlag);
                if (arg == null) {
                    return false;
                }
                if (!arg.getAction().consumeArgument()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private ArgumentImpl resolveNextFlag(String flag) throws ArgumentParserException {
        ArgumentImpl arg = this.namedArgIndex_.get(flag);
        if (arg != null) {
            return arg;
        }
        List<String> cand = TextHelper.findPrefix(this.namedArgIndex_.keySet(), flag);
        if (cand.isEmpty()) {
            return null;
        }
        if (this.checkConcatenatedShortOpts(flag)) {
            cand.add(flag.substring(0, 2));
        } else if (cand.size() == 1) {
            return this.namedArgIndex_.get(cand.get(0));
        }
        Collections.sort(cand);
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("ambiguousOptionError"), flag, TextHelper.concat(cand, 0, ", ")), (ArgumentParser)this);
    }

    void parseArgs(ParseState state2, Map<String, Object> attrs) throws ArgumentParserException {
        this.populateDefaults(attrs);
        HashSet<ArgumentImpl> used = new HashSet<ArgumentImpl>();
        ArgumentImpl[] groupUsed = new ArgumentImpl[this.argGroups_.size()];
        int posArgsLen = this.posArgs_.size();
        while (state2.isArgAvail()) {
            if (this.flagFound(state2) && !"--".equals(state2.getArg())) {
                String embeddedValue;
                String flag;
                String term = state2.getArg();
                int p2 = term.indexOf("=");
                if (p2 == -1) {
                    flag = term;
                    embeddedValue = null;
                } else {
                    flag = term.substring(0, p2);
                    embeddedValue = term.substring(p2 + 1);
                }
                ArgumentImpl arg = this.resolveNextFlag(flag);
                if (arg == null) {
                    embeddedValue = null;
                    boolean shortOptsFound = false;
                    int unknownStart = -1;
                    if (this.config_.prefixPattern_.matchShortFlag(term)) {
                        shortOptsFound = true;
                        int termLen = term.length();
                        for (int i2 = 1; i2 < termLen; ++i2) {
                            String shortFlag = term.substring(0, 1) + term.charAt(i2);
                            arg = this.namedArgIndex_.get(shortFlag);
                            if (arg == null) {
                                shortOptsFound = false;
                                unknownStart = i2;
                                break;
                            }
                            if (arg.getAction().consumeArgument()) {
                                flag = shortFlag;
                                shortOptsFound = true;
                                if (term.length() <= i2 + 1) break;
                                embeddedValue = term.substring(i2 + 1);
                                break;
                            }
                            this.checkMutex(arg, groupUsed);
                            ArgumentImpl finalArg = arg;
                            arg.run(this, attrs, shortFlag, null, value -> this.addArgValue(attrs, finalArg, value));
                            used.add(arg);
                            arg = null;
                        }
                    }
                    if (!shortOptsFound) {
                        if (state2.unknown == null) {
                            throw new UnrecognizedArgumentException(this.formatUnrecognizedArgumentErrorMessage(state2, term), (ArgumentParser)this, term);
                        }
                        state2.unknown.add(unknownStart == -1 ? term : term.charAt(0) + term.substring(unknownStart));
                    }
                }
                ++state2.index;
                if (arg == null) continue;
                this.checkMutex(arg, groupUsed);
                this.processArg(attrs, state2, arg, flag, embeddedValue);
                used.add(arg);
                continue;
            }
            if ("--".equals(state2.getArg()) && !state2.consumedSeparator) {
                state2.consumedSeparator = true;
                state2.negNumFlag = false;
                ++state2.index;
                continue;
            }
            if (state2.posArgIndex < posArgsLen) {
                ArgumentImpl arg = this.posArgs_.get(state2.posArgIndex);
                this.accumulatePositionalArg(state2, arg);
                continue;
            }
            if (!state2.consumedSeparator && this.subparsers_.hasSubCommand()) {
                this.processPositionalArgs(attrs, state2);
                this.checkRequiredArgument(state2, used);
                this.checkRequiredMutex(state2, groupUsed);
                state2.resetPosArgs();
                this.subparsers_.parseArg(state2, attrs);
                return;
            }
            if (state2.unknown == null) {
                throw new ArgumentParserException(this.formatUnrecognizedArgumentErrorMessage(state2, TextHelper.concat(state2.args, state2.index, " ")), (ArgumentParser)this);
            }
            state2.unknown.add(state2.getArg());
            ++state2.index;
        }
        if (this.subparsers_.hasSubCommand()) {
            throw new ArgumentParserException(this.localize("tooFewArgumentsError"), (ArgumentParser)this);
        }
        this.processPositionalArgs(attrs, state2);
        this.checkRequiredArgument(state2, used);
        this.checkRequiredMutex(state2, groupUsed);
    }

    private String formatUnrecognizedArgumentErrorMessage(ParseState state2, String args) {
        return String.format(TextHelper.LOCALE_ROOT, this.localize("unrecognizedArgumentsError"), args, state2.index > state2.lastFromFileArgIndex ? "" : String.format(TextHelper.LOCALE_ROOT, this.localize("trailingWhiteSpacesInFileTip"), this.config_.fromFilePrefixPattern_.getPrefixChars().length() == 1 ? this.config_.fromFilePrefixPattern_.getPrefixChars() : "[" + this.config_.fromFilePrefixPattern_.getPrefixChars() + "]"));
    }

    private void checkMutex(ArgumentImpl arg, ArgumentImpl[] groupUsed) throws ArgumentParserException {
        if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) {
            ArgumentImpl usedMutexArg = groupUsed[arg.getArgumentGroup().getIndex()];
            if (usedMutexArg == null) {
                groupUsed[arg.getArgumentGroup().getIndex()] = arg;
            } else if (usedMutexArg != arg) {
                throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("notAllowedWithArgumentError"), usedMutexArg.textualName()), this, arg);
            }
        }
    }

    private void processArg(Map<String, Object> res, ParseState state2, ArgumentImpl arg, String flag, String embeddedValue) throws ArgumentParserException {
        if (!arg.getAction().consumeArgument()) {
            if (embeddedValue == null) {
                arg.run(this, res, flag, null, value -> this.addArgValue(res, arg, value));
                return;
            }
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("ignoreImplicitArgumentError"), embeddedValue), this, arg);
        }
        if (arg.getMinNumArg() == -1 || arg.getMinNumArg() == 0 && arg.getMaxNumArg() == 1) {
            String argVal = null;
            if (embeddedValue == null) {
                if (state2.isArgAvail() && !this.flagFound(state2)) {
                    argVal = state2.getArg();
                    ++state2.index;
                }
            } else {
                argVal = embeddedValue;
            }
            if (argVal == null) {
                if (arg.getMinNumArg() == -1) {
                    throw new ArgumentParserException(this.localize("expectedOneArgumentError"), this, arg);
                }
                arg.run(this, res, flag, arg.getConst(), value -> this.addArgValue(res, arg, value));
            } else {
                arg.run(this, res, flag, arg.convert(this, argVal), value -> this.addArgValue(res, arg, value));
            }
            return;
        }
        ArrayList<Object> list2 = new ArrayList<Object>();
        if (embeddedValue == null) {
            int i2 = 0;
            while (i2 < arg.getMaxNumArg() && state2.isArgAvail() && !this.flagFound(state2)) {
                list2.add(arg.convert(this, state2.getArg()));
                ++i2;
                ++state2.index;
            }
        } else {
            list2.add(arg.convert(this, embeddedValue));
        }
        if (list2.size() < arg.getMinNumArg()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("expectedNArgumentsError"), arg.getMinNumArg()), this, arg);
        }
        arg.run(this, res, flag, list2, value -> this.addArgValue(res, arg, value));
    }

    private void accumulatePositionalArg(ParseState state2, ArgumentImpl arg) throws ArgumentParserException {
        if (!arg.getAction().consumeArgument()) {
            ++state2.posArgIndex;
            return;
        }
        if (arg.getMinNumArg() == -1 || arg.getMinNumArg() == 0 && arg.getMaxNumArg() == 1) {
            state2.posArgArgs.add(state2.getArg());
            ++state2.index;
            ++state2.posArgIndex;
            return;
        }
        while (state2.posArgConsumed < arg.getMaxNumArg() && state2.isArgAvail() && !this.flagFound(state2)) {
            state2.posArgArgs.add(state2.getArg());
            ++state2.posArgConsumed;
            ++state2.index;
        }
        if (state2.posArgConsumed == arg.getMaxNumArg()) {
            ++state2.posArgIndex;
            state2.posArgConsumed = 0;
        }
    }

    private void processPositionalArgs(Map<String, Object> res, ParseState state2) throws ArgumentParserException {
        int i2;
        int[] mustLeft = new int[this.posArgs_.size() + 1];
        for (i2 = 0; i2 < this.posArgs_.size(); ++i2) {
            ArgumentImpl arg = this.posArgs_.get(i2);
            mustLeft[i2] = !arg.getAction().consumeArgument() ? 0 : (arg.getMinNumArg() == -1 ? 1 : arg.getMinNumArg());
        }
        mustLeft[this.posArgs_.size()] = 0;
        for (i2 = this.posArgs_.size() - 1; i2 >= 0; --i2) {
            int n = i2;
            mustLeft[n] = mustLeft[n] + mustLeft[i2 + 1];
        }
        if (mustLeft[0] > state2.posArgArgs.size()) {
            throw new ArgumentParserException(this.localize("tooFewArgumentsError"), (ArgumentParser)this);
        }
        int argIndex = 0;
        for (int i3 = 0; i3 < this.posArgs_.size(); ++i3) {
            ArgumentImpl arg = this.posArgs_.get(i3);
            if (!arg.getAction().consumeArgument()) {
                arg.run(this, res, null, null, value -> this.addArgValue(res, arg, value));
                continue;
            }
            if (arg.getMinNumArg() == -1) {
                arg.run(this, res, null, arg.convert(this, state2.posArgArgs.get(argIndex++)), value -> this.addArgValue(res, arg, value));
                continue;
            }
            if (arg.getMinNumArg() == 0 && arg.getMaxNumArg() == 1) {
                if (mustLeft[i3 + 1] == state2.posArgArgs.size() - argIndex) continue;
                arg.run(this, res, null, arg.convert(this, state2.posArgArgs.get(argIndex++)), value -> this.addArgValue(res, arg, value));
                continue;
            }
            int n = Math.min(arg.getMaxNumArg(), state2.posArgArgs.size() - argIndex - mustLeft[i3 + 1]);
            if (n == 0) continue;
            ArrayList<Object> list2 = new ArrayList<Object>(n);
            while (n > 0) {
                list2.add(arg.convert(this, state2.posArgArgs.get(argIndex++)));
                --n;
            }
            arg.run(this, res, null, list2, value -> this.addArgValue(res, arg, value));
        }
    }

    private boolean flagFound(ParseState state2) throws ArgumentParserException {
        while (this.fromFileFound(state2)) {
            this.extendArgs(state2, this.config_.fromFilePrefixPattern_.removePrefix(state2.getArg()));
        }
        String term = state2.getArg();
        if (state2.consumedSeparator) {
            return false;
        }
        if ("--".equals(term)) {
            return true;
        }
        return this.config_.prefixPattern_.match(term) && (state2.negNumFlag || !NEG_NUM_PATTERN.matcher(term).matches());
    }

    private boolean fromFileFound(ParseState state2) {
        return this.config_.fromFilePrefixPattern_ != null && this.config_.fromFilePrefixPattern_.match(state2.getArg());
    }

    private void extendArgs(ParseState state2, String file2) throws ArgumentParserException {
        ArrayList<String> list2 = new ArrayList<String>();
        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader2.readLine()) != null) {
                list2.add(line);
            }
        }
        catch (IOException e) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("couldNotReadFromFileError"), file2), e, this);
        }
        int offset = state2.index + 1;
        String[] newArgs = new String[list2.size() + state2.args.length - offset];
        list2.toArray(newArgs);
        System.arraycopy(state2.args, offset, newArgs, list2.size(), state2.args.length - offset);
        state2.lastFromFileArgIndex = state2.lastFromFileArgIndex < offset ? list2.size() - 1 : (state2.lastFromFileArgIndex += -offset + list2.size());
        state2.resetArgs(newArgs);
    }

    private void checkRequiredArgument(ParseState state2, Set<ArgumentImpl> used) {
        if (state2.deferredException != null) {
            return;
        }
        for (ArgumentImpl arg : this.namedArgs_) {
            if (!arg.isRequired() || used.contains(arg)) continue;
            state2.deferredException = new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("argumentIsRequiredError"), arg.textualName()), (ArgumentParser)this);
        }
    }

    private void checkRequiredMutex(ParseState state2, ArgumentImpl[] used) {
        if (state2.deferredException != null) {
            return;
        }
        for (int i2 = 0; i2 < this.argGroups_.size(); ++i2) {
            ArgumentGroupImpl group = this.argGroups_.get(i2);
            if (!group.isMutex() || !group.isRequired() || used[i2] != null) continue;
            StringBuilder sb = new StringBuilder();
            for (ArgumentImpl arg : group.getArgs()) {
                if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
                sb.append(arg.textualName()).append(" ");
            }
            state2.deferredException = new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("oneOfTheArgumentsIsRequiredError"), sb.toString()), (ArgumentParser)this);
        }
    }

    private void populateDefaults(Map<String, Object> opts) {
        for (ArgumentImpl argumentImpl : this.posArgs_) {
            this.addArgDefaultIfNotSuppressed(opts, argumentImpl);
        }
        for (ArgumentImpl argumentImpl : this.namedArgs_) {
            this.addArgDefaultIfNotSuppressed(opts, argumentImpl);
        }
        for (Map.Entry entry : this.defaults_.entrySet()) {
            opts.put((String)entry.getKey(), entry.getValue());
        }
    }

    private void addArgDefaultIfNotSuppressed(Map<String, Object> opts, ArgumentImpl arg) {
        if (arg.getDefaultControl() != Arguments.SUPPRESS) {
            this.addArgValue(opts, arg, arg.getDefault());
        }
    }

    private void addArgValue(Map<String, Object> opts, ArgumentImpl arg, Object value) {
        opts.put(arg.getDest(), value);
        if (this.config_.includeArgumentNamesAsKeysInResult_) {
            opts.put(this.getActualArgumentName(arg), value);
        }
    }

    private String getActualArgumentName(ArgumentImpl arg) {
        return arg.getName() == null ? this.removePrefix(arg.getPrimaryFlag()) : arg.getName();
    }

    private String removePrefix(String flag) {
        return this.config_.prefixPattern_.removePrefix(flag);
    }

    @Override
    public ArgumentParserConfigurationImpl getConfig() {
        return this.config_;
    }

    public String getProg() {
        return this.config_.prog_;
    }

    @Override
    public void printVersion() {
        PrintWriter writer2 = new PrintWriter(System.out);
        this.printVersion(writer2);
        writer2.flush();
    }

    @Override
    public void printVersion(PrintWriter writer2) {
        writer2.println(this.formatVersion());
    }

    @Override
    public String formatVersion() {
        return this.substitutePlaceholder(this.version_);
    }

    @Override
    public void handleError(ArgumentParserException e) {
        this.handleError(e, new PrintWriter(System.err));
    }

    @Override
    public void handleError(ArgumentParserException e, PrintWriter writer2) {
        if (e.getParser() != this) {
            e.getParser().handleError(e, writer2);
            return;
        }
        if (e instanceof HelpScreenException) {
            return;
        }
        this.printUsage(writer2);
        writer2.write(TextHelper.wrap(this.config_.textWidthCounter_, String.format(TextHelper.LOCALE_ROOT, this.localize("errorLine"), this.config_.prog_, e.getMessage()), this.config_.formatWidth_, 0, "", ""));
        if (e instanceof UnrecognizedArgumentException) {
            String flagBody;
            UnrecognizedArgumentException ex = (UnrecognizedArgumentException)e;
            String argument = ex.getArgument();
            if (this.config_.prefixPattern_.match(argument) && (flagBody = this.config_.prefixPattern_.removePrefix(argument)).length() >= 2) {
                this.printFlagCandidates(flagBody, writer2);
            }
        } else if (e instanceof UnrecognizedCommandException) {
            UnrecognizedCommandException ex = (UnrecognizedCommandException)e;
            String command2 = ex.getCommand();
            this.printCommandCandidates(command2, writer2);
        }
        writer2.flush();
    }

    private int levenshtein(String a2, String b2) {
        int i2;
        int aLen = a2.length();
        int bLen = b2.length();
        int[][] dp = new int[3][bLen + 1];
        for (i2 = 0; i2 <= bLen; ++i2) {
            dp[1][i2] = i2;
        }
        for (i2 = 1; i2 <= aLen; ++i2) {
            dp[0][0] = i2;
            for (int j = 1; j <= bLen; ++j) {
                dp[0][j] = dp[1][j - 1] + (a2.charAt(i2 - 1) == b2.charAt(j - 1) ? 0 : 2);
                if (i2 >= 2 && j >= 2 && a2.charAt(i2 - 1) != b2.charAt(j - 1) && a2.charAt(i2 - 2) == b2.charAt(j - 1) && a2.charAt(i2 - 1) == b2.charAt(j - 2)) {
                    dp[0][j] = Math.min(dp[0][j], dp[2][j - 2] + 0);
                }
                dp[0][j] = Math.min(dp[0][j], Math.min(dp[1][j] + 4, dp[0][j - 1] + 1));
            }
            int[] temp = dp[2];
            dp[2] = dp[1];
            dp[1] = dp[0];
            dp[0] = temp;
        }
        return dp[1][bLen];
    }

    private void printFlagCandidates(String flagBody, PrintWriter writer2) {
        ArrayList<SubjectBody> subjects = new ArrayList<SubjectBody>();
        for (ArgumentImpl arg : this.namedArgs_) {
            String[] flags;
            for (String flag : flags = arg.getFlags()) {
                String body2 = this.config_.prefixPattern_.removePrefix(flag);
                if (body2.length() <= 1) continue;
                subjects.add(new SubjectBody(flag, body2));
            }
        }
        this.printCandidates(flagBody, subjects, writer2);
    }

    private void printCommandCandidates(String command2, PrintWriter writer2) {
        ArrayList<SubjectBody> subjects = new ArrayList<SubjectBody>();
        for (String com : this.subparsers_.getCommands()) {
            subjects.add(new SubjectBody(com, com));
        }
        this.printCandidates(command2, subjects, writer2);
    }

    private void printCandidates(String body2, List<SubjectBody> subjects, PrintWriter writer2) {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (SubjectBody sub2 : subjects) {
            if (sub2.body.startsWith(body2)) {
                candidates.add(new Candidate(0, sub2.subject));
                continue;
            }
            candidates.add(new Candidate(this.levenshtein(body2, sub2.body), sub2.subject));
        }
        if (candidates.isEmpty()) {
            return;
        }
        Collections.sort(candidates);
        int threshold = ((Candidate)candidates.get((int)0)).similarity;
        if (threshold >= 7) {
            return;
        }
        writer2.println();
        writer2.println(this.localize("didYouMean"));
        for (Candidate candidate : candidates) {
            if (candidate.similarity > threshold) break;
            writer2.print("\t");
            writer2.println(candidate.subject);
        }
    }

    private String substitutePlaceholder(String src) {
        return src.replaceAll(Pattern.quote("${prog}"), this.config_.prog_);
    }

    public String getCommand() {
        return this.command_;
    }

    TextWidthCounter getTextWidthCounter() {
        return this.config_.textWidthCounter_;
    }

    public String getPrefixChars() {
        return this.config_.prefixPattern_.getPrefixChars();
    }

    public String getFromFilePrefixChars() {
        return this.config_.fromFilePrefixPattern_ == null ? null : this.config_.fromFilePrefixPattern_.getPrefixChars();
    }

    ArgumentParserImpl getMainParser() {
        return this.mainParser_;
    }

    String localize(String messageKey) {
        return MessageLocalization.localize(this.config_.getResourceBundle(), messageKey);
    }

    private static /* synthetic */ Void lambda$fillUserDataFromAttrs$1(Method method) {
        method.setAccessible(true);
        return null;
    }

    public static class Candidate
    implements Comparable<Candidate> {
        int similarity;
        public String subject;

        Candidate(int similarity, String subject) {
            this.similarity = similarity;
            this.subject = subject;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Candidate other = (Candidate)obj;
            if (this.subject == null) {
                if (other.subject != null) {
                    return false;
                }
            } else {
                if (other.subject == null) {
                    return false;
                }
                if (!this.subject.equals(other.subject)) {
                    return false;
                }
            }
            return this.similarity == other.similarity;
        }

        public int hashCode() {
            int prime = 31;
            int hash = 1;
            hash = hash * prime + (this.subject == null ? 0 : this.subject.hashCode());
            hash = hash * prime + this.similarity;
            return hash;
        }

        @Override
        public int compareTo(Candidate rhs) {
            if (this.similarity < rhs.similarity) {
                return -1;
            }
            if (this.similarity == rhs.similarity) {
                return this.subject.compareTo(rhs.subject);
            }
            return 1;
        }
    }

    private static class SubjectBody {
        public String subject;
        String body;

        SubjectBody(String subject, String body2) {
            this.subject = subject;
            this.body = body2;
        }
    }
}

