/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CertPathDeserializer
extends StdDeserializer<CertPath> {
    public CertPathDeserializer() {
        super(CertPath.class);
    }

    @Override
    @NotNull
    public CertPath deserialize(@NotNull JsonParser p2, @NotNull DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = p2.getCodec();
        ArrayNode node2 = (ArrayNode)oc.readTree(p2);
        ArrayList<X509Certificate> list2 = new ArrayList<X509Certificate>();
        for (JsonNode item2 : node2) {
            X509Certificate certificate = oc.treeToValue(item2, X509Certificate.class);
            list2.add(certificate);
        }
        return CertificateUtil.generateCertPath(list2);
    }
}

