/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.Setup;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/skiko/Library;", "", "()V", "copyDir", "Ljava/io/File;", "loaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "findAndLoad", "", "load", "loadLibraryOrCopy", "library", "unpackIfNeeded", "dest", "resourceName", "", "deleteOnExit", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Library.kt\norg/jetbrains/skiko/Library\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class Library {
    @NotNull
    public static final Library INSTANCE = new Library();
    @Nullable
    private static File copyDir;
    @NotNull
    private static AtomicBoolean loaded;

    private Library() {
    }

    private final void loadLibraryOrCopy(File library) {
        try {
            System.load(library.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            String string2 = e.getMessage();
            boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, "already loaded in another classloader", false, 2, null) : false;
            if (bl) {
                File file2 = copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull(file2);
                String string3 = library.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                File tempFile = FilesKt.resolve(file2, string3);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(library.toPath(), tempFile.toPath(), copyOptionArray);
                tempFile.deleteOnExit();
                System.load(tempFile.getAbsolutePath());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File unpackIfNeeded(File dest, String resourceName, boolean deleteOnExit) {
        File file2 = new File(dest, resourceName);
        if (!file2.exists()) {
            File tempFile = File.createTempFile("skiko", "", dest);
            if (deleteOnExit) {
                file2.deleteOnExit();
            }
            CopyOption[] copyOptionArray = (CopyOption[])Library.class.getResourceAsStream('/' + resourceName);
            Throwable throwable = null;
            try {
                InputStream input2 = (InputStream)copyOptionArray;
                boolean bl = false;
                CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long l = Files.copy(input2, tempFile.toPath(), copyOptionArray2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)copyOptionArray, throwable);
            }
            copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(tempFile.toPath(), file2.toPath(), copyOptionArray);
        }
        return file2;
    }

    public final synchronized void load() {
        if (!loaded.compareAndSet(false, true)) {
            return;
        }
        this.findAndLoad();
        Setup.init$default(Setup.INSTANCE, false, false, false, false, false, 31, null);
        try {
            org.jetbrains.skia.impl.Library.Companion._nAfterLoad();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findAndLoad() {
        String string2;
        Object it;
        String icu;
        String name = "skiko-" + OsArch_jvmKt.getHostId();
        String platformName = System.mapLibraryName(name);
        String string3 = icu = OsArch_jvmKt.getHostOs().isWindows() ? "icudtl.dat" : null;
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary("skiko-" + OsArch_jvmKt.getHostId());
            return;
        }
        String skikoLibraryPath = SkikoProperties.INSTANCE.getLibraryPath();
        if (skikoLibraryPath != null) {
            File library = new File(new File(skikoLibraryPath), platformName);
            this.loadLibraryOrCopy(library);
            if (icu != null && copyDir != null) {
                File file2 = copyDir;
                Intrinsics.checkNotNull(file2);
                this.unpackIfNeeded(file2, icu, true);
            }
            return;
        }
        File jvmFiles = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNull(platformName);
        File pathInJvm = FilesKt.resolve(jvmFiles, platformName);
        if (pathInJvm.exists()) {
            boolean bl;
            String string4 = icu;
            if (string4 != null) {
                it = string4;
                boolean bl2 = false;
                bl = !FilesKt.resolve(jvmFiles, (String)it).exists();
            } else {
                bl = false;
            }
            if (!bl) {
                this.loadLibraryOrCopy(pathInJvm);
                return;
            }
        }
        if ((it = Library.class.getResourceAsStream('/' + platformName + ".sha256")) == null) {
            throw new LibraryLoadException("Cannot find " + platformName + ".sha256, proper native dependency missing.");
        }
        Object hashResourceStream = it;
        Closeable bl2 = (Closeable)hashResourceStream;
        Throwable throwable = null;
        try {
            InputStream it2 = (InputStream)bl2;
            boolean bl = false;
            InputStream inputStream2 = it2;
            Charset charset = Charsets.UTF_8;
            Reader reader2 = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            string2 = (reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n)).readLine();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(bl2, throwable);
        }
        String hash = string2;
        File dataDir = new File(new File(SkikoProperties.INSTANCE.getDataPath()), hash);
        dataDir.mkdirs();
        File library = this.unpackIfNeeded(dataDir, platformName, false);
        this.loadLibraryOrCopy(library);
        if (icu != null) {
            if (copyDir != null) {
                File file3 = copyDir;
                Intrinsics.checkNotNull(file3);
                this.unpackIfNeeded(file3, icu, true);
            } else {
                this.unpackIfNeeded(dataDir, icu, false);
            }
        }
    }

    static {
        loaded = new AtomicBoolean(false);
    }
}

