/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skia.icu.CharProperties;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u001c\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a \u0010\u0013\u001a\u00060\u0001j\u0002`\u0014*\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u0017*\u00060\u0018j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u001c\u001a\u00020\u0001*\u00060\u0001j\u0002`\u0014H\u0000\u001a\u001e\u0010!\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u00140\u001e*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\"\u001a\u00060\u0001j\u0002`\u0014*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0018\u0010#\u001a\u00060\u0001j\u0002`\u0014*\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\f\u0010$\u001a\u00020\u0001*\u00020\u000bH\u0000\u001a\u0018\u0010%\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0002H\u0000\u001a\u0014\u0010'\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\f\u0010(\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010)\u001a\u00020\u0006*\u00060\u0001j\u0002`\u0014H\u0002\u001a\u0010\u0010*\u001a\u00020\u0006*\u00060\u0001j\u0002`\u0014H\u0002\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\"\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u0001j\u0002`\u00140\u001e*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 *\f\b\u0000\u0010\u0012\"\u00020\u00012\u00020\u0001\u00a8\u0006+"}, d2={"findPrecedingBreak", "", "", "index", "findFollowingBreak", "isSurrogatePair", "", "high", "", "low", "offsetByCodePoints", "", "offset", "findCodePointOrEmojiStartBefore", "ifNotFound", "EMOJI_PRESENTATION_SELECTOR", "canBeEmojiOrPictographic", "text", "CodePoint", "toCodePoint", "Landroidx/compose/foundation/text/CodePoint;", "Lkotlin/Char$Companion;", "appendCodePoint", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "codePoint", "MIN_SUPPLEMENTARY_CODE_POINT", "charCount", "codePoints", "Lkotlin/sequences/Sequence;", "getCodePoints", "(Ljava/lang/String;)Lkotlin/sequences/Sequence;", "codePointsAt", "codePointAt", "codePointBefore", "codePointCount", "findNextNonWhitespaceSymbolsSubsequenceStartOffset", "currentText", "isWhitespaceOrPunctuation", "midpointPositionWithUnicodeSymbols", "isWhitespace", "isPunctuation", "foundation"})
@SourceDebugExtension(value={"SMAP\nStringHelpers.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringHelpers.skiko.kt\nandroidx/compose/foundation/text/StringHelpers_skikoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n1761#2,3:309\n*S KotlinDebug\n*F\n+ 1 StringHelpers.skiko.kt\nandroidx/compose/foundation/text/StringHelpers_skikoKt\n*L\n306#1:309,3\n*E\n"})
public final class StringHelpers_skikoKt {
    private static final int EMOJI_PRESENTATION_SELECTOR = 65039;
    private static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;

    public static final int findPrecedingBreak(@NotNull String $this$findPrecedingBreak, int index2) {
        Intrinsics.checkNotNullParameter($this$findPrecedingBreak, "<this>");
        BreakIterator it = BreakIterator.Companion.makeCharacterInstance$default(BreakIterator.Companion, null, 1, null);
        it.setText($this$findPrecedingBreak);
        return it.preceding(index2);
    }

    public static final int findFollowingBreak(@NotNull String $this$findFollowingBreak, int index2) {
        Intrinsics.checkNotNullParameter($this$findFollowingBreak, "<this>");
        BreakIterator it = BreakIterator.Companion.makeCharacterInstance$default(BreakIterator.Companion, null, 1, null);
        it.setText($this$findFollowingBreak);
        return it.following(index2);
    }

    private static final boolean isSurrogatePair(char high, char low) {
        return Character.isHighSurrogate(high) && Character.isLowSurrogate(low);
    }

    public static final int offsetByCodePoints(@NotNull CharSequence $this$offsetByCodePoints, int index2, int offset) {
        Intrinsics.checkNotNullParameter($this$offsetByCodePoints, "<this>");
        int sign2 = MathKt.getSign(offset);
        int distance = Math.abs(offset);
        int currentOffset = index2;
        for (int i2 = 0; i2 < distance; ++i2) {
            char trail;
            if ((currentOffset += sign2) <= 0) {
                return 0;
            }
            if (currentOffset >= $this$offsetByCodePoints.length()) {
                return $this$offsetByCodePoints.length();
            }
            char lead = $this$offsetByCodePoints.charAt(currentOffset - 1);
            if (!StringHelpers_skikoKt.isSurrogatePair(lead, trail = $this$offsetByCodePoints.charAt(currentOffset))) continue;
            currentOffset += sign2;
        }
        return currentOffset;
    }

    public static final int findCodePointOrEmojiStartBefore(@NotNull String $this$findCodePointOrEmojiStartBefore, int index2, int ifNotFound) {
        int precedingCodePointIndex;
        Intrinsics.checkNotNullParameter($this$findCodePointOrEmojiStartBefore, "<this>");
        if (index2 <= 0) {
            return -1;
        }
        int precedingCharBreakIndex = StringHelpers_skikoKt.findPrecedingBreak($this$findCodePointOrEmojiStartBefore, index2);
        if (precedingCharBreakIndex == (precedingCodePointIndex = StringHelpers_skikoKt.offsetByCodePoints($this$findCodePointOrEmojiStartBefore, index2, -1))) {
            return precedingCodePointIndex;
        }
        String string2 = $this$findCodePointOrEmojiStartBefore.substring(precedingCharBreakIndex, index2);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String substringFromCharBreak = string2;
        return StringHelpers_skikoKt.canBeEmojiOrPictographic(substringFromCharBreak) ? precedingCharBreakIndex : precedingCodePointIndex;
    }

    private static final boolean canBeEmojiOrPictographic(String text) {
        Iterator<Integer> iterator2 = StringHelpers_skikoKt.getCodePoints(text).iterator();
        while (iterator2.hasNext()) {
            int codePoint = ((Number)iterator2.next()).intValue();
            CharProperties $this$canBeEmojiOrPictographic_u24lambda_u240 = CharProperties.INSTANCE;
            boolean bl = false;
            if (!$this$canBeEmojiOrPictographic_u24lambda_u240.codePointHasBinaryProperty(codePoint, 58) && !$this$canBeEmojiOrPictographic_u24lambda_u240.codePointHasBinaryProperty(codePoint, 64) && codePoint != 65039) continue;
            return true;
        }
        return false;
    }

    public static final int toCodePoint(@NotNull CharCompanionObject $this$toCodePoint, char high, char low) {
        Intrinsics.checkNotNullParameter($this$toCodePoint, "<this>");
        return (high - 55296 << 10 | low - 56320) + 65536;
    }

    public static final void appendCodePoint(@NotNull StringBuilder $this$appendCodePoint, int codePoint) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$appendCodePoint, "<this>");
        if (codePoint < 65536) {
            stringBuilder = $this$appendCodePoint.append((char)codePoint);
        } else {
            $this$appendCodePoint.append((char)(55296 + (codePoint - 65536 >> 10)));
            stringBuilder = $this$appendCodePoint.append((char)(56320 + (codePoint & 0x3FF)));
        }
    }

    public static final int charCount(int $this$charCount) {
        return $this$charCount >= 65536 ? 2 : 1;
    }

    @NotNull
    public static final Sequence<Integer> getCodePoints(@NotNull String $this$codePoints) {
        Intrinsics.checkNotNullParameter($this$codePoints, "<this>");
        return StringHelpers_skikoKt.codePointsAt($this$codePoints, 0);
    }

    @NotNull
    public static final Sequence<Integer> codePointsAt(@NotNull String $this$codePointsAt, int index2) {
        Intrinsics.checkNotNullParameter($this$codePointsAt, "<this>");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object>(index2, $this$codePointsAt, null){
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $index;
            final /* synthetic */ String $this_codePointsAt;
            {
                this.$index = $index;
                this.$this_codePointsAt = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        current = this.$index;
lbl7:
                        // 2 sources

                        while (current < this.$this_codePointsAt.length()) {
                            codePoint = StringHelpers_skikoKt.codePointAt(this.$this_codePointsAt, current);
                            this.L$0 = $this$sequence;
                            this.I$0 = current;
                            this.I$1 = codePoint;
                            this.label = 1;
                            v0 = $this$sequence.yield(Boxing.boxInt(codePoint), this);
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl24
                        }
                        break;
                    }
                    case 1: {
                        codePoint = this.I$1;
                        current = this.I$0;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        current += StringHelpers_skikoKt.charCount(codePoint);
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(SequenceScope<? super Integer> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static final int codePointAt(@NotNull CharSequence $this$codePointAt, int index2) {
        char low;
        Intrinsics.checkNotNullParameter($this$codePointAt, "<this>");
        char high = $this$codePointAt.charAt(index2);
        if (Character.isHighSurrogate(high) && index2 + 1 < $this$codePointAt.length() && Character.isLowSurrogate(low = $this$codePointAt.charAt(index2 + 1))) {
            return StringHelpers_skikoKt.toCodePoint(CharCompanionObject.INSTANCE, high, low);
        }
        return high;
    }

    public static final int codePointBefore(@NotNull CharSequence $this$codePointBefore, int index2) {
        char high;
        Intrinsics.checkNotNullParameter($this$codePointBefore, "<this>");
        char low = $this$codePointBefore.charAt(index2);
        if (Character.isLowSurrogate(low) && index2 - 1 >= 0 && Character.isHighSurrogate(high = $this$codePointBefore.charAt(index2 - 1))) {
            return StringHelpers_skikoKt.toCodePoint(CharCompanionObject.INSTANCE, high, low);
        }
        return low;
    }

    public static final int codePointCount(@NotNull CharSequence $this$codePointCount) {
        Intrinsics.checkNotNullParameter($this$codePointCount, "<this>");
        int count2 = $this$codePointCount.length();
        int i2 = 0;
        while (i2 < $this$codePointCount.length() - 1) {
            if (Character.isHighSurrogate($this$codePointCount.charAt(i2)) && Character.isLowSurrogate($this$codePointCount.charAt(i2 + 1))) {
                --count2;
                i2 += 2;
                continue;
            }
            ++i2;
        }
        return count2;
    }

    public static final int findNextNonWhitespaceSymbolsSubsequenceStartOffset(int offset, @NotNull String currentText) {
        Intrinsics.checkNotNullParameter(currentText, "currentText");
        BreakIterator charIterator = BreakIterator.Companion.makeCharacterInstance$default(BreakIterator.Companion, null, 1, null);
        charIterator.setText(currentText);
        int currentOffset = 0;
        int nextOffset = charIterator.next();
        while (nextOffset < offset) {
            nextOffset = charIterator.next();
        }
        currentOffset = nextOffset;
        nextOffset = charIterator.next();
        while (nextOffset < currentText.length()) {
            if (StringHelpers_skikoKt.isWhitespace(StringHelpers_skikoKt.codePointAt(currentText, currentOffset)) && !StringHelpers_skikoKt.isWhitespace(StringHelpers_skikoKt.codePointAt(currentText, nextOffset))) {
                return nextOffset;
            }
            currentOffset = nextOffset;
            nextOffset = charIterator.next();
        }
        return currentOffset;
    }

    public static final boolean isWhitespaceOrPunctuation(@NotNull String $this$isWhitespaceOrPunctuation, int offset) {
        Intrinsics.checkNotNullParameter($this$isWhitespaceOrPunctuation, "<this>");
        int codePoint = StringHelpers_skikoKt.codePointAt($this$isWhitespaceOrPunctuation, offset);
        return StringHelpers_skikoKt.isPunctuation(codePoint) || StringHelpers_skikoKt.isWhitespace(codePoint);
    }

    public static final int midpointPositionWithUnicodeSymbols(@NotNull String $this$midpointPositionWithUnicodeSymbols) {
        Intrinsics.checkNotNullParameter($this$midpointPositionWithUnicodeSymbols, "<this>");
        int symbolsCount = SequencesKt.count(StringHelpers_skikoKt.getCodePoints($this$midpointPositionWithUnicodeSymbols));
        BreakIterator charIterator = BreakIterator.Companion.makeCharacterInstance$default(BreakIterator.Companion, null, 1, null);
        charIterator.setText($this$midpointPositionWithUnicodeSymbols);
        int currentOffset = 0;
        int i2 = 0;
        int n = symbolsCount / 2;
        if (i2 <= n) {
            while (true) {
                currentOffset = charIterator.next();
                if (i2 == n) break;
                ++i2;
            }
        }
        return currentOffset;
    }

    private static final boolean isWhitespace(int $this$isWhitespace) {
        if (StringHelpers_skikoKt.charCount($this$isWhitespace) != 1) {
            return false;
        }
        return CharsKt.isWhitespace((char)$this$isWhitespace);
    }

    private static final boolean isPunctuation(int $this$isPunctuation) {
        boolean bl;
        block4: {
            if (StringHelpers_skikoKt.charCount($this$isPunctuation) != 1) {
                return false;
            }
            CharCategory[] charCategoryArray = new CharCategory[]{CharCategory.DASH_PUNCTUATION, CharCategory.START_PUNCTUATION, CharCategory.END_PUNCTUATION, CharCategory.CONNECTOR_PUNCTUATION, CharCategory.OTHER_PUNCTUATION, CharCategory.INITIAL_QUOTE_PUNCTUATION, CharCategory.FINAL_QUOTE_PUNCTUATION};
            Set<CharCategory> punctuationSet = SetsKt.setOf(charCategoryArray);
            Iterable $this$any$iv = punctuationSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CharCategory it = (CharCategory)((Object)element$iv);
                    boolean bl2 = false;
                    if (!it.contains((char)$this$isPunctuation)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

