/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.output;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import com.networknt.schema.output.OutputUnitKey;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class OutputUnitData {
    private final Map<OutputUnitKey, Boolean> valid = new LinkedHashMap<OutputUnitKey, Boolean>();
    private final Map<OutputUnitKey, Map<String, Object>> errors = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();
    private final Map<OutputUnitKey, Map<String, Object>> annotations = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();
    private final Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = new LinkedHashMap<OutputUnitKey, Map<String, Object>>();

    public Map<OutputUnitKey, Boolean> getValid() {
        return this.valid;
    }

    public Map<OutputUnitKey, Map<String, Object>> getErrors() {
        return this.errors;
    }

    public Map<OutputUnitKey, Map<String, Object>> getAnnotations() {
        return this.annotations;
    }

    public Map<OutputUnitKey, Map<String, Object>> getDroppedAnnotations() {
        return this.droppedAnnotations;
    }

    public static String formatAssertion(ValidationMessage validationMessage) {
        return OutputUnitData.formatMessage(validationMessage.getMessage());
    }

    public static String formatMessage(String message) {
        int index2 = message.indexOf(58);
        if (index2 != -1) {
            int length = message.length();
            while (index2 + 1 < length && message.charAt(index2 + 1) == ' ') {
                ++index2;
            }
            return message.substring(index2 + 1);
        }
        return message;
    }

    public static OutputUnitData from(Set<ValidationMessage> validationMessages, ExecutionContext executionContext, Function<ValidationMessage, Object> assertionMapper) {
        OutputUnitData data2 = new OutputUnitData();
        Map<OutputUnitKey, Boolean> valid = data2.valid;
        Map<OutputUnitKey, Map<String, Object>> errors = data2.errors;
        Map<OutputUnitKey, Map<String, Object>> annotations = data2.annotations;
        Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = data2.droppedAnnotations;
        for (ValidationMessage validationMessage : validationMessages) {
            SchemaLocation assertionSchemaLocation = new SchemaLocation(validationMessage.getSchemaLocation().getAbsoluteIri(), validationMessage.getSchemaLocation().getFragment().getParent());
            OutputUnitKey key = new OutputUnitKey(validationMessage.getEvaluationPath().getParent(), assertionSchemaLocation, validationMessage.getInstanceLocation());
            valid.put(key, false);
            Map errorMap = errors.computeIfAbsent(key, k -> new LinkedHashMap());
            Object value = errorMap.get(validationMessage.getType());
            if (value == null) {
                errorMap.put(validationMessage.getType(), assertionMapper.apply(validationMessage));
                continue;
            }
            if (value instanceof List) {
                ((List)value).add(assertionMapper.apply(validationMessage));
                continue;
            }
            ArrayList<Object> values2 = new ArrayList<Object>();
            values2.add(value.toString());
            values2.add(assertionMapper.apply(validationMessage));
            errorMap.put(validationMessage.getType(), values2);
        }
        for (List list2 : executionContext.getAnnotations().asMap().values()) {
            for (JsonNodeAnnotation annotation : list2) {
                if (!executionContext.getExecutionConfig().getAnnotationCollectionFilter().test(annotation.getKeyword())) continue;
                SchemaLocation annotationSchemaLocation = new SchemaLocation(annotation.getSchemaLocation().getAbsoluteIri(), annotation.getSchemaLocation().getFragment().getParent());
                OutputUnitKey key = new OutputUnitKey(annotation.getEvaluationPath().getParent(), annotationSchemaLocation, annotation.getInstanceLocation());
                boolean validResult = executionContext.getResults().isValid(annotation.getInstanceLocation(), annotation.getEvaluationPath());
                valid.put(key, validResult);
                if (validResult) {
                    Map annotationMap = annotations.computeIfAbsent(key, k -> new LinkedHashMap());
                    annotationMap.put(annotation.getKeyword(), annotation.getValue());
                    continue;
                }
                Map droppedAnnotationMap = droppedAnnotations.computeIfAbsent(key, k -> new LinkedHashMap());
                droppedAnnotationMap.put(annotation.getKeyword(), annotation.getValue());
            }
        }
        return data2;
    }
}

