/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.jackson.JacksonUtil;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttestationObjectConverter {
    private static final String SOURCE_NULL_CHECK_MESSAGE = "source must not be null";
    private final CborConverter cborConverter;

    public AttestationObjectConverter(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.cborConverter = objectConverter.getCborConverter();
    }

    @Nullable
    public AttestationObject convert(@NotNull String source) {
        try {
            AssertUtil.notNull((Object)source, (String)SOURCE_NULL_CHECK_MESSAGE);
            byte[] value = Base64UrlUtil.decode((String)source);
            return this.convert(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @Nullable
    public AttestationObject convert(@NotNull byte[] source) {
        try {
            AssertUtil.notNull((Object)source, (String)SOURCE_NULL_CHECK_MESSAGE);
            return this.cborConverter.readValue(source, AttestationObject.class);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public byte[] convertToBytes(@NotNull AttestationObject source) {
        try {
            AssertUtil.notNull((Object)source, (String)SOURCE_NULL_CHECK_MESSAGE);
            return this.cborConverter.writeValueAsBytes(source);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public String convertToBase64urlString(@NotNull AttestationObject source) {
        try {
            byte[] bytes = this.convertToBytes(source);
            return Base64UrlUtil.encodeToString((byte[])bytes);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @Nullable
    public byte[] extractAuthenticatorData(@NotNull byte[] attestationObject) {
        AssertUtil.notNull((Object)attestationObject, (String)"attestationObject must not be null");
        JsonNode authData = this.cborConverter.readTree(attestationObject).get("authData");
        return JacksonUtil.binaryValue(authData);
    }

    @Nullable
    public byte[] extractAttestationStatement(@NotNull byte[] attestationObject) {
        AssertUtil.notNull((Object)attestationObject, (String)"attestationObject must not be null");
        JsonNode attStmt = this.cborConverter.readTree(attestationObject).get("attStmt");
        return this.cborConverter.writeValueAsBytes(attStmt);
    }
}

