/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsNodeWithAdjustedBounds;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsRegion;
import androidx.compose.ui.semantics.SemanticsRegion_skikoKt;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntRectKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a,\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\b*\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0002H\u0000\u001a\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00032\u0006\u0010\u0015\u001a\u00020\tH\u0000\"\u001e\u0010\f\u001a\u00020\u0005*\u00020\u00028@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\f\u0010\u000f\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"getAllSemanticsNodes", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "Landroidx/compose/ui/semantics/SemanticsOwner;", "mergingEnabled", "", "skipDeactivatedNodes", "getAllSemanticsNodesToMap", "", "", "useUnmergedTree", "isImportantForAccessibility", "isHidden", "isHidden$annotations", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "DefaultFakeNodeBounds", "Landroidx/compose/ui/geometry/Rect;", "getAllUncoveredSemanticsNodesToIntObjectMap", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/ui/semantics/SemanticsNodeWithAdjustedBounds;", "customRootNodeId", "ui"})
@SourceDebugExtension(value={"SMAP\nSemanticsOwner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsOwner.kt\nandroidx/compose/ui/semantics/SemanticsOwnerKt\n+ 2 Trace.desktop.kt\nandroidx/compose/ui/util/Trace_jbKt__Trace_desktopKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,246:1\n23#2:247\n35#3,5:248\n*S KotlinDebug\n*F\n+ 1 SemanticsOwner.kt\nandroidx/compose/ui/semantics/SemanticsOwnerKt\n*L\n160#1:247\n117#1:248,5\n*E\n"})
public final class SemanticsOwnerKt {
    @NotNull
    private static final Rect DefaultFakeNodeBounds = new Rect(0.0f, 0.0f, 10.0f, 10.0f);

    @NotNull
    public static final List<SemanticsNode> getAllSemanticsNodes(@NotNull SemanticsOwner $this$getAllSemanticsNodes, boolean mergingEnabled, boolean skipDeactivatedNodes) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllSemanticsNodes, (String)"<this>");
        return CollectionsKt.toList((Iterable)SemanticsOwnerKt.getAllSemanticsNodesToMap($this$getAllSemanticsNodes, !mergingEnabled, skipDeactivatedNodes).values());
    }

    public static /* synthetic */ List getAllSemanticsNodes$default(SemanticsOwner semanticsOwner, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return SemanticsOwnerKt.getAllSemanticsNodes(semanticsOwner, bl, bl2);
    }

    @Deprecated(message="Use a new overload instead", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ List getAllSemanticsNodes(SemanticsOwner $this$getAllSemanticsNodes, boolean mergingEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllSemanticsNodes, (String)"<this>");
        return SemanticsOwnerKt.getAllSemanticsNodes($this$getAllSemanticsNodes, mergingEnabled, true);
    }

    @NotNull
    public static final Map<Integer, SemanticsNode> getAllSemanticsNodesToMap(@NotNull SemanticsOwner $this$getAllSemanticsNodesToMap, boolean useUnmergedTree, boolean skipDeactivatedNodes) {
        SemanticsNode root;
        Intrinsics.checkNotNullParameter((Object)$this$getAllSemanticsNodesToMap, (String)"<this>");
        Map nodes = new LinkedHashMap();
        SemanticsNode semanticsNode = root = useUnmergedTree ? $this$getAllSemanticsNodesToMap.getUnmergedRootSemanticsNode() : $this$getAllSemanticsNodesToMap.getRootSemanticsNode();
        if (!skipDeactivatedNodes || !root.getLayoutNode$ui().isDeactivated()) {
            SemanticsOwnerKt.getAllSemanticsNodesToMap$findAllSemanticNodesRecursive(nodes, skipDeactivatedNodes, root);
        }
        return nodes;
    }

    public static /* synthetic */ Map getAllSemanticsNodesToMap$default(SemanticsOwner semanticsOwner, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return SemanticsOwnerKt.getAllSemanticsNodesToMap(semanticsOwner, bl, bl2);
    }

    public static final boolean isImportantForAccessibility(@NotNull SemanticsNode $this$isImportantForAccessibility) {
        Intrinsics.checkNotNullParameter((Object)$this$isImportantForAccessibility, (String)"<this>");
        return !SemanticsOwnerKt.isHidden($this$isImportantForAccessibility) && ($this$isImportantForAccessibility.getUnmergedConfig$ui().isMergingSemanticsOfDescendants() || $this$isImportantForAccessibility.getUnmergedConfig$ui().containsImportantForAccessibility$ui());
    }

    public static final boolean isHidden(@NotNull SemanticsNode $this$isHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$isHidden, (String)"<this>");
        return $this$isHidden.isTransparent$ui() || $this$isHidden.getUnmergedConfig$ui().contains(SemanticsProperties.INSTANCE.getHideFromAccessibility()) || $this$isHidden.getUnmergedConfig$ui().contains(SemanticsProperties.INSTANCE.getInvisibleToUser());
    }

    public static /* synthetic */ void isHidden$annotations(SemanticsNode semanticsNode) {
    }

    @NotNull
    public static final IntObjectMap<SemanticsNodeWithAdjustedBounds> getAllUncoveredSemanticsNodesToIntObjectMap(@NotNull SemanticsOwner $this$getAllUncoveredSemanticsNodesToIntObjectMap, int customRootNodeId) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllUncoveredSemanticsNodesToIntObjectMap, (String)"<this>");
        String sectionName$iv = "getAllUncoveredSemanticsNodesToIntObjectMap";
        boolean $i$f$trace = false;
        boolean bl = false;
        SemanticsNode root = $this$getAllUncoveredSemanticsNodesToIntObjectMap.getUnmergedRootSemanticsNode();
        if (!root.getLayoutNode$ui().isPlaced() || !root.getLayoutNode$ui().isAttached()) {
            return IntObjectMapKt.emptyIntObjectMap();
        }
        MutableIntObjectMap nodes = new MutableIntObjectMap(48);
        SemanticsRegion unaccountedSpace = SemanticsRegion_skikoKt.SemanticsRegion();
        unaccountedSpace.set(IntRectKt.roundToIntRect((Rect)root.getBoundsInRoot()));
        SemanticsOwnerKt.getAllUncoveredSemanticsNodesToIntObjectMap$lambda$2$findAllSemanticNodesRecursive$1(unaccountedSpace, root, customRootNodeId, (MutableIntObjectMap<SemanticsNodeWithAdjustedBounds>)nodes, root, SemanticsRegion_skikoKt.SemanticsRegion());
        return (IntObjectMap)nodes;
    }

    private static final void getAllSemanticsNodesToMap$findAllSemanticNodesRecursive(Map<Integer, SemanticsNode> nodes, boolean $skipDeactivatedNodes, SemanticsNode currentNode) {
        nodes.put(currentNode.getId(), currentNode);
        List $this$fastForEach$iv = SemanticsNode.getChildren$ui$default(currentNode, false, false, !$skipDeactivatedNodes, 3, null);
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            SemanticsNode child = (SemanticsNode)item$iv;
            boolean bl = false;
            SemanticsOwnerKt.getAllSemanticsNodesToMap$findAllSemanticNodesRecursive(nodes, $skipDeactivatedNodes, child);
        }
    }

    private static final void getAllUncoveredSemanticsNodesToIntObjectMap$lambda$2$findAllSemanticNodesRecursive$1(SemanticsRegion unaccountedSpace, SemanticsNode root, int $customRootNodeId, MutableIntObjectMap<SemanticsNodeWithAdjustedBounds> nodes, SemanticsNode currentNode, SemanticsRegion region) {
        int virtualViewId;
        boolean notAttachedOrPlaced;
        boolean bl = notAttachedOrPlaced = !currentNode.getLayoutNode$ui().isPlaced() || !currentNode.getLayoutNode$ui().isAttached();
        if (unaccountedSpace.isEmpty() && currentNode.getId() != root.getId() || notAttachedOrPlaced && !currentNode.isFake$ui()) {
            return;
        }
        IntRect touchBoundsInRoot = IntRectKt.roundToIntRect((Rect)currentNode.getTouchBoundsInRoot());
        region.set(touchBoundsInRoot);
        int n = virtualViewId = currentNode.getId() == root.getId() ? $customRootNodeId : currentNode.getId();
        if (region.intersect(unaccountedSpace)) {
            nodes.set(virtualViewId, (Object)new SemanticsNodeWithAdjustedBounds(currentNode, region.getBounds()));
            List<SemanticsNode> children = currentNode.getReplacedChildren$ui();
            for (int i = children.size() - 1; -1 < i; --i) {
                if (children.get(i).getConfig().contains(SemanticsProperties.INSTANCE.getLinkTestMarker())) continue;
                SemanticsOwnerKt.getAllUncoveredSemanticsNodesToIntObjectMap$lambda$2$findAllSemanticNodesRecursive$1(unaccountedSpace, root, $customRootNodeId, nodes, children.get(i), region);
            }
            if (SemanticsOwnerKt.isImportantForAccessibility(currentNode)) {
                unaccountedSpace.difference(touchBoundsInRoot);
            }
        } else if (currentNode.isFake$ui()) {
            SemanticsNode parentNode = currentNode.getParent();
            Object object = parentNode;
            Rect boundsForFakeNode = (object != null && (object = ((SemanticsNode)object).getLayoutInfo()) != null ? object.isPlaced() : false) ? parentNode.getBoundsInRoot() : DefaultFakeNodeBounds;
            nodes.set(virtualViewId, (Object)new SemanticsNodeWithAdjustedBounds(currentNode, IntRectKt.roundToIntRect((Rect)boundsForFakeNode)));
        } else if (virtualViewId == $customRootNodeId) {
            nodes.set(virtualViewId, (Object)new SemanticsNodeWithAdjustedBounds(currentNode, region.getBounds()));
        }
    }
}

