/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.choice;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.ArgumentChoice;

public class CollectionArgumentChoice<E>
implements ArgumentChoice {
    private final Collection<E> values_;

    @SafeVarargs
    public CollectionArgumentChoice(E ... values2) {
        this.values_ = Arrays.asList(values2);
    }

    public CollectionArgumentChoice(Collection<E> values2) {
        this.values_ = values2;
    }

    @Override
    public boolean contains(Object val) {
        if (this.values_.isEmpty()) {
            return false;
        }
        E first2 = this.values_.iterator().next();
        if (first2.getClass().equals(val.getClass()) || first2 instanceof Enum && val instanceof Enum && ((Enum)first2).getDeclaringClass().equals(((Enum)val).getDeclaringClass())) {
            return this.values_.contains(val);
        }
        throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "type mismatch (Make sure that you specified correct Argument.type()): expected: %s actual: %s", first2.getClass().getName(), val.getClass().getName()));
    }

    @Override
    public String textualFormat() {
        return TextHelper.concat(this.values_, 0, ",", "{", "}");
    }

    public String toString() {
        return this.textualFormat();
    }
}

