/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.LeafNode;
import org.jsoup.select.Evaluator;

public abstract class CombiningEvaluator
extends Evaluator {
    final ArrayList<Evaluator> evaluators = new ArrayList();
    final List<Evaluator> sortedEvaluators = new ArrayList<Evaluator>();
    int num = 0;
    int cost = 0;
    boolean wantsNodes;

    CombiningEvaluator() {
    }

    CombiningEvaluator(Collection<Evaluator> evaluators) {
        this();
        this.evaluators.addAll(evaluators);
        this.updateEvaluators();
    }

    public void add(Evaluator e) {
        this.evaluators.add(e);
        this.updateEvaluators();
    }

    @Override
    protected void reset() {
        for (Evaluator evaluator : this.evaluators) {
            evaluator.reset();
        }
        super.reset();
    }

    @Override
    protected int cost() {
        return this.cost;
    }

    @Override
    boolean wantsNodes() {
        return this.wantsNodes;
    }

    void updateEvaluators() {
        this.num = this.evaluators.size();
        this.cost = 0;
        for (Evaluator evaluator : this.evaluators) {
            this.cost += evaluator.cost();
        }
        this.sortedEvaluators.clear();
        this.sortedEvaluators.addAll(this.evaluators);
        this.sortedEvaluators.sort(Comparator.comparingInt(Evaluator::cost));
        for (Evaluator evaluator : this.evaluators) {
            if (!evaluator.wantsNodes()) continue;
            this.wantsNodes = true;
            break;
        }
    }

    public static final class Or
    extends CombiningEvaluator {
        public Or(Collection<Evaluator> evaluators) {
            if (this.num > 1) {
                this.evaluators.add(new And(evaluators));
            } else {
                this.evaluators.addAll(evaluators);
            }
            this.updateEvaluators();
        }

        Or(Evaluator ... evaluators) {
            this(Arrays.asList(evaluators));
        }

        Or() {
        }

        @Override
        public boolean matches(Element root, Element element) {
            for (int i2 = 0; i2 < this.num; ++i2) {
                Evaluator eval = (Evaluator)this.sortedEvaluators.get(i2);
                if (!eval.matches(root, element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(Element root, LeafNode leaf) {
            for (int i2 = 0; i2 < this.num; ++i2) {
                Evaluator eval = (Evaluator)this.sortedEvaluators.get(i2);
                if (!eval.matches(root, leaf)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return StringUtil.join(this.evaluators, ", ");
        }
    }

    public static final class And
    extends CombiningEvaluator {
        public And(Collection<Evaluator> evaluators) {
            super(evaluators);
        }

        And(Evaluator ... evaluators) {
            this(Arrays.asList(evaluators));
        }

        @Override
        public boolean matches(Element root, Element el) {
            for (int i2 = 0; i2 < this.num; ++i2) {
                Evaluator eval = (Evaluator)this.sortedEvaluators.get(i2);
                if (eval.matches(root, el)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matches(Element root, LeafNode leaf) {
            for (int i2 = 0; i2 < this.num; ++i2) {
                Evaluator eval = (Evaluator)this.sortedEvaluators.get(i2);
                if (eval.matches(root, leaf)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return StringUtil.join(this.evaluators, "");
        }
    }
}

