/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.bytestring;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.bytestring.BenignDataRace;
import kotlinx.io.bytestring.ByteStringKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\b\u0010\f\u001a\u00020\tH\u0016J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0086\u0002J\u001a\u0010\u0016\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u0011\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lkotlinx/io/bytestring/ByteString;", "", "data", "", "dummy", "", "<init>", "([BLjava/lang/Object;)V", "startIndex", "", "endIndex", "([BII)V", "hashCode", "size", "getSize", "()I", "equals", "", "other", "get", "", "index", "toByteArray", "copyInto", "", "destination", "destinationOffset", "substring", "compareTo", "toString", "", "getBackingArrayReference", "Companion", "kotlinx-io-bytestring"})
@SourceDebugExtension(value={"SMAP\nByteString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteString.kt\nkotlinx/io/bytestring/ByteString\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,550:1\n1#2:551\n*E\n"})
public final class ByteString
implements Comparable<ByteString> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] data;
    @BenignDataRace
    private int hashCode;
    @NotNull
    private static final ByteString EMPTY = new ByteString(new byte[0], null);
    @NotNull
    private static final char[] HEX_DIGITS;

    private ByteString(byte[] data2, Object dummy) {
        this.data = data2;
    }

    public ByteString(@NotNull byte[] data2, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this(ArraysKt.copyOfRange(data2, startIndex, endIndex), null);
    }

    public /* synthetic */ ByteString(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        this(byArray, n, n2);
    }

    public final int getSize() {
        return this.data.length;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ByteString cfr_ignored_0 = (ByteString)other;
        if (((ByteString)other).data.length != this.data.length) {
            return false;
        }
        if (((ByteString)other).hashCode != 0 && this.hashCode != 0 && ((ByteString)other).hashCode != this.hashCode) {
            return false;
        }
        return Arrays.equals(this.data, ((ByteString)other).data);
    }

    public int hashCode() {
        int hc = this.hashCode;
        if (hc == 0) {
            this.hashCode = hc = Arrays.hashCode(this.data);
        }
        return hc;
    }

    public final byte get(int index2) {
        if (index2 < 0 || index2 >= this.getSize()) {
            throw new IndexOutOfBoundsException("index (" + index2 + ") is out of byte string bounds: [0.." + this.getSize() + ')');
        }
        return this.data[index2];
    }

    @NotNull
    public final byte[] toByteArray(int startIndex, int endIndex) {
        if (!(startIndex <= endIndex)) {
            boolean bl = false;
            String string2 = "startIndex (" + startIndex + ") > endIndex (" + endIndex + ')';
            throw new IllegalArgumentException(string2.toString());
        }
        return ArraysKt.copyOfRange(this.data, startIndex, endIndex);
    }

    public static /* synthetic */ byte[] toByteArray$default(ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byteString.getSize();
        }
        return byteString.toByteArray(n, n2);
    }

    public final void copyInto(@NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (!(startIndex <= endIndex)) {
            boolean bl = false;
            String string2 = "startIndex (" + startIndex + ") > endIndex (" + endIndex + ')';
            throw new IllegalArgumentException(string2.toString());
        }
        ArraysKt.copyInto(this.data, destination, destinationOffset, startIndex, endIndex);
    }

    public static /* synthetic */ void copyInto$default(ByteString byteString, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byteString.getSize();
        }
        byteString.copyInto(byArray, n, n2, n3);
    }

    @NotNull
    public final ByteString substring(int startIndex, int endIndex) {
        return startIndex == endIndex ? EMPTY : new ByteString(this.data, startIndex, endIndex);
    }

    public static /* synthetic */ ByteString substring$default(ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = byteString.getSize();
        }
        return byteString.substring(n, n2);
    }

    @Override
    public int compareTo(@NotNull ByteString other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (other == this) {
            return 0;
        }
        byte[] localData = this.data;
        byte[] otherData = other.data;
        int n = Math.min(this.getSize(), other.getSize());
        for (int i2 = 0; i2 < n; ++i2) {
            int cmp = Intrinsics.compare(UByte.constructor-impl(localData[i2]) & 0xFF, UByte.constructor-impl(otherData[i2]) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return Intrinsics.compare(this.getSize(), other.getSize());
    }

    @NotNull
    public String toString() {
        if (ByteStringKt.isEmpty(this)) {
            return "ByteString(size=0)";
        }
        String sizeStr = String.valueOf(this.getSize());
        int len = 22 + sizeStr.length() + this.getSize() * 2;
        StringBuilder $this$toString_u24lambda_u242 = new StringBuilder(len);
        boolean bl = false;
        $this$toString_u24lambda_u242.append("ByteString(size=");
        $this$toString_u24lambda_u242.append(sizeStr);
        $this$toString_u24lambda_u242.append(" hex=");
        byte[] localData = this.data;
        int n = this.getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            byte b2 = localData[i2];
            $this$toString_u24lambda_u242.append(HEX_DIGITS[b2 >>> 4 & 0xF]);
            $this$toString_u24lambda_u242.append(HEX_DIGITS[b2 & 0xF]);
        }
        String string2 = $this$toString_u24lambda_u242.append(')').toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @PublishedApi
    @NotNull
    public final byte[] getBackingArrayReference() {
        return this.data;
    }

    public /* synthetic */ ByteString(byte[] data2, Object dummy, DefaultConstructorMarker $constructor_marker) {
        this(data2, dummy);
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        HEX_DIGITS = cArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/io/bytestring/ByteString$Companion;", "", "<init>", "()V", "EMPTY", "Lkotlinx/io/bytestring/ByteString;", "getEMPTY$kotlinx_io_bytestring", "()Lkotlinx/io/bytestring/ByteString;", "wrap", "byteArray", "", "wrap$kotlinx_io_bytestring", "HEX_DIGITS", "", "kotlinx-io-bytestring"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteString getEMPTY$kotlinx_io_bytestring() {
            return EMPTY;
        }

        @NotNull
        public final ByteString wrap$kotlinx_io_bytestring(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter(byteArray, "byteArray");
            return new ByteString(byteArray, null, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

