/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.ExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationExtensionsClientInputsConverter {
    private final JsonConverter jsonConverter;

    public AuthenticationExtensionsClientInputsConverter(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.jsonConverter = objectConverter.getJsonConverter();
    }

    @Nullable
    public <T extends ExtensionClientInput> AuthenticationExtensionsClientInputs<T> convert(@NotNull String value) {
        try {
            AssertUtil.notNull((Object)value, (String)"value must not be null");
            return (AuthenticationExtensionsClientInputs)this.jsonConverter.readValue(value, new TypeReference<AuthenticationExtensionsClientInputs<T>>(){});
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public <T extends ExtensionClientInput> String convertToString(@NotNull AuthenticationExtensionsClientInputs<T> value) {
        try {
            AssertUtil.notNull(value, (String)"value must not be null");
            return this.jsonConverter.writeValueAsString(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }
}

