/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.spatial;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.spatial.RectList;
import androidx.compose.ui.spatial.RectManager;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntRectKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BC\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0000J&\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019J\u0006\u00100\u001a\u00020)J\u001d\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006\u00a2\u0006\u0004\b4\u00105J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00109\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0011\u0010$\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010!\u00a8\u0006:"}, d2={"Landroidx/compose/ui/spatial/RelativeLayoutBounds;", "", "topLeft", "", "bottomRight", "windowOffset", "Landroidx/compose/ui/unit/IntOffset;", "screenOffset", "windowSize", "viewToWindowMatrix", "Landroidx/compose/ui/graphics/Matrix;", "node", "Landroidx/compose/ui/node/DelegatableNode;", "<init>", "(JJJJJ[FLandroidx/compose/ui/node/DelegatableNode;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "[F", "positionInRoot", "getPositionInRoot-nOcc-ac", "()J", "positionInWindow", "getPositionInWindow-nOcc-ac", "positionInScreen", "getPositionInScreen-nOcc-ac", "width", "", "getWidth", "()I", "height", "getHeight", "boundsInRoot", "Landroidx/compose/ui/unit/IntRect;", "getBoundsInRoot", "()Landroidx/compose/ui/unit/IntRect;", "boundsInWindow", "getBoundsInWindow", "boundsInScreen", "getBoundsInScreen", "calculateOcclusions", "", "fractionVisibleIn", "", "viewport", "fractionVisibleInRect", "left", "top", "right", "bottom", "fractionVisibleInWindow", "fractionVisibleInWindowWithInsets", "topLeftInset", "bottomRightInset", "fractionVisibleInWindowWithInsets-E1MhUcY", "(JJ)F", "equals", "", "other", "hashCode", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRelativeLayoutBounds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelativeLayoutBounds.kt\nandroidx/compose/ui/spatial/RelativeLayoutBounds\n+ 2 RectList.kt\nandroidx/compose/ui/spatial/RectListKt\n+ 3 IntOffset.kt\nandroidx/compose/ui/unit/IntOffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 RectList.kt\nandroidx/compose/ui/spatial/RectList\n*L\n1#1,306:1\n893#2:307\n895#2:308\n893#2:311\n895#2:312\n893#2:315\n893#2:316\n895#2:317\n895#2:318\n893#2:319\n895#2:320\n893#2:321\n895#2:322\n893#2:323\n895#2:324\n893#2:325\n895#2:326\n893#2:327\n895#2:328\n893#2:329\n895#2:330\n916#2,2:347\n893#2:351\n895#2:353\n893#2:355\n895#2:357\n860#2:359\n893#2:363\n895#2:364\n893#2:365\n895#2:366\n893#2:367\n895#2:368\n893#2:369\n895#2:370\n893#2,3:371\n893#2:374\n895#2:375\n32#3:309\n32#3:313\n80#4:310\n80#4:314\n590#5,16:331\n606#5,2:349\n608#5:352\n609#5:354\n610#5:356\n611#5:358\n614#5,3:360\n*S KotlinDebug\n*F\n+ 1 RelativeLayoutBounds.kt\nandroidx/compose/ui/spatial/RelativeLayoutBounds\n*L\n58#1:307\n59#1:308\n68#1:311\n69#1:312\n76#1:315\n77#1:316\n84#1:317\n85#1:318\n94#1:319\n95#1:320\n96#1:321\n97#1:322\n104#1:323\n105#1:324\n106#1:325\n107#1:326\n134#1:327\n135#1:328\n136#1:329\n137#1:330\n174#1:347,2\n174#1:351\n174#1:353\n174#1:355\n174#1:357\n174#1:359\n197#1:363\n198#1:364\n199#1:365\n200#1:366\n216#1:367\n219#1:368\n222#1:369\n225#1:370\n248#1:371,3\n273#1:374\n274#1:375\n60#1:309\n70#1:313\n60#1:310\n70#1:314\n174#1:331,16\n174#1:349,2\n174#1:352\n174#1:354\n174#1:356\n174#1:358\n174#1:360,3\n*E\n"})
public final class RelativeLayoutBounds {
    private final long topLeft;
    private final long bottomRight;
    private final long windowOffset;
    private final long screenOffset;
    private final long windowSize;
    @Nullable
    private final float[] viewToWindowMatrix;
    @NotNull
    private final DelegatableNode node;
    public static final int $stable = 8;

    private RelativeLayoutBounds(long topLeft, long bottomRight, long windowOffset, long screenOffset, long windowSize, float[] viewToWindowMatrix, DelegatableNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.windowOffset = windowOffset;
        this.screenOffset = screenOffset;
        this.windowSize = windowSize;
        this.viewToWindowMatrix = viewToWindowMatrix;
        this.node = node;
    }

    public final long getPositionInRoot-nOcc-ac() {
        return IntOffset.constructor-impl((long)this.topLeft);
    }

    /*
     * WARNING - void declaration
     */
    public final long getPositionInWindow-nOcc-ac() {
        void x$iv;
        int x = IntOffset.getX-impl((long)this.screenOffset) - IntOffset.getX-impl((long)this.windowOffset);
        int y = IntOffset.getY-impl((long)this.screenOffset) - IntOffset.getY-impl((long)this.windowOffset);
        long xy$iv = this.topLeft;
        boolean $i$f$unpackX = false;
        int l = (int)(xy$iv >> 32);
        long xy$iv22 = this.topLeft;
        boolean $i$f$unpackY = false;
        int t = (int)xy$iv22;
        int xy$iv22 = l + x;
        int y$iv = t + y;
        boolean $i$f$IntOffset = false;
        boolean $i$f$packInts = false;
        return IntOffset.constructor-impl((long)((long)x$iv << 32 | (long)y$iv & 0xFFFFFFFFL));
    }

    /*
     * WARNING - void declaration
     */
    public final long getPositionInScreen-nOcc-ac() {
        void x$iv;
        int x = IntOffset.getX-impl((long)this.screenOffset);
        int y = IntOffset.getY-impl((long)this.screenOffset);
        long xy$iv = this.topLeft;
        boolean $i$f$unpackX = false;
        int l = (int)(xy$iv >> 32);
        long xy$iv22 = this.topLeft;
        boolean $i$f$unpackY = false;
        int t = (int)xy$iv22;
        int xy$iv22 = l + x;
        int y$iv = t + y;
        boolean $i$f$IntOffset = false;
        boolean $i$f$packInts = false;
        return IntOffset.constructor-impl((long)((long)x$iv << 32 | (long)y$iv & 0xFFFFFFFFL));
    }

    public final int getWidth() {
        long xy$iv = this.topLeft;
        boolean $i$f$unpackX = false;
        int l = (int)(xy$iv >> 32);
        long xy$iv2 = this.bottomRight;
        boolean $i$f$unpackX2 = false;
        int r = (int)(xy$iv2 >> 32);
        return r - l;
    }

    public final int getHeight() {
        long xy$iv = this.topLeft;
        boolean $i$f$unpackY = false;
        int t = (int)xy$iv;
        long xy$iv2 = this.bottomRight;
        boolean $i$f$unpackY2 = false;
        int b = (int)xy$iv2;
        return b - t;
    }

    @NotNull
    public final IntRect getBoundsInRoot() {
        long xy$iv = this.topLeft;
        boolean $i$f$unpackX = false;
        int l = (int)(xy$iv >> 32);
        long xy$iv2 = this.topLeft;
        boolean $i$f$unpackY = false;
        int t = (int)xy$iv2;
        long xy$iv3 = this.bottomRight;
        boolean $i$f$unpackX2 = false;
        int r = (int)(xy$iv3 >> 32);
        long xy$iv4 = this.bottomRight;
        boolean $i$f$unpackY2 = false;
        int b = (int)xy$iv4;
        return new IntRect(l, t, r, b);
    }

    @NotNull
    public final IntRect getBoundsInWindow() {
        long xy$iv = this.topLeft;
        boolean $i$f$unpackX = false;
        int l = (int)(xy$iv >> 32);
        long xy$iv2 = this.topLeft;
        boolean $i$f$unpackY = false;
        int t = (int)xy$iv2;
        long xy$iv3 = this.bottomRight;
        boolean $i$f$unpackX2 = false;
        int r = (int)(xy$iv3 >> 32);
        long xy$iv4 = this.bottomRight;
        boolean $i$f$unpackY2 = false;
        int b = (int)xy$iv4;
        if (this.viewToWindowMatrix != null) {
            return IntRectKt.roundToIntRect((Rect)Matrix.map-impl((float[])this.viewToWindowMatrix, (Rect)new Rect((float)l, (float)t, (float)r, (float)b)));
        }
        int x = IntOffset.getX-impl((long)this.screenOffset) - IntOffset.getX-impl((long)this.windowOffset);
        int y = IntOffset.getY-impl((long)this.screenOffset) - IntOffset.getY-impl((long)this.windowOffset);
        return new IntRect(l + x, t + y, r + x, b + y);
    }

    @NotNull
    public final IntRect getBoundsInScreen() {
        if (this.viewToWindowMatrix != null) {
            IntRect windowRect = this.getBoundsInWindow();
            long offset = this.windowOffset;
            return new IntRect(windowRect.getLeft() + IntOffset.getX-impl((long)offset), windowRect.getTop() + IntOffset.getY-impl((long)offset), windowRect.getRight() + IntOffset.getX-impl((long)offset), windowRect.getBottom() + IntOffset.getY-impl((long)offset));
        }
        long xy$iv = this.topLeft;
        boolean $i$f$unpackX = false;
        int l = (int)(xy$iv >> 32);
        long xy$iv2 = this.topLeft;
        boolean $i$f$unpackY = false;
        int t = (int)xy$iv2;
        long xy$iv3 = this.bottomRight;
        boolean $i$f$unpackX2 = false;
        int r = (int)(xy$iv3 >> 32);
        long xy$iv4 = this.bottomRight;
        boolean $i$f$unpackY2 = false;
        int b = (int)xy$iv4;
        int x = IntOffset.getX-impl((long)this.screenOffset);
        int y = IntOffset.getY-impl((long)this.screenOffset);
        return new IntRect(l + x, t + y, r + x, b + y);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IntRect> calculateOcclusions() {
        List list;
        RectManager rectManager = DelegatableNodeKt.requireOwner(this.node).getRectManager();
        int id = DelegatableNodeKt.requireLayoutNode(this.node).getSemanticsId();
        RectList rectList = rectManager.getRects();
        int idIndex = rectList.indexOf(id);
        if (idIndex < 0) {
            return CollectionsKt.emptyList();
        }
        List $this$calculateOcclusions_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RectList this_$iv = rectList;
        boolean $i$f$forEachIntersectingRectWithValueAt = false;
        long[] items$iv = this_$iv.items;
        int size$iv = this_$iv.itemsSize;
        long destTopLeft$iv = items$iv[idIndex];
        long destBottomRight$iv = items$iv[idIndex + 1];
        int i$iv = 0;
        while (i$iv < items$iv.length - 2 && i$iv < size$iv) {
            if (i$iv == idIndex) {
                i$iv += 3;
                continue;
            }
            long topLeft$iv = items$iv[i$iv + 0];
            long bottomRight$iv = items$iv[i$iv + 1];
            boolean $i$f$rectIntersectsRect = false;
            long a$iv$iv = destBottomRight$iv - topLeft$iv - 0x100000001L | bottomRight$iv - destTopLeft$iv - 0x100000001L;
            if ((a$iv$iv & 0x8000000080000000L) == 0L) {
                void intersectingId;
                boolean $i$f$unpackX = false;
                boolean $i$f$unpackY = false;
                $i$f$unpackX = false;
                $i$f$unpackY = false;
                long meta$iv$iv = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaValue = false;
                int n = (int)meta$iv$iv & 0x3FFFFFF;
                int n2 = (int)bottomRight$iv;
                int n3 = (int)(bottomRight$iv >> 32);
                int n4 = (int)topLeft$iv;
                int l = (int)(topLeft$iv >> 32);
                boolean bl2 = false;
                if (rectManager.isTargetDrawnFirst$ui(id, (int)intersectingId)) {
                    void b;
                    void r;
                    void t;
                    $this$calculateOcclusions_u24lambda_u241.add(new IntRect(l, (int)t, (int)r, (int)b));
                }
            }
            i$iv += 3;
        }
        return CollectionsKt.build((List)list);
    }

    public final float fractionVisibleIn(@NotNull RelativeLayoutBounds viewport) {
        Intrinsics.checkNotNullParameter((Object)viewport, (String)"viewport");
        long tl = viewport.topLeft;
        long br = viewport.bottomRight;
        boolean $i$f$unpackX = false;
        boolean $i$f$unpackY = false;
        $i$f$unpackX = false;
        $i$f$unpackY = false;
        return this.fractionVisibleInRect((int)(tl >> 32), (int)tl, (int)(br >> 32), (int)br);
    }

    public final float fractionVisibleInRect(int left, int top, int right, int bottom) {
        long xy$iv = this.topLeft;
        boolean $i$f$unpackX = false;
        int l = (int)(xy$iv >> 32);
        int clippedLeft = Math.min(Math.max(l, left), right);
        long xy$iv2 = this.topLeft;
        boolean $i$f$unpackY = false;
        int t = (int)xy$iv2;
        int clippedTop = Math.min(Math.max(t, top), bottom);
        long xy$iv3 = this.bottomRight;
        boolean $i$f$unpackX2 = false;
        int r = (int)(xy$iv3 >> 32);
        int clippedRight = Math.max(Math.min(r, right), left);
        long xy$iv4 = this.bottomRight;
        boolean $i$f$unpackY2 = false;
        int b = (int)xy$iv4;
        int clippedBottom = Math.max(Math.min(b, bottom), top);
        int viewportArea = (right - left) * (bottom - top);
        int rectArea = (r - l) * (b - t);
        int clippedArea = Math.max((clippedRight - clippedLeft) * (clippedBottom - clippedTop), 0);
        int maxArea = Math.min(viewportArea, rectArea);
        return (float)clippedArea / (float)maxArea;
    }

    public final float fractionVisibleInWindow() {
        long windowSize = this.windowSize;
        boolean $i$f$unpackX = false;
        boolean $i$f$unpackY = false;
        return this.fractionVisibleInRect(0, 0, (int)(windowSize >> 32), (int)windowSize);
    }

    public final float fractionVisibleInWindowWithInsets-E1MhUcY(long topLeftInset, long bottomRightInset) {
        long windowSize = this.windowSize;
        int x = IntOffset.getX-impl((long)this.windowOffset);
        int y = IntOffset.getY-impl((long)this.windowOffset);
        boolean $i$f$unpackX = false;
        boolean $i$f$unpackY = false;
        return this.fractionVisibleInRect(x + IntOffset.getX-impl((long)topLeftInset), y + IntOffset.getY-impl((long)topLeftInset), x + (int)(windowSize >> 32) - IntOffset.getX-impl((long)bottomRightInset), y + (int)windowSize - IntOffset.getY-impl((long)bottomRightInset));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RelativeLayoutBounds cfr_ignored_0 = (RelativeLayoutBounds)other;
        if (this.topLeft != ((RelativeLayoutBounds)other).topLeft) {
            return false;
        }
        if (this.bottomRight != ((RelativeLayoutBounds)other).bottomRight) {
            return false;
        }
        if (this.windowSize != ((RelativeLayoutBounds)other).windowSize) {
            return false;
        }
        if (!IntOffset.equals-impl0((long)this.windowOffset, (long)((RelativeLayoutBounds)other).windowOffset)) {
            return false;
        }
        if (!IntOffset.equals-impl0((long)this.screenOffset, (long)((RelativeLayoutBounds)other).screenOffset)) {
            return false;
        }
        float[] fArray = this.viewToWindowMatrix;
        float[] fArray2 = ((RelativeLayoutBounds)other).viewToWindowMatrix;
        if (!(fArray == null ? fArray2 == null : (fArray2 == null ? false : Matrix.equals-impl0((float[])fArray, (float[])fArray2)))) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.node, (Object)((RelativeLayoutBounds)other).node);
    }

    public int hashCode() {
        int result = Long.hashCode(this.topLeft);
        result = 31 * result + Long.hashCode(this.bottomRight);
        result = 31 * result + Long.hashCode(this.windowSize);
        result = 31 * result + IntOffset.hashCode-impl((long)this.windowOffset);
        result = 31 * result + IntOffset.hashCode-impl((long)this.screenOffset);
        result = 31 * result + (this.viewToWindowMatrix != null ? Matrix.hashCode-impl((float[])this.viewToWindowMatrix) : 0);
        result = 31 * result + this.node.hashCode();
        return result;
    }

    public /* synthetic */ RelativeLayoutBounds(long topLeft, long bottomRight, long windowOffset, long screenOffset, long windowSize, float[] viewToWindowMatrix, DelegatableNode node, DefaultConstructorMarker $constructor_marker) {
        this(topLeft, bottomRight, windowOffset, screenOffset, windowSize, viewToWindowMatrix, node);
    }
}

