/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.LongSetKt;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0014\u001a\u00020\u0015H\u0086\bJ:\u0010\u0014\u001a\u00020\u00152!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J$\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u0003H\u0007J\u0011\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0018H\u0086\u0002J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0000J\t\u0010\"\u001a\u00020\u0003H\u0086\bJ:\u0010\"\u001a\u00020\u00032!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0010\u0010#\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u0003J9\u0010%\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u00032!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00180\u0017H\u0086\b\u00f8\u0001\u0000J\u0013\u0010'\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010)\u001a\u00020\u0018J:\u0010)\u001a\u00020\u00182!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001Jb\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0006\u0010,\u001a\u0002H+26\u0010-\u001a2\u0012\u0013\u0012\u0011H+\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(/\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002H+0.H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u00100Jw\u00101\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0006\u0010,\u001a\u0002H+2K\u0010-\u001aG\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b($\u0012\u0013\u0012\u0011H+\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(/\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002H+02H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u00103Jb\u00104\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0006\u0010,\u001a\u0002H+26\u0010-\u001a2\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u0011H+\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(/\u0012\u0004\u0012\u0002H+0.H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u00100Jw\u00105\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0006\u0010,\u001a\u0002H+2K\u0010-\u001aG\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u0011H+\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(/\u0012\u0004\u0012\u0002H+02H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u00103J:\u00106\u001a\u0002072!\u00108\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002070\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001JO\u00109\u001a\u00020726\u00108\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002070.H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J:\u0010:\u001a\u0002072!\u00108\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002070\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001JO\u0010;\u001a\u00020726\u00108\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002070.H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0013\u0010<\u001a\u00020\u00182\b\b\u0001\u0010$\u001a\u00020\u0003H\u0086\u0002J\b\u0010=\u001a\u00020\u0003H\u0016J\u000e\u0010>\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0018J:\u0010?\u001a\u00020\u00032!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J:\u0010@\u001a\u00020\u00032!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\t\u0010A\u001a\u00020\u0015H\u0086\bJ\t\u0010B\u001a\u00020\u0015H\u0086\bJ:\u0010C\u001a\u00020D2\b\b\u0002\u0010E\u001a\u00020F2\b\b\u0002\u0010G\u001a\u00020F2\b\b\u0002\u0010H\u001a\u00020F2\b\b\u0002\u0010I\u001a\u00020\u00032\b\b\u0002\u0010J\u001a\u00020FH\u0007JT\u0010C\u001a\u00020D2\b\b\u0002\u0010E\u001a\u00020F2\b\b\u0002\u0010G\u001a\u00020F2\b\b\u0002\u0010H\u001a\u00020F2\b\b\u0002\u0010I\u001a\u00020\u00032\b\b\u0002\u0010J\u001a\u00020F2\u0014\b\u0004\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020F0\u0017H\u0087\b\u00f8\u0001\u0000J\u0006\u0010L\u001a\u00020\u0018J:\u0010L\u001a\u00020\u00182!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u000e\u0010M\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0018J\t\u0010N\u001a\u00020\u0015H\u0086\bJ:\u0010O\u001a\u00020\u00152!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\b\u0010P\u001a\u00020DH\u0016R\u0018\u0010\u0005\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t8\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0007R\u0012\u0010\u000b\u001a\u00020\f8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u00038\u00c7\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u00038\u00c7\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u0082\u0001\u0001Q\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006R"}, d2={"Landroidx/collection/LongList;", "", "initialCapacity", "", "(I)V", "_size", "get_size$annotations", "()V", "content", "", "getContent$annotations", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "lastIndex", "getLastIndex", "()I", "size", "getSize", "any", "", "predicate", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "element", "binarySearch", "fromIndex", "toIndex", "contains", "containsAll", "elements", "count", "elementAt", "index", "elementAtOrElse", "defaultValue", "equals", "other", "first", "fold", "R", "initial", "operation", "Lkotlin/Function2;", "acc", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "foldIndexed", "Lkotlin/Function3;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "foldRight", "foldRightIndexed", "forEach", "", "block", "forEachIndexed", "forEachReversed", "forEachReversedIndexed", "get", "hashCode", "indexOf", "indexOfFirst", "indexOfLast", "isEmpty", "isNotEmpty", "joinToString", "", "separator", "", "prefix", "postfix", "limit", "truncated", "transform", "last", "lastIndexOf", "none", "reversedAny", "toString", "Landroidx/collection/MutableLongList;", "collection"})
@SourceDebugExtension(value={"SMAP\nLongList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongList.kt\nandroidx/collection/LongList\n*L\n1#1,972:1\n364#1:973\n367#1:974\n237#1,6:975\n265#1,6:981\n237#1,6:987\n74#1:993\n237#1,6:994\n364#1:1000\n237#1,6:1001\n237#1,6:1007\n251#1,6:1013\n265#1,6:1019\n279#1,6:1025\n251#1,6:1031\n251#1,6:1037\n279#1,6:1043\n364#1:1049\n70#1:1050\n265#1,6:1051\n279#1,6:1057\n65#1:1063\n251#1,6:1064\n251#1,6:1070\n237#1,6:1076\n74#1:1082\n485#1,10:1083\n251#1,4:1093\n495#1,9:1097\n256#1:1106\n504#1,2:1107\n485#1,10:1109\n251#1,4:1119\n495#1,9:1123\n256#1:1132\n504#1,2:1133\n485#1,10:1135\n251#1,4:1145\n495#1,9:1149\n256#1:1158\n504#1,2:1159\n485#1,10:1161\n251#1,4:1171\n495#1,9:1175\n256#1:1184\n504#1,2:1185\n485#1,10:1187\n251#1,4:1197\n495#1,9:1201\n256#1:1210\n504#1,2:1211\n*S KotlinDebug\n*F\n+ 1 LongList.kt\nandroidx/collection/LongList\n*L\n78#1:973\n83#1:974\n89#1:975,6\n103#1:981,6\n113#1:987,6\n126#1:993\n143#1:994,6\n152#1:1000\n166#1:1001,6\n182#1:1007,6\n196#1:1013,6\n212#1:1019,6\n226#1:1025,6\n328#1:1031,6\n342#1:1037,6\n355#1:1043,6\n374#1:1049\n377#1:1050\n388#1:1051,6\n401#1:1057,6\n423#1:1063\n463#1:1064,6\n494#1:1070,6\n510#1:1076,6\n523#1:1082\n-1#1:1083,10\n-1#1:1093,4\n-1#1:1097,9\n-1#1:1106\n-1#1:1107,2\n-1#1:1109,10\n-1#1:1119,4\n-1#1:1123,9\n-1#1:1132\n-1#1:1133,2\n-1#1:1135,10\n-1#1:1145,4\n-1#1:1149,9\n-1#1:1158\n-1#1:1159,2\n-1#1:1161,10\n-1#1:1171,4\n-1#1:1175,9\n-1#1:1184\n-1#1:1185,2\n-1#1:1187,10\n-1#1:1197,4\n-1#1:1201,9\n-1#1:1210\n-1#1:1211,2\n*E\n"})
public abstract class LongList {
    @JvmField
    @NotNull
    public long[] content;
    @JvmField
    public int _size;

    private LongList(int initialCapacity) {
        this.content = initialCapacity == 0 ? LongSetKt.getEmptyLongArray() : new long[initialCapacity];
    }

    @PublishedApi
    public static /* synthetic */ void getContent$annotations() {
    }

    @PublishedApi
    public static /* synthetic */ void get_size$annotations() {
    }

    @IntRange(from=0L)
    public final int getSize() {
        boolean $i$f$getSize = false;
        return this._size;
    }

    @IntRange(from=-1L)
    public final int getLastIndex() {
        boolean $i$f$getLastIndex = false;
        return this._size - 1;
    }

    @NotNull
    public final kotlin.ranges.IntRange getIndices() {
        boolean $i$f$getIndices = false;
        return RangesKt.until(0, this._size);
    }

    public final boolean none() {
        boolean $i$f$none = false;
        LongList this_$iv = this;
        boolean $i$f$isEmpty = false;
        return this_$iv._size == 0;
    }

    public final boolean any() {
        boolean $i$f$any = false;
        LongList this_$iv = this;
        boolean $i$f$isNotEmpty = false;
        return this_$iv._size != 0;
    }

    public final boolean any(@NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$any = false;
        LongList this_$iv = this;
        boolean $i$f$forEach = false;
        long[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            long it = content$iv[i$iv];
            boolean bl = false;
            if (!predicate.invoke((Long)it).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public final boolean reversedAny(@NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$reversedAny = false;
        LongList this_$iv = this;
        boolean $i$f$forEachReversed = false;
        long[] content$iv = this_$iv.content;
        for (int i$iv = this_$iv._size - 1; -1 < i$iv; --i$iv) {
            long it = content$iv[i$iv];
            boolean bl = false;
            if (!predicate.invoke((Long)it).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public final boolean contains(long element) {
        LongList this_$iv = this;
        boolean $i$f$forEach = false;
        long[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            long it = content$iv[i$iv];
            boolean bl = false;
            if (it != element) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull LongList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        LongList this_$iv = elements;
        boolean $i$f$getIndices = false;
        kotlin.ranges.IntRange intRange = RangesKt.until(0, this_$iv._size);
        int i2 = intRange.getFirst();
        int n = intRange.getLast();
        if (i2 <= n) {
            while (true) {
                if (!this.contains(elements.get(i2))) {
                    return false;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return true;
    }

    public final int count() {
        boolean $i$f$count = false;
        return this._size;
    }

    public final int count(@NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$count = false;
        int count2 = 0;
        LongList this_$iv = this;
        boolean $i$f$forEach = false;
        long[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            long it = content$iv[i$iv];
            boolean bl = false;
            if (!predicate.invoke((Long)it).booleanValue()) continue;
            ++count2;
        }
        return count2;
    }

    public final long first() {
        LongList this_$iv = this;
        boolean $i$f$isEmpty = false;
        if (this_$iv._size == 0) {
            RuntimeHelpersKt.throwNoSuchElementException("LongList is empty.");
        }
        return this.content[0];
    }

    public final long first(@NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$first = false;
        LongList this_$iv = this;
        boolean $i$f$forEach = false;
        long[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            long item2 = content$iv[i$iv];
            boolean bl = false;
            if (!predicate.invoke((Long)item2).booleanValue()) continue;
            return item2;
        }
        throw new NoSuchElementException("LongList contains no element matching the predicate.");
    }

    public final <R> R fold(R initial, @NotNull Function2<? super R, ? super Long, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        boolean $i$f$fold = false;
        Object acc = null;
        acc = initial;
        LongList this_$iv = this;
        boolean $i$f$forEach = false;
        long[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            long item2 = content$iv[i$iv];
            boolean bl = false;
            acc = operation.invoke(acc, item2);
        }
        return (R)acc;
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R foldIndexed(R initial, @NotNull Function3<? super Integer, ? super R, ? super Long, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        boolean $i$f$foldIndexed = false;
        Object acc = null;
        acc = initial;
        LongList this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] content$iv = this_$iv.content;
        int i$iv = 0;
        int n = this_$iv._size;
        while (i$iv < n) {
            void item2;
            long l = content$iv[i$iv];
            int i2 = i$iv++;
            boolean bl = false;
            acc = operation.invoke(i2, acc, (long)item2);
        }
        return (R)acc;
    }

    public final <R> R foldRight(R initial, @NotNull Function2<? super Long, ? super R, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        boolean $i$f$foldRight = false;
        Object acc = null;
        acc = initial;
        LongList this_$iv = this;
        boolean $i$f$forEachReversed = false;
        long[] content$iv = this_$iv.content;
        for (int i$iv = this_$iv._size - 1; -1 < i$iv; --i$iv) {
            long item2 = content$iv[i$iv];
            boolean bl = false;
            acc = operation.invoke(item2, acc);
        }
        return (R)acc;
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R foldRightIndexed(R initial, @NotNull Function3<? super Integer, ? super Long, ? super R, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        boolean $i$f$foldRightIndexed = false;
        Object acc = null;
        acc = initial;
        LongList this_$iv = this;
        boolean $i$f$forEachReversedIndexed = false;
        long[] content$iv = this_$iv.content;
        int i$iv = this_$iv._size - 1;
        while (-1 < i$iv) {
            void item2;
            long l = content$iv[i$iv];
            int i2 = i$iv--;
            boolean bl = false;
            acc = operation.invoke(i2, (long)item2, acc);
        }
        return (R)acc;
    }

    public final void forEach(@NotNull Function1<? super Long, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$forEach = false;
        long[] content2 = this.content;
        int n = this._size;
        for (int i2 = 0; i2 < n; ++i2) {
            block2.invoke((Long)content2[i2]);
        }
    }

    public final void forEachIndexed(@NotNull Function2<? super Integer, ? super Long, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$forEachIndexed = false;
        long[] content2 = this.content;
        int n = this._size;
        for (int i2 = 0; i2 < n; ++i2) {
            block2.invoke((Integer)i2, (Long)content2[i2]);
        }
    }

    public final void forEachReversed(@NotNull Function1<? super Long, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$forEachReversed = false;
        long[] content2 = this.content;
        for (int i2 = this._size - 1; -1 < i2; --i2) {
            block2.invoke((Long)content2[i2]);
        }
    }

    public final void forEachReversedIndexed(@NotNull Function2<? super Integer, ? super Long, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$forEachReversedIndexed = false;
        long[] content2 = this.content;
        for (int i2 = this._size - 1; -1 < i2; --i2) {
            block2.invoke((Integer)i2, (Long)content2[i2]);
        }
    }

    public final long get(@IntRange(from=0L) int index2) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        return this.content[index2];
    }

    public final long elementAt(@IntRange(from=0L) int index2) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        return this.content[index2];
    }

    public final long elementAtOrElse(@IntRange(from=0L) int index2, @NotNull Function1<? super Integer, Long> defaultValue) {
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        boolean $i$f$elementAtOrElse = false;
        if (!(0 <= index2 ? index2 < this._size : false)) {
            return ((Number)defaultValue.invoke((Integer)index2)).longValue();
        }
        return this.content[index2];
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(long element) {
        LongList this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] content$iv = this_$iv.content;
        int i$iv = 0;
        int n = this_$iv._size;
        while (i$iv < n) {
            void item2;
            long l = content$iv[i$iv];
            int i2 = i$iv++;
            boolean bl = false;
            if (element != item2) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOfFirst(@NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$indexOfFirst = false;
        LongList this_$iv = this;
        boolean $i$f$forEachIndexed = false;
        long[] content$iv = this_$iv.content;
        int i$iv = 0;
        int n = this_$iv._size;
        while (i$iv < n) {
            void item2;
            long l = content$iv[i$iv];
            int i2 = i$iv++;
            boolean bl = false;
            if (!predicate.invoke((Long)((long)item2)).booleanValue()) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOfLast(@NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$indexOfLast = false;
        LongList this_$iv = this;
        boolean $i$f$forEachReversedIndexed = false;
        long[] content$iv = this_$iv.content;
        int i$iv = this_$iv._size - 1;
        while (-1 < i$iv) {
            void item2;
            long l = content$iv[i$iv];
            int i2 = i$iv--;
            boolean bl = false;
            if (!predicate.invoke((Long)((long)item2)).booleanValue()) continue;
            return i2;
        }
        return -1;
    }

    public final boolean isEmpty() {
        boolean $i$f$isEmpty = false;
        return this._size == 0;
    }

    public final boolean isNotEmpty() {
        boolean $i$f$isNotEmpty = false;
        return this._size != 0;
    }

    public final long last() {
        LongList this_$iv = this;
        boolean $i$f$isEmpty = false;
        if (this_$iv._size == 0) {
            RuntimeHelpersKt.throwNoSuchElementException("LongList is empty.");
        }
        this_$iv = this;
        boolean $i$f$getLastIndex = false;
        return this.content[this_$iv._size - 1];
    }

    public final long last(@NotNull Function1<? super Long, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$last = false;
        LongList this_$iv = this;
        boolean $i$f$forEachReversed = false;
        long[] content$iv = this_$iv.content;
        for (int i$iv = this_$iv._size - 1; -1 < i$iv; --i$iv) {
            long item2 = content$iv[i$iv];
            boolean bl = false;
            if (!predicate.invoke((Long)item2).booleanValue()) continue;
            return item2;
        }
        throw new NoSuchElementException("LongList contains no element matching the predicate.");
    }

    /*
     * WARNING - void declaration
     */
    public final int lastIndexOf(long element) {
        LongList this_$iv = this;
        boolean $i$f$forEachReversedIndexed = false;
        long[] content$iv = this_$iv.content;
        int i$iv = this_$iv._size - 1;
        while (-1 < i$iv) {
            void item2;
            long l = content$iv[i$iv];
            int i2 = i$iv--;
            boolean bl = false;
            if (item2 != element) continue;
            return i2;
        }
        return -1;
    }

    @JvmOverloads
    public final int binarySearch(int element, int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= toIndex || toIndex > this._size) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("");
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.content[mid];
            if (midVal < (long)element) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)element) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static /* synthetic */ int binarySearch$default(LongList longList, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: binarySearch");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            LongList this_$iv = longList;
            boolean $i$f$getSize = false;
            n3 = this_$iv._size;
        }
        return longList.binarySearch(n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix, int limit, @NotNull CharSequence truncated) {
        StringBuilder stringBuilder;
        block3: {
            Intrinsics.checkNotNullParameter(separator, "separator");
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            Intrinsics.checkNotNullParameter(postfix, "postfix");
            Intrinsics.checkNotNullParameter(truncated, "truncated");
            StringBuilder $this$joinToString_u24lambda_u2430 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$joinToString_u24lambda_u2430.append(prefix);
            LongList this_$iv = this;
            boolean $i$f$forEachIndexed = false;
            long[] content$iv = this_$iv.content;
            int n = this_$iv._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                void element;
                long l = content$iv[i$iv];
                int index2 = i$iv;
                boolean bl2 = false;
                if (index2 == limit) {
                    $this$joinToString_u24lambda_u2430.append(truncated);
                    break block3;
                }
                if (index2 != 0) {
                    $this$joinToString_u24lambda_u2430.append(separator);
                }
                $this$joinToString_u24lambda_u2430.append((long)element);
            }
            $this$joinToString_u24lambda_u2430.append(postfix);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public static /* synthetic */ String joinToString$default(LongList longList, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: joinToString");
        }
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        return longList.joinToString(charSequence, charSequence2, charSequence3, n, charSequence4);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix, int limit, @NotNull CharSequence truncated, @NotNull Function1<? super Long, ? extends CharSequence> transform2) {
        StringBuilder stringBuilder;
        block3: {
            Intrinsics.checkNotNullParameter(separator, "separator");
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            Intrinsics.checkNotNullParameter(postfix, "postfix");
            Intrinsics.checkNotNullParameter(truncated, "truncated");
            Intrinsics.checkNotNullParameter(transform2, "transform");
            boolean $i$f$joinToString = false;
            StringBuilder $this$joinToString_u24lambda_u2432 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$joinToString_u24lambda_u2432.append(prefix);
            LongList this_$iv = this;
            boolean $i$f$forEachIndexed = false;
            long[] content$iv = this_$iv.content;
            int n = this_$iv._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                void element;
                long l = content$iv[i$iv];
                int index2 = i$iv;
                boolean bl2 = false;
                if (index2 == limit) {
                    $this$joinToString_u24lambda_u2432.append(truncated);
                    break block3;
                }
                if (index2 != 0) {
                    $this$joinToString_u24lambda_u2432.append(separator);
                }
                $this$joinToString_u24lambda_u2432.append(transform2.invoke((Long)((long)element)));
            }
            $this$joinToString_u24lambda_u2432.append(postfix);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ String joinToString$default(LongList $this, CharSequence separator, CharSequence prefix, CharSequence postfix, int limit, CharSequence truncated, Function1 transform2, int n, Object object) {
        block9: {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: joinToString");
            }
            if ((n & 1) != 0) {
                separator = ", ";
            }
            if ((n & 2) != 0) {
                prefix = "";
            }
            if ((n & 4) != 0) {
                postfix = "";
            }
            if ((n & 8) != 0) {
                limit = -1;
            }
            if ((n & 0x10) != 0) {
                truncated = "...";
            }
            Intrinsics.checkNotNullParameter(separator, "separator");
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            Intrinsics.checkNotNullParameter(postfix, "postfix");
            Intrinsics.checkNotNullParameter(truncated, "truncated");
            Intrinsics.checkNotNullParameter(transform2, "transform");
            boolean $i$f$joinToString = false;
            Object $this$joinToString_u24lambda_u2432 = object = new StringBuilder();
            boolean bl = false;
            ((StringBuilder)$this$joinToString_u24lambda_u2432).append(prefix);
            LongList this_$iv = $this;
            boolean $i$f$forEachIndexed = false;
            long[] content$iv = this_$iv.content;
            int n2 = this_$iv._size;
            for (int i$iv = 0; i$iv < n2; ++i$iv) {
                void element;
                long l = content$iv[i$iv];
                int index2 = i$iv;
                boolean bl2 = false;
                if (index2 == limit) {
                    ((StringBuilder)$this$joinToString_u24lambda_u2432).append(truncated);
                    break block9;
                }
                if (index2 != 0) {
                    ((StringBuilder)$this$joinToString_u24lambda_u2432).append(separator);
                }
                ((StringBuilder)$this$joinToString_u24lambda_u2432).append((CharSequence)transform2.invoke((long)element));
            }
            ((StringBuilder)$this$joinToString_u24lambda_u2432).append(postfix);
        }
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public int hashCode() {
        int hashCode = 0;
        LongList this_$iv = this;
        boolean $i$f$forEach = false;
        long[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            long element = content$iv[i$iv];
            boolean bl = false;
            hashCode += 31 * Long.hashCode(element);
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object other) {
        int n;
        if (!(other instanceof LongList) || ((LongList)other)._size != this._size) {
            return false;
        }
        long[] content2 = this.content;
        long[] otherContent = ((LongList)other).content;
        LongList this_$iv = this;
        boolean $i$f$getIndices = false;
        kotlin.ranges.IntRange intRange = RangesKt.until(0, this_$iv._size);
        int i2 = intRange.getFirst();
        if (i2 <= (n = intRange.getLast())) {
            while (true) {
                if (content2[i2] != otherContent[i2]) {
                    return false;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return true;
    }

    @NotNull
    public String toString() {
        return LongList.joinToString$default(this, null, "[", "]", 0, null, 25, null);
    }

    @JvmOverloads
    public final int binarySearch(int element, int fromIndex) {
        return LongList.binarySearch$default(this, element, fromIndex, 0, 4, null);
    }

    @JvmOverloads
    public final int binarySearch(int element) {
        return LongList.binarySearch$default(this, element, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix, int limit) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(postfix, "postfix");
        return LongList.joinToString$default(this, separator, prefix, postfix, limit, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(postfix, "postfix");
        return LongList.joinToString$default(this, separator, prefix, postfix, 0, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        return LongList.joinToString$default(this, separator, prefix, null, 0, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        return LongList.joinToString$default(this, separator, null, null, 0, null, 30, null);
    }

    @JvmOverloads
    @NotNull
    public final String joinToString() {
        return LongList.joinToString$default(this, null, null, null, 0, null, 31, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix, int limit, @NotNull Function1<? super Long, ? extends CharSequence> transform2) {
        StringBuilder stringBuilder;
        block3: {
            Intrinsics.checkNotNullParameter(separator, "separator");
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            Intrinsics.checkNotNullParameter(postfix, "postfix");
            Intrinsics.checkNotNullParameter(transform2, "transform");
            boolean $i$f$joinToString = false;
            CharSequence truncated$iv = "...";
            boolean $i$f$joinToString2 = false;
            StringBuilder $this$joinToString_u24lambda_u2432$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$joinToString_u24lambda_u2432$iv.append(prefix);
            LongList this_$iv$iv = this;
            boolean $i$f$forEachIndexed = false;
            long[] content$iv$iv = this_$iv$iv.content;
            int n = this_$iv$iv._size;
            for (int i$iv$iv = 0; i$iv$iv < n; ++i$iv$iv) {
                void element$iv;
                long l = content$iv$iv[i$iv$iv];
                int index$iv = i$iv$iv;
                boolean bl2 = false;
                if (index$iv == limit) {
                    $this$joinToString_u24lambda_u2432$iv.append(truncated$iv);
                    break block3;
                }
                if (index$iv != 0) {
                    $this$joinToString_u24lambda_u2432$iv.append(separator);
                }
                $this$joinToString_u24lambda_u2432$iv.append(transform2.invoke((Long)((long)element$iv)));
            }
            $this$joinToString_u24lambda_u2432$iv.append(postfix);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix, @NotNull Function1<? super Long, ? extends CharSequence> transform2) {
        StringBuilder stringBuilder;
        block3: {
            Intrinsics.checkNotNullParameter(separator, "separator");
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            Intrinsics.checkNotNullParameter(postfix, "postfix");
            Intrinsics.checkNotNullParameter(transform2, "transform");
            boolean $i$f$joinToString = false;
            int limit$iv = -1;
            CharSequence truncated$iv = "...";
            boolean $i$f$joinToString2 = false;
            StringBuilder $this$joinToString_u24lambda_u2432$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$joinToString_u24lambda_u2432$iv.append(prefix);
            LongList this_$iv$iv = this;
            boolean $i$f$forEachIndexed = false;
            long[] content$iv$iv = this_$iv$iv.content;
            int n = this_$iv$iv._size;
            for (int i$iv$iv = 0; i$iv$iv < n; ++i$iv$iv) {
                void element$iv;
                long l = content$iv$iv[i$iv$iv];
                int index$iv = i$iv$iv;
                boolean bl2 = false;
                if (index$iv == limit$iv) {
                    $this$joinToString_u24lambda_u2432$iv.append(truncated$iv);
                    break block3;
                }
                if (index$iv != 0) {
                    $this$joinToString_u24lambda_u2432$iv.append(separator);
                }
                $this$joinToString_u24lambda_u2432$iv.append(transform2.invoke((Long)((long)element$iv)));
            }
            $this$joinToString_u24lambda_u2432$iv.append(postfix);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull Function1<? super Long, ? extends CharSequence> transform2) {
        StringBuilder stringBuilder;
        block3: {
            Intrinsics.checkNotNullParameter(separator, "separator");
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            Intrinsics.checkNotNullParameter(transform2, "transform");
            boolean $i$f$joinToString = false;
            CharSequence postfix$iv = "";
            int limit$iv = -1;
            CharSequence truncated$iv = "...";
            boolean $i$f$joinToString2 = false;
            StringBuilder $this$joinToString_u24lambda_u2432$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$joinToString_u24lambda_u2432$iv.append(prefix);
            LongList this_$iv$iv = this;
            boolean $i$f$forEachIndexed = false;
            long[] content$iv$iv = this_$iv$iv.content;
            int n = this_$iv$iv._size;
            for (int i$iv$iv = 0; i$iv$iv < n; ++i$iv$iv) {
                void element$iv;
                long l = content$iv$iv[i$iv$iv];
                int index$iv = i$iv$iv;
                boolean bl2 = false;
                if (index$iv == limit$iv) {
                    $this$joinToString_u24lambda_u2432$iv.append(truncated$iv);
                    break block3;
                }
                if (index$iv != 0) {
                    $this$joinToString_u24lambda_u2432$iv.append(separator);
                }
                $this$joinToString_u24lambda_u2432$iv.append(transform2.invoke((Long)((long)element$iv)));
            }
            $this$joinToString_u24lambda_u2432$iv.append(postfix$iv);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull CharSequence separator, @NotNull Function1<? super Long, ? extends CharSequence> transform2) {
        StringBuilder stringBuilder;
        block3: {
            Intrinsics.checkNotNullParameter(separator, "separator");
            Intrinsics.checkNotNullParameter(transform2, "transform");
            boolean $i$f$joinToString = false;
            CharSequence prefix$iv = "";
            CharSequence postfix$iv = "";
            int limit$iv = -1;
            CharSequence truncated$iv = "...";
            boolean $i$f$joinToString2 = false;
            StringBuilder $this$joinToString_u24lambda_u2432$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$joinToString_u24lambda_u2432$iv.append(prefix$iv);
            LongList this_$iv$iv = this;
            boolean $i$f$forEachIndexed = false;
            long[] content$iv$iv = this_$iv$iv.content;
            int n = this_$iv$iv._size;
            for (int i$iv$iv = 0; i$iv$iv < n; ++i$iv$iv) {
                void element$iv;
                long l = content$iv$iv[i$iv$iv];
                int index$iv = i$iv$iv;
                boolean bl2 = false;
                if (index$iv == limit$iv) {
                    $this$joinToString_u24lambda_u2432$iv.append(truncated$iv);
                    break block3;
                }
                if (index$iv != 0) {
                    $this$joinToString_u24lambda_u2432$iv.append(separator);
                }
                $this$joinToString_u24lambda_u2432$iv.append(transform2.invoke((Long)((long)element$iv)));
            }
            $this$joinToString_u24lambda_u2432$iv.append(postfix$iv);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String joinToString(@NotNull Function1<? super Long, ? extends CharSequence> transform2) {
        StringBuilder stringBuilder;
        block3: {
            Intrinsics.checkNotNullParameter(transform2, "transform");
            boolean $i$f$joinToString = false;
            CharSequence separator$iv = ", ";
            CharSequence prefix$iv = "";
            CharSequence postfix$iv = "";
            int limit$iv = -1;
            CharSequence truncated$iv = "...";
            boolean $i$f$joinToString2 = false;
            StringBuilder $this$joinToString_u24lambda_u2432$iv = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$joinToString_u24lambda_u2432$iv.append(prefix$iv);
            LongList this_$iv$iv = this;
            boolean $i$f$forEachIndexed = false;
            long[] content$iv$iv = this_$iv$iv.content;
            int n = this_$iv$iv._size;
            for (int i$iv$iv = 0; i$iv$iv < n; ++i$iv$iv) {
                void element$iv;
                long l = content$iv$iv[i$iv$iv];
                int index$iv = i$iv$iv;
                boolean bl2 = false;
                if (index$iv == limit$iv) {
                    $this$joinToString_u24lambda_u2432$iv.append(truncated$iv);
                    break block3;
                }
                if (index$iv != 0) {
                    $this$joinToString_u24lambda_u2432$iv.append(separator$iv);
                }
                $this$joinToString_u24lambda_u2432$iv.append(transform2.invoke((Long)((long)element$iv)));
            }
            $this$joinToString_u24lambda_u2432$iv.append(postfix$iv);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public /* synthetic */ LongList(int initialCapacity, DefaultConstructorMarker $constructor_marker) {
        this(initialCapacity);
    }
}

