/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.collection.MutableScatterMap;
import androidx.collection.ScatterMap;
import androidx.collection.ScatterMapKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessible;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0001\u0018\u00002\u00020\u0001:\u00016B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\bH\u0002J \u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0006\u0010(\u001a\u00020\tJ\u000e\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\tH\u0002J\b\u0010-\u001a\u00020\tH\u0002J\u0006\u0010.\u001a\u00020\tJ\u000e\u0010/\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u00067"}, d2={"Landroidx/compose/ui/platform/a11y/AccessibilityController;", "", "owner", "Landroidx/compose/ui/semantics/SemanticsOwner;", "desktopComponent", "Landroidx/compose/ui/platform/PlatformComponent;", "onFocusReceived", "Lkotlin/Function1;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "", "<init>", "(Landroidx/compose/ui/semantics/SemanticsOwner;Landroidx/compose/ui/platform/PlatformComponent;Lkotlin/jvm/functions/Function1;)V", "getOwner", "()Landroidx/compose/ui/semantics/SemanticsOwner;", "getDesktopComponent", "()Landroidx/compose/ui/platform/PlatformComponent;", "accessibleByNodeId", "Landroidx/collection/MutableScatterMap;", "", "nodeMappingIsValid", "", "nodeId", "onNodeAdded", "accessible", "onNodeRemoved", "onNodeChanged", "component", "previousSemanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "newSemanticsNode", "nodeSyncChannel", "Lkotlinx/coroutines/channels/Channel;", "bfsDeque", "Lkotlin/collections/ArrayDeque;", "auxAccessibleByNodeId", "delayedNodeNotifications", "", "Lkotlin/Function0;", "syncingJob", "Lkotlinx/coroutines/Job;", "dispose", "launchSyncLoop", "context", "Lkotlin/coroutines/CoroutineContext;", "syncNodes", "scheduleNodeSyncIfNeeded", "onSemanticsChange", "onLayoutChanged", "rootSemanticNode", "getRootSemanticNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "rootAccessible", "getRootAccessible", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "AccessibilityUsage", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAccessibilityController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityController.kt\nandroidx/compose/ui/platform/a11y/AccessibilityController\n+ 2 ScatterMap.kt\nandroidx/collection/ScatterMap\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n357#2,4:426\n329#2,6:430\n339#2,3:437\n342#2,9:441\n361#2:450\n1399#3:436\n1270#3:440\n1#4:451\n*S KotlinDebug\n*F\n+ 1 AccessibilityController.kt\nandroidx/compose/ui/platform/a11y/AccessibilityController\n*L\n270#1:426,4\n270#1:430,6\n270#1:437,3\n270#1:441,9\n270#1:450\n270#1:436\n270#1:440\n*E\n"})
public final class AccessibilityController {
    @NotNull
    private final SemanticsOwner owner;
    @NotNull
    private final PlatformComponent desktopComponent;
    @NotNull
    private final Function1<ComposeAccessible, Unit> onFocusReceived;
    @NotNull
    private MutableScatterMap<Integer, ComposeAccessible> accessibleByNodeId;
    private boolean nodeMappingIsValid;
    @NotNull
    private final Channel<Unit> nodeSyncChannel;
    @NotNull
    private final ArrayDeque<SemanticsNode> bfsDeque;
    @NotNull
    private MutableScatterMap<Integer, ComposeAccessible> auxAccessibleByNodeId;
    @NotNull
    private final List<Function0<Unit>> delayedNodeNotifications;
    @Nullable
    private Job syncingJob;
    public static final int $stable = 8;

    public AccessibilityController(@NotNull SemanticsOwner owner2, @NotNull PlatformComponent desktopComponent, @NotNull Function1<? super ComposeAccessible, Unit> onFocusReceived) {
        Intrinsics.checkNotNullParameter(owner2, "owner");
        Intrinsics.checkNotNullParameter(desktopComponent, "desktopComponent");
        Intrinsics.checkNotNullParameter(onFocusReceived, "onFocusReceived");
        this.owner = owner2;
        this.desktopComponent = desktopComponent;
        this.onFocusReceived = onFocusReceived;
        this.accessibleByNodeId = ScatterMapKt.mutableScatterMapOf();
        this.nodeSyncChannel = ChannelKt.Channel$default(0, null, null, 6, null);
        this.bfsDeque = new ArrayDeque();
        this.auxAccessibleByNodeId = ScatterMapKt.mutableScatterMapOf();
        this.delayedNodeNotifications = new ArrayList();
    }

    @NotNull
    public final SemanticsOwner getOwner() {
        return this.owner;
    }

    @NotNull
    public final PlatformComponent getDesktopComponent() {
        return this.desktopComponent;
    }

    @Nullable
    public final ComposeAccessible accessibleByNodeId(int nodeId) {
        if (!this.nodeMappingIsValid) {
            this.syncNodes();
        }
        return (ComposeAccessible)this.accessibleByNodeId.get(nodeId);
    }

    private final void onNodeAdded(ComposeAccessible accessible) {
    }

    private final void onNodeRemoved(ComposeAccessible accessible) {
        accessible.setRemoved(true);
    }

    private final void onNodeChanged(ComposeAccessible component, SemanticsNode previousSemanticsNode, SemanticsNode newSemanticsNode) {
        block4: for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : newSemanticsNode.getConfig()) {
            Object prev = SemanticsConfigurationKt.getOrNull(previousSemanticsNode.getConfig(), entry.getKey());
            if (Intrinsics.areEqual(entry.getValue(), prev)) continue;
            SemanticsPropertyKey<?> semanticsPropertyKey = entry.getKey();
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getText())) {
                component.getComposeAccessibleContext().firePropertyChange("AccessibleText", prev, entry.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getEditableText())) {
                component.getComposeAccessibleContext().firePropertyChange("AccessibleText", prev, entry.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getTextSelectionRange())) {
                ComposeAccessible.ComposeAccessibleComponent composeAccessibleComponent = component.getComposeAccessibleContext();
                TextRange textRange = prev instanceof TextRange ? (TextRange)prev : null;
                Integer n = textRange != null ? Integer.valueOf(TextRange.getStart-impl(textRange.unbox-impl())) : null;
                Object object = entry.getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type androidx.compose.ui.text.TextRange");
                composeAccessibleComponent.firePropertyChange("AccessibleCaret", n, TextRange.getStart-impl(((TextRange)object).unbox-impl()));
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getFocused())) {
                Object object = entry.getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
                if (((Boolean)object).booleanValue()) {
                    component.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                    this.onFocusReceived.invoke(component);
                    continue;
                }
                component.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getToggleableState())) {
                Object object = entry.getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type androidx.compose.ui.state.ToggleableState");
                switch (WhenMappings.$EnumSwitchMapping$0[((ToggleableState)((Object)object)).ordinal()]) {
                    case 1: {
                        component.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                        continue block4;
                    }
                    case 2: 
                    case 3: {
                        component.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                        continue block4;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            if (!Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getProgressBarRangeInfo())) continue;
            Object object = entry.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type androidx.compose.ui.semantics.ProgressBarRangeInfo");
            ProgressBarRangeInfo value = (ProgressBarRangeInfo)object;
            ProgressBarRangeInfo progressBarRangeInfo = prev instanceof ProgressBarRangeInfo ? (ProgressBarRangeInfo)prev : null;
            component.getComposeAccessibleContext().firePropertyChange("AccessibleValue", progressBarRangeInfo != null ? Float.valueOf(progressBarRangeInfo.getCurrent()) : null, Float.valueOf(value.getCurrent()));
        }
    }

    public final void dispose() {
        block0: {
            Job job2 = this.syncingJob;
            if (job2 == null) break block0;
            Job.DefaultImpls.cancel$default(job2, null, 1, null);
        }
    }

    public final void launchSyncLoop(@NotNull CoroutineContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        if (this.syncingJob != null) {
            throw new IllegalStateException("Sync loop already running");
        }
        this.syncingJob = BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(context2), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccessibilityController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = AccessibilityUsage.INSTANCE.runActiveController(this.this$0, (Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ AccessibilityController this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(var1_1);
lbl6:
                                        // 2 sources

                                        while (true) {
                                            this.label = 1;
                                            v0 = AccessibilityController.access$getNodeSyncChannel$p(this.this$0).receive(this);
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl15
                                            break;
                                        }
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure($result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        AccessibilityController.access$syncNodes(this.this$0);
                                        ** continue;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void syncNodes() {
        MutableScatterMap<Integer, ComposeAccessible> previous2 = this.accessibleByNodeId;
        MutableScatterMap<Integer, ComposeAccessible> updated = this.auxAccessibleByNodeId;
        if (AccessibilityController.syncNodes$isValid(this.getRootSemanticNode())) {
            this.bfsDeque.add(this.getRootSemanticNode());
        }
        while (!((Collection)this.bfsDeque).isEmpty()) {
            ComposeAccessible composeAccessible;
            SemanticsNode node2 = this.bfsDeque.removeFirst();
            if (AccessibilityController.syncNodes$isInvisibleToA11y(node2)) continue;
            ComposeAccessible composeAccessible2 = (ComposeAccessible)previous2.get(node2.getId());
            Integer n = node2.getId();
            if (composeAccessible2 != null) {
                SemanticsNode prevSemanticsNode = composeAccessible2.getSemanticsNode();
                composeAccessible2.setSemanticsNode(node2);
                this.delayedNodeNotifications.add(() -> AccessibilityController.syncNodes$lambda$2(this, composeAccessible2, prevSemanticsNode, node2));
                composeAccessible = composeAccessible2;
            } else {
                ComposeAccessible newAccessible = new ComposeAccessible(node2, this);
                this.delayedNodeNotifications.add(() -> AccessibilityController.syncNodes$lambda$3(this, newAccessible));
                composeAccessible = newAccessible;
            }
            updated.set(n, composeAccessible);
            for (SemanticsNode child : CollectionsKt.asReversed(node2.getReplacedChildren$ui())) {
                if (!AccessibilityController.syncNodes$isValid(child)) continue;
                this.bfsDeque.add(child);
            }
        }
        ScatterMap this_$iv = previous2;
        boolean bl = false;
        Object[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        ScatterMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv = 0;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl2 = false;
                            ComposeAccessible composeAccessible = (ComposeAccessible)v$iv[index$iv];
                            int id = ((Number)k$iv[index$iv]).intValue();
                            boolean bl22 = false;
                            if (!updated.contains(id)) {
                                void node3;
                                this.delayedNodeNotifications.add(() -> AccessibilityController.syncNodes$lambda$5$lambda$4(this, (ComposeAccessible)node3));
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        MutableScatterMap<Integer, ComposeAccessible> mutableScatterMap = previous2;
        MutableScatterMap<Integer, ComposeAccessible> mutableScatterMap2 = mutableScatterMap;
        AccessibilityController accessibilityController = this;
        boolean bl3 = false;
        mutableScatterMap2.clear();
        accessibilityController.auxAccessibleByNodeId = mutableScatterMap;
        this.accessibleByNodeId = updated;
        this.nodeMappingIsValid = true;
        for (Function0 function0 : this.delayedNodeNotifications) {
            function0.invoke();
        }
        this.delayedNodeNotifications.clear();
    }

    private final void scheduleNodeSyncIfNeeded() {
        if (AccessibilityUsage.INSTANCE.getRecentlyUsed() && !this.nodeMappingIsValid) {
            this.nodeSyncChannel.trySend-JP2dKIU(Unit.INSTANCE);
        }
    }

    public final void onSemanticsChange() {
        this.nodeMappingIsValid = false;
        this.scheduleNodeSyncIfNeeded();
    }

    public final void onLayoutChanged(int nodeId) {
        this.nodeMappingIsValid = false;
        this.scheduleNodeSyncIfNeeded();
    }

    private final SemanticsNode getRootSemanticNode() {
        return this.owner.getRootSemanticsNode();
    }

    @NotNull
    public final ComposeAccessible getRootAccessible() {
        ComposeAccessible composeAccessible = this.accessibleByNodeId(this.getRootSemanticNode().getId());
        Intrinsics.checkNotNull(composeAccessible);
        return composeAccessible;
    }

    private static final boolean syncNodes$isValid(SemanticsNode $this$syncNodes_u24isValid) {
        LayoutNode it = $this$syncNodes_u24isValid.getLayoutNode$ui();
        boolean bl = false;
        return it.isPlaced() && it.isAttached();
    }

    private static final boolean syncNodes$isInvisibleToA11y(SemanticsNode $this$syncNodes_u24isInvisibleToA11y) {
        SemanticsConfiguration it = $this$syncNodes_u24isInvisibleToA11y.getConfig();
        boolean bl = false;
        return it.contains(SemanticsProperties.INSTANCE.getInvisibleToUser()) || it.contains(SemanticsProperties.INSTANCE.getHideFromAccessibility());
    }

    private static final Unit syncNodes$lambda$2(AccessibilityController this$0, ComposeAccessible $existingAccessible, SemanticsNode $prevSemanticsNode, SemanticsNode $node) {
        this$0.onNodeChanged($existingAccessible, $prevSemanticsNode, $node);
        return Unit.INSTANCE;
    }

    private static final Unit syncNodes$lambda$3(AccessibilityController this$0, ComposeAccessible $newAccessible) {
        this$0.onNodeAdded($newAccessible);
        return Unit.INSTANCE;
    }

    private static final Unit syncNodes$lambda$5$lambda$4(AccessibilityController this$0, ComposeAccessible $node) {
        this$0.onNodeRemoved($node);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Channel access$getNodeSyncChannel$p(AccessibilityController $this) {
        return $this.nodeSyncChannel;
    }

    public static final /* synthetic */ void access$syncNodes(AccessibilityController $this) {
        $this.syncNodes();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0006\u0010\r\u001a\u00020\u000bJ4\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\b2\u001c\u0010\u0014\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/platform/a11y/AccessibilityController$AccessibilityUsage;", "", "<init>", "()V", "MaxIdleTimeNanos", "", "activeControllers", "", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "lastUseTimeNanos", "reset", "", "reset$ui", "notifyInUse", "recentlyUsed", "", "getRecentlyUsed", "()Z", "runActiveController", "controller", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Landroidx/compose/ui/platform/a11y/AccessibilityController;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ui"})
    @StabilityInferred(parameters=0)
    public static final class AccessibilityUsage {
        @NotNull
        public static final AccessibilityUsage INSTANCE = new AccessibilityUsage();
        private static final long MaxIdleTimeNanos = Duration.getInWholeNanoseconds-impl(DurationKt.toDuration(5, DurationUnit.MINUTES));
        @NotNull
        private static final Set<AccessibilityController> activeControllers = new LinkedHashSet();
        private static long lastUseTimeNanos = System.nanoTime() - (MaxIdleTimeNanos + 1L);
        public static final int $stable = 8;

        private AccessibilityUsage() {
        }

        public final void reset$ui() {
            boolean bl = activeControllers.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            lastUseTimeNanos = System.nanoTime() - (MaxIdleTimeNanos + 1L);
        }

        public final void notifyInUse() {
            lastUseTimeNanos = System.nanoTime();
            for (AccessibilityController controller : activeControllers) {
                controller.scheduleNodeSyncIfNeeded();
            }
        }

        public final boolean getRecentlyUsed() {
            return System.nanoTime() - lastUseTimeNanos < MaxIdleTimeNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final Object runActiveController(@NotNull AccessibilityController var1_1, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> var2_2, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof runActiveController.1)) ** GOTO lbl-1000
            var6_4 = $completion;
            if ((var6_4.label & -2147483648) != 0) {
                var6_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AccessibilityUsage this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runActiveController(null, null, this);
                    }
                };
            }
            $result = $continuation.result;
            var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    AccessibilityUsage.activeControllers.add(controller);
                    $continuation.L$0 = controller;
                    $continuation.label = 1;
                    v0 = block.invoke($continuation);
                    ** if (v0 != var7_6) goto lbl21
lbl20:
                    // 1 sources

                    return var7_6;
lbl21:
                    // 1 sources

                    ** GOTO lbl35
                }
                case 1: {
                    controller = (AccessibilityController)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                    }
                    catch (Throwable var4_7) {
                        throw var4_7;
                    }
                    finally {
                        AccessibilityUsage.activeControllers.remove(controller);
                    }
lbl35:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToggleableState.values().length];
            try {
                nArray[ToggleableState.On.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToggleableState.Off.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToggleableState.Indeterminate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

